/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JoinAreasAction;
import org.openstreetmap.josm.actions.PurgeAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Territories;
import org.openstreetmap.josm.tools.UserCancelException;

public final class RightAndLefthandTraffic {
    private static final String DRIVING_SIDE = "driving_side";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static volatile GeoPropertyIndex<Boolean> rlCache;

    private RightAndLefthandTraffic() {
    }

    public static synchronized boolean isRightHandTraffic(LatLon latLon) {
        return rlCache.get(latLon) == false;
    }

    public static synchronized void initialize() {
        Collection<Way> collection = RightAndLefthandTraffic.loadOptimizedBoundaries();
        if (collection.isEmpty()) {
            collection = RightAndLefthandTraffic.computeOptimizedBoundaries();
            RightAndLefthandTraffic.saveOptimizedBoundaries(collection);
        }
        rlCache = new GeoPropertyIndex<Boolean>(new DefaultGeoProperty(collection), 24);
    }

    private static Collection<Way> computeOptimizedBoundaries() {
        ArrayList<Way> arrayList = new ArrayList<Way>();
        ArrayList<OsmPrimitive> arrayList2 = new ArrayList<OsmPrimitive>();
        DataSet dataSet = Territories.getDataSet();
        Collection<Relation> collection = dataSet.getRelations();
        Collection<Way> collection2 = dataSet.getWays();
        for (Way object2 : collection2) {
            if (!LEFT.equals(object2.get(DRIVING_SIDE))) continue;
            RightAndLefthandTraffic.addWayIfNotInner(arrayList, object2);
        }
        for (Relation relation : collection) {
            if (!relation.isMultipolygon() || !LEFT.equals(relation.get(DRIVING_SIDE))) continue;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.isWay() || !"outer".equals(relationMember.getRole()) || RIGHT.equals(relationMember.getMember().get(DRIVING_SIDE))) continue;
                RightAndLefthandTraffic.addWayIfNotInner(arrayList, (Way)relationMember.getMember());
            }
        }
        arrayList2.addAll(collection);
        arrayList2.addAll(collection2);
        arrayList2.removeAll(arrayList);
        for (Relation relation : OsmPrimitive.getParentRelations(arrayList)) {
            relation.setMembers(null);
        }
        for (Way way : arrayList) {
            way.removeAll();
        }
        new PurgeAction(false).getPurgeCommand(arrayList2).executeCommand();
        ArrayList arrayList3 = new ArrayList();
        List<JoinAreasAction.Multipolygon> list = JoinAreasAction.collectMultipolygons(arrayList);
        if (list != null) {
            try {
                JoinAreasAction.JoinAreasResult joinAreasResult = new JoinAreasAction(false).joinAreas(list);
                if (joinAreasResult.hasChanges()) {
                    for (JoinAreasAction.Multipolygon multipolygon : joinAreasResult.getPolygons()) {
                        arrayList3.add(multipolygon.getOuterWay());
                    }
                }
            }
            catch (UserCancelException userCancelException) {
                Main.warn(userCancelException);
            }
            catch (JosmRuntimeException josmRuntimeException) {
                Main.error(josmRuntimeException);
            }
        }
        if (arrayList3.isEmpty()) {
            Main.warn("Unable to join left-driving countries polygons");
            arrayList3.addAll(arrayList);
        }
        return arrayList3;
    }

    private static void addWayIfNotInner(Collection<Way> collection, Way way) {
        Set<Way> set = Collections.singleton(way);
        for (Relation relation : OsmPrimitive.getParentRelations(set)) {
            if (!relation.isMultipolygon() || !LEFT.equals(relation.get(DRIVING_SIDE)) || !"inner".equals(relation.getMembersFor(set).iterator().next().getRole())) continue;
            if (Main.isDebugEnabled()) {
                Main.debug("Skipping " + way.get("name:en") + " because inner part of " + relation.get("name:en"));
            }
            return;
        }
        collection.add(way);
    }

    private static void saveOptimizedBoundaries(Collection<Way> collection) {
        DataSet dataSet = collection.iterator().next().getDataSet();
        File file = new File(Main.pref.getCacheDirectory(), "left-right-hand-traffic.osm");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
             OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(outputStreamWriter), false, dataSet.getVersion());){
            osmWriter.header(Boolean.FALSE);
            osmWriter.writeContent(dataSet);
            osmWriter.footer();
        }
        catch (IOException iOException) {
            throw new JosmRuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Collection<Way> loadOptimizedBoundaries() {
        try (FileInputStream fileInputStream = new FileInputStream(new File(Main.pref.getCacheDirectory(), "left-right-hand-traffic.osm"));){
            Collection<Way> collection = OsmReader.parseDataSet(fileInputStream, null).getWays();
            return collection;
        }
        catch (IOException | IllegalDataException exception) {
            Main.trace(exception);
            return Collections.emptyList();
        }
    }
}

