/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class TruffleMap<K, V>
extends AbstractMap<K, V> {
    private final TypeAndClass<K> keyType;
    private final TypeAndClass<V> valueType;
    private final TruffleObject obj;

    private TruffleMap(TypeAndClass<K> keyType, TypeAndClass<V> valueType, TruffleObject obj) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.obj = obj;
    }

    static <K, V> Map<K, V> create(TypeAndClass<K> keyType, TypeAndClass<V> valueType, TruffleObject foreignObject) {
        return new TruffleMap<K, V>(keyType, valueType, foreignObject);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        try {
            Object props = ToJavaNode.message(null, Message.KEYS, this.obj, new Object[0]);
            if (Boolean.TRUE.equals(ToJavaNode.message(null, Message.HAS_SIZE, props, new Object[0]))) {
                Number size = (Number)ToJavaNode.message(null, Message.GET_SIZE, props, new Object[0]);
                return new LazyEntries(props, size.intValue());
            }
            return Collections.emptySet();
        }
        catch (InteropException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public V get(Object key) {
        this.keyType.cast(key);
        try {
            Object item = ToJavaNode.message(this.valueType, Message.READ, this.obj, key);
            Object javaItem = ToJavaNode.toJava(item, this.valueType);
            return this.valueType.cast(javaItem);
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public V put(K key, V value) {
        this.keyType.cast(key);
        this.valueType.cast(value);
        try {
            V previous = this.get(key);
            ToJavaNode.message(this.valueType, Message.WRITE, this.obj, key, value);
            return previous;
        }
        catch (InteropException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class TruffleEntry
    implements Map.Entry<K, V> {
        private final K key;

        TruffleEntry(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            try {
                Object value = ToJavaNode.message(TruffleMap.this.valueType, Message.READ, TruffleMap.this.obj, this.key);
                return TruffleMap.this.valueType.cast(value);
            }
            catch (InteropException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public V setValue(V value) {
            try {
                Object prev = this.getValue();
                ToJavaNode.message(null, Message.WRITE, TruffleMap.this.obj, this.key, value);
                return prev;
            }
            catch (InteropException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    private final class LazyEntries
    extends AbstractSet<Map.Entry<K, V>> {
        private final Object props;
        private final int size;

        LazyEntries(Object props, int size) {
            this.props = props;
            this.size = size;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new LazyIterator();
        }

        @Override
        public int size() {
            return this.size;
        }

        private final class LazyIterator
        implements Iterator<Map.Entry<K, V>> {
            private int index = 0;

            LazyIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < LazyEntries.this.size;
            }

            @Override
            public Map.Entry<K, V> next() {
                Object key;
                try {
                    key = ToJavaNode.message(TruffleMap.this.keyType, Message.READ, LazyEntries.this.props, this.index++);
                }
                catch (InteropException e) {
                    throw new IllegalStateException(e);
                }
                return new TruffleEntry(TruffleMap.this.keyType.cast(key));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        }
    }
}

