/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.NodeFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveNodeConstructor;
import org.jruby.truffle.language.RubyNode;

public class PrimitiveManager {
    private final Map<String, PrimitiveNodeConstructor> primitives = new ConcurrentHashMap<String, PrimitiveNodeConstructor>();

    public PrimitiveNodeConstructor getPrimitive(String name) {
        PrimitiveNodeConstructor constructor = this.primitives.get(name);
        if (constructor == null) {
            return this.primitives.get("undefined");
        }
        return constructor;
    }

    public void addPrimitive(NodeFactory<? extends RubyNode> nodeFactory, Primitive annotation) {
        this.primitives.put(annotation.name(), new PrimitiveNodeConstructor(annotation, nodeFactory));
    }
}

