/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.ProcessNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ProcessNodes.class)
public final class ProcessNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ClockGetTimeNodeFactory.getInstance(), PidNodeFactory.getInstance());
    }

    @GeneratedBy(value=ProcessNodes.PidNode.class)
    public static final class PidNodeFactory
    implements NodeFactory<ProcessNodes.PidNode> {
        private static PidNodeFactory pidNodeFactoryInstance;

        private PidNodeFactory() {
        }

        @Override
        public Class<ProcessNodes.PidNode> getNodeClass() {
            return ProcessNodes.PidNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(new Object[0]);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode[].class));
        }

        @Override
        public ProcessNodes.PidNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PidNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ProcessNodes.PidNode> getInstance() {
            if (pidNodeFactoryInstance == null) {
                pidNodeFactoryInstance = new PidNodeFactory();
            }
            return pidNodeFactoryInstance;
        }

        public static ProcessNodes.PidNode create(RubyNode[] arguments) {
            return new PidNodeGen(arguments);
        }

        @GeneratedBy(value=ProcessNodes.PidNode.class)
        public static final class PidNodeGen
        extends ProcessNodes.PidNode {
            private PidNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.pid();
            }
        }
    }

    @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
    public static final class ClockGetTimeNodeFactory
    implements NodeFactory<ProcessNodes.ClockGetTimeNode> {
        private static ClockGetTimeNodeFactory clockGetTimeNodeFactoryInstance;

        private ClockGetTimeNodeFactory() {
        }

        @Override
        public Class<ProcessNodes.ClockGetTimeNode> getNodeClass() {
            return ProcessNodes.ClockGetTimeNode.class;
        }

        @Override
        public List getExecutionSignature() {
            return Arrays.asList(RubyNode.class, RubyNode.class);
        }

        @Override
        public List getNodeSignatures() {
            return Arrays.asList(Arrays.asList(RubyNode.class, RubyNode.class));
        }

        @Override
        public ProcessNodes.ClockGetTimeNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return ClockGetTimeNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ProcessNodes.ClockGetTimeNode> getInstance() {
            if (clockGetTimeNodeFactoryInstance == null) {
                clockGetTimeNodeFactoryInstance = new ClockGetTimeNodeFactory();
            }
            return clockGetTimeNodeFactoryInstance;
        }

        public static ProcessNodes.ClockGetTimeNode create(RubyNode clock_id, RubyNode unit) {
            return new ClockGetTimeNodeGen(clock_id, unit);
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        public static final class ClockGetTimeNodeGen
        extends ProcessNodes.ClockGetTimeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode clock_id_;
            @Node.Child
            private RubyNode unit_;
            @CompilerDirectives.CompilationFinal
            private Class<?> clock_idType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClockGetTimeNodeGen(RubyNode clock_id, RubyNode unit) {
                this.clock_id_ = clock_id;
                this.unit_ = this.coerceUnit(unit);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="clock_gettime_monotonic_raw(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_monotonic_rawNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_monotonic_rawNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 4);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_monotonic_rawNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_monotonic_raw(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_monotonic_raw(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_monotonic_rawNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_thread_cputime(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_thread_cputimeNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_thread_cputimeNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 3);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_thread_cputimeNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_thread_cputime(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_thread_cputime(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_thread_cputimeNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_realtime(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_realtimeNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_realtimeNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 2);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_realtimeNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_realtime(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_realtime(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_realtimeNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_monotonic(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_monotonicNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_monotonicNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 1);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_monotonicNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_monotonic(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_monotonic(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_monotonicNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClockGetTimeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object clock_idValue, Object unitValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, clock_idValue, unitValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClockGetTimeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    return this.uninitialized((Frame)frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ClockGetTimeNodeGen root;

                BaseNode_(ClockGetTimeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ClockGetTimeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.clock_id_, this.root.unit_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object clock_idValue, Object unitValue) {
                    return this.execute_((VirtualFrame)frameValue, clock_idValue, unitValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object clock_idValue_ = this.executeClock_id_(frameValue);
                    Object unitValue_ = this.root.unit_.execute(frameValue);
                    return this.execute_(frameValue, clock_idValue_, unitValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_monotonicNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_realtimeNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_thread_cputimeNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_monotonic_rawNode_.create(this.root, clock_idValue);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeClock_id_(Frame frameValue) {
                    Object object;
                    Class clock_idType_ = this.root.clock_idType_;
                    if (clock_idType_ == Integer.TYPE) {
                        return this.root.clock_id_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (clock_idType_ != null) return this.root.clock_id_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.clock_id_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.clock_idType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.clock_idType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.clock_idType_ = _type;
                    return object;
                }
            }
        }
    }
}

