/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayHelpers;
import org.jruby.truffle.core.array.ArrayMirror;
import org.jruby.truffle.core.array.DoubleArrayMirror;
import org.jruby.truffle.core.array.EmptyArrayMirror;
import org.jruby.truffle.core.array.IntegerArrayMirror;
import org.jruby.truffle.core.array.LongArrayMirror;
import org.jruby.truffle.core.array.ObjectArrayMirror;
import org.jruby.truffle.language.RubyGuards;

public abstract class ArrayStrategy {
    public static final ArrayStrategy[] TYPE_STRATEGIES = new ArrayStrategy[]{IntArrayStrategy.INSTANCE, LongArrayStrategy.INSTANCE, DoubleArrayStrategy.INSTANCE, ObjectArrayStrategy.INSTANCE};

    protected Class<?> type() {
        throw this.unsupported();
    }

    public boolean canStore(Class<?> type) {
        throw this.unsupported();
    }

    public abstract boolean accepts(Object var1);

    public boolean specializesFor(Object value) {
        throw this.unsupported();
    }

    public boolean isDefaultValue(Object value) {
        throw this.unsupported();
    }

    public final boolean matches(DynamicObject array) {
        return this.matchesStore(Layouts.ARRAY.getStore(array));
    }

    protected abstract boolean matchesStore(Object var1);

    public int getSize(DynamicObject array) {
        return Layouts.ARRAY.getSize(array);
    }

    public abstract ArrayMirror newArray(int var1);

    public final ArrayMirror newMirror(DynamicObject array) {
        return this.newMirrorFromStore(Layouts.ARRAY.getStore(array));
    }

    protected ArrayMirror newMirrorFromStore(Object store) {
        throw this.unsupported();
    }

    public void setStore(DynamicObject array, Object store) {
        assert (!(store instanceof ArrayMirror));
        Layouts.ARRAY.setStore(array, store);
    }

    public void setStoreAndSize(DynamicObject array, Object store, int size) {
        this.setStore(array, store);
        ArrayHelpers.setSize(array, size);
    }

    public abstract String toString();

    public ArrayStrategy generalize(ArrayStrategy other) {
        CompilerAsserts.neverPartOfCompilation();
        if (other == this) {
            return this;
        }
        if (other instanceof NullArrayStrategy) {
            return this;
        }
        for (ArrayStrategy generalized : TYPE_STRATEGIES) {
            if (!generalized.canStore(this.type()) || !generalized.canStore(other.type())) continue;
            return generalized;
        }
        throw this.unsupported();
    }

    public ArrayStrategy generalizeNew(ArrayStrategy other) {
        return this.generalize(other);
    }

    public ArrayStrategy generalizeFor(Object value) {
        return this.generalize(ArrayStrategy.forValue(value));
    }

    protected RuntimeException unsupported() {
        return new UnsupportedOperationException(this.toString());
    }

    private static ArrayStrategy ofStore(Object store) {
        CompilerAsserts.neverPartOfCompilation();
        if (store == null) {
            return NullArrayStrategy.INSTANCE;
        }
        if (store instanceof int[]) {
            return IntArrayStrategy.INSTANCE;
        }
        if (store instanceof long[]) {
            return LongArrayStrategy.INSTANCE;
        }
        if (store instanceof double[]) {
            return DoubleArrayStrategy.INSTANCE;
        }
        if (store.getClass() == Object[].class) {
            return ObjectArrayStrategy.INSTANCE;
        }
        throw new UnsupportedOperationException(store.getClass().getName());
    }

    public static ArrayStrategy of(DynamicObject array) {
        CompilerAsserts.neverPartOfCompilation();
        if (!RubyGuards.isRubyArray(array)) {
            return FallbackArrayStrategy.INSTANCE;
        }
        return ArrayStrategy.ofStore(Layouts.ARRAY.getStore(array));
    }

    public static ArrayStrategy forValue(Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (value instanceof Integer) {
            return IntArrayStrategy.INSTANCE;
        }
        if (value instanceof Long) {
            return LongArrayStrategy.INSTANCE;
        }
        if (value instanceof Double) {
            return DoubleArrayStrategy.INSTANCE;
        }
        return ObjectArrayStrategy.INSTANCE;
    }

    private static class FallbackArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new FallbackArrayStrategy();

        private FallbackArrayStrategy() {
        }

        @Override
        public boolean accepts(Object value) {
            return false;
        }

        @Override
        public boolean matchesStore(Object store) {
            return false;
        }

        @Override
        public ArrayStrategy generalize(ArrayStrategy other) {
            return other;
        }

        @Override
        public ArrayMirror newArray(int size) {
            throw this.unsupported();
        }

        @Override
        public ArrayMirror newMirrorFromStore(Object store) {
            throw this.unsupported();
        }

        @Override
        public String toString() {
            return "fallback";
        }
    }

    private static class NullArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new NullArrayStrategy();

        private NullArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            throw this.unsupported();
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == null;
        }

        @Override
        public boolean accepts(Object value) {
            return false;
        }

        @Override
        public boolean matchesStore(Object store) {
            return store == null;
        }

        @Override
        public int getSize(DynamicObject array) {
            return 0;
        }

        @Override
        public ArrayMirror newArray(int size) {
            assert (size == 0);
            return EmptyArrayMirror.INSTANCE;
        }

        @Override
        protected ArrayMirror newMirrorFromStore(Object store) {
            return EmptyArrayMirror.INSTANCE;
        }

        @Override
        public ArrayStrategy generalize(ArrayStrategy other) {
            return other;
        }

        @Override
        public String toString() {
            return "null";
        }
    }

    private static class IntToObjectGeneralizationArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new IntToObjectGeneralizationArrayStrategy();

        private IntToObjectGeneralizationArrayStrategy() {
        }

        @Override
        public boolean accepts(Object value) {
            return !(value instanceof Long);
        }

        @Override
        public boolean matchesStore(Object store) {
            return store != null && store.getClass() == Object[].class;
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new ObjectArrayMirror(new Object[size]);
        }

        @Override
        public ArrayMirror newMirrorFromStore(Object store) {
            return new ObjectArrayMirror((Object[])store);
        }

        @Override
        public String toString() {
            return "Object[] (not accepting long)";
        }
    }

    private static class ObjectArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new ObjectArrayStrategy();

        private ObjectArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Object.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return true;
        }

        @Override
        public boolean accepts(Object value) {
            return true;
        }

        @Override
        public boolean specializesFor(Object value) {
            return !(value instanceof Integer) && !(value instanceof Long) && !(value instanceof Double);
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return value == null;
        }

        @Override
        public boolean matchesStore(Object store) {
            return store != null && store.getClass() == Object[].class;
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new ObjectArrayMirror(new Object[size]);
        }

        @Override
        public ArrayMirror newMirrorFromStore(Object store) {
            return new ObjectArrayMirror((Object[])store);
        }

        @Override
        public String toString() {
            return "Object[]";
        }
    }

    private static class DoubleArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new DoubleArrayStrategy();

        private DoubleArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Double.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Double.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Double;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Double;
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return (Double)value == 0.0;
        }

        @Override
        public boolean matchesStore(Object store) {
            return store instanceof double[];
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new DoubleArrayMirror(new double[size]);
        }

        @Override
        public ArrayMirror newMirrorFromStore(Object store) {
            return new DoubleArrayMirror((double[])store);
        }

        @Override
        public String toString() {
            return "double[]";
        }
    }

    private static class LongArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new LongArrayStrategy();

        private LongArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Long.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Long.class || type == Integer.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Long;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Long;
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return (Long)value == 0L;
        }

        @Override
        public boolean matchesStore(Object store) {
            return store instanceof long[];
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new LongArrayMirror(new long[size]);
        }

        @Override
        public ArrayMirror newMirrorFromStore(Object store) {
            return new LongArrayMirror((long[])store);
        }

        @Override
        public String toString() {
            return "long[]";
        }
    }

    private static class IntArrayStrategy
    extends ArrayStrategy {
        static final ArrayStrategy INSTANCE = new IntArrayStrategy();

        private IntArrayStrategy() {
        }

        @Override
        public Class<?> type() {
            return Integer.class;
        }

        @Override
        public boolean canStore(Class<?> type) {
            return type == Integer.class;
        }

        @Override
        public boolean accepts(Object value) {
            return value instanceof Integer;
        }

        @Override
        public boolean specializesFor(Object value) {
            return value instanceof Integer;
        }

        @Override
        public boolean isDefaultValue(Object value) {
            return (Integer)value == 0;
        }

        @Override
        public boolean matchesStore(Object store) {
            return store instanceof int[];
        }

        @Override
        public ArrayStrategy generalize(ArrayStrategy other) {
            CompilerAsserts.neverPartOfCompilation();
            if (other == this) {
                return this;
            }
            if (other == LongArrayStrategy.INSTANCE) {
                return LongArrayStrategy.INSTANCE;
            }
            return IntToObjectGeneralizationArrayStrategy.INSTANCE;
        }

        @Override
        public ArrayMirror newArray(int size) {
            return new IntegerArrayMirror(new int[size]);
        }

        @Override
        protected ArrayMirror newMirrorFromStore(Object store) {
            return new IntegerArrayMirror((int[])store);
        }

        @Override
        public String toString() {
            return "int[]";
        }
    }
}

