/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.core.tracepoint.TracePointEventNode;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.objects.AllocateObjectNode;

@CoreClass(value="TracePoint")
public abstract class TracePointNodes {

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public DynamicObject binding(DynamicObject tracePoint) {
            return Layouts.TRACE_POINT.getBinding(tracePoint);
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LineNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public int line(DynamicObject tracePoint) {
            return Layouts.TRACE_POINT.getLine(tracePoint);
        }
    }

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public DynamicObject path(DynamicObject tracePoint) {
            return Layouts.TRACE_POINT.getPath(tracePoint);
        }
    }

    @CoreMethod(names={"event"})
    public static abstract class EventNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public DynamicObject event(DynamicObject tracePoint) {
            return Layouts.TRACE_POINT.getEvent(tracePoint);
        }
    }

    @CoreMethod(names={"enabled?"})
    public static abstract class EnabledNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public boolean enabled(DynamicObject tracePoint) {
            return Layouts.TRACE_POINT.getEventBinding(tracePoint) != null;
        }
    }

    @CoreMethod(names={"disable"}, needsBlock=true)
    public static abstract class DisableNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public boolean disable(VirtualFrame frame, DynamicObject tracePoint, NotProvided block) {
            return this.disable(frame, tracePoint, (DynamicObject)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public boolean disable(VirtualFrame frame, DynamicObject tracePoint, DynamicObject block) {
            boolean alreadyEnabled;
            EventBinding<?> eventBinding = (EventBinding<?>)Layouts.TRACE_POINT.getEventBinding(tracePoint);
            boolean bl = alreadyEnabled = eventBinding != null;
            if (alreadyEnabled) {
                EnableNode.dispose(eventBinding);
                Layouts.TRACE_POINT.setEventBinding(tracePoint, null);
            }
            if (block != null) {
                try {
                    this.yield(frame, block, new Object[0]);
                }
                finally {
                    if (alreadyEnabled) {
                        eventBinding = EnableNode.createEventBinding(this.getContext(), tracePoint);
                        Layouts.TRACE_POINT.setEventBinding(tracePoint, eventBinding);
                    }
                }
            }
            return alreadyEnabled;
        }
    }

    @CoreMethod(names={"enable"}, needsBlock=true)
    public static abstract class EnableNode
    extends YieldingCoreMethodNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public boolean enable(VirtualFrame frame, DynamicObject tracePoint, NotProvided block) {
            return this.enable(frame, tracePoint, (DynamicObject)null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public boolean enable(VirtualFrame frame, DynamicObject tracePoint, DynamicObject block) {
            boolean alreadyEnabled;
            EventBinding<?> eventBinding = (EventBinding<?>)Layouts.TRACE_POINT.getEventBinding(tracePoint);
            boolean bl = alreadyEnabled = eventBinding != null;
            if (!alreadyEnabled) {
                eventBinding = EnableNode.createEventBinding(this.getContext(), tracePoint);
                Layouts.TRACE_POINT.setEventBinding(tracePoint, eventBinding);
            }
            if (block != null) {
                try {
                    this.yield(frame, block, new Object[0]);
                }
                finally {
                    if (!alreadyEnabled) {
                        EnableNode.dispose(eventBinding);
                        Layouts.TRACE_POINT.setEventBinding(tracePoint, null);
                    }
                }
            }
            return alreadyEnabled;
        }

        @CompilerDirectives.TruffleBoundary
        public static EventBinding<?> createEventBinding(RubyContext context, DynamicObject tracePoint) {
            return context.getInstrumenter().attachFactory(SourceSectionFilter.newBuilder().tagIs((Class[])Layouts.TRACE_POINT.getTags(tracePoint)).build(), eventContext -> new TracePointEventNode(context, tracePoint));
        }

        @CompilerDirectives.TruffleBoundary
        public static void dispose(EventBinding<?> eventBinding) {
            eventBinding.dispose();
        }
    }

    @CoreMethod(names={"initialize"}, rest=true, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isTracePoint(tracePoint)"})
        public DynamicObject initialize(DynamicObject tracePoint, Object[] args, DynamicObject block) {
            Layouts.TRACE_POINT.setTags(tracePoint, new Class[]{TraceManager.LineTag.class});
            Layouts.TRACE_POINT.setProc(tracePoint, block);
            return tracePoint;
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateNode = AllocateObjectNode.create();

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, null, null, 0, null, null, null, false);
        }
    }
}

