/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ast.ListParseNode;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class CaseParseNode
extends ParseNode {
    private final ParseNode caseNode;
    private final ListParseNode cases;
    private ParseNode elseNode = null;

    public CaseParseNode(SourceIndexLength position, ParseNode caseNode, ListParseNode cases) {
        super(position, caseNode != null && caseNode.containsVariableAssignment() || cases.containsVariableAssignment());
        assert (cases != null) : "caseBody is not null";
        this.caseNode = caseNode;
        this.cases = cases;
    }

    public void setElseNode(ParseNode elseNode) {
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.CASENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitCaseNode(this);
    }

    public ParseNode getCaseNode() {
        return this.caseNode;
    }

    public ListParseNode getCases() {
        return this.cases;
    }

    public ParseNode getElseNode() {
        return this.elseNode;
    }

    @Override
    public List<ParseNode> childNodes() {
        return ParseNode.createList(this.caseNode, (ParseNode)this.cases);
    }
}

