/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform.signal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.platform.signal.Signal;
import org.jruby.truffle.platform.signal.SignalHandler;

public interface SignalManager {
    public static final Set<String> RUBY_18_SIGNALS = SignalManager.get18Signals();
    public static final Map<String, Integer> SIGNALS_LIST = Collections.unmodifiableMap(SignalManager.list());
    public static final SignalHandler IGNORE_HANDLER = signal -> {};
    public static final String SIGNAME_PREFIX = "SIG";

    public static Set<String> get18Signals() {
        HashSet<String> RUBY_18_SIGNALS = new HashSet<String>();
        for (String name : new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "IOT", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "CLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "USR1", "USR2", "LOST", "MSG", "PWR", "POLL", "DANGER", "MIGRATE", "PRE", "GRANT", "RETRACT", "SOUND", "INFO"}) {
            RUBY_18_SIGNALS.add(name);
        }
        return RUBY_18_SIGNALS;
    }

    public Signal createSignal(String var1);

    public void watchSignal(Signal var1, SignalHandler var2) throws IllegalArgumentException;

    public void watchDefaultForSignal(Signal var1) throws IllegalArgumentException;

    public void handle(Signal var1, SignalHandler var2) throws IllegalArgumentException;

    public void handleDefault(Signal var1) throws IllegalArgumentException;

    public void raise(Signal var1) throws IllegalArgumentException;

    public static Map<String, Integer> list() {
        HashMap<String, Integer> signals = new HashMap<String, Integer>();
        for (jnr.constants.platform.Signal s : jnr.constants.platform.Signal.values()) {
            if (!s.description().startsWith(SIGNAME_PREFIX) || !RUBY_18_SIGNALS.contains(SignalManager.signmWithoutPrefix(s.description()))) continue;
            int signo = s.intValue();
            if (s == jnr.constants.platform.Signal.SIGCLD) {
                signo = jnr.constants.platform.Signal.SIGCHLD.intValue();
            }
            if (signo >= 20000) continue;
            signals.put(SignalManager.signmWithoutPrefix(s.description()), signo);
        }
        return signals;
    }

    public static String signmWithoutPrefix(String nm) {
        return nm.startsWith(SIGNAME_PREFIX) ? nm.substring(SIGNAME_PREFIX.length()) : nm;
    }
}

