/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;

public class InfrastructureFileDescriptor {
    private final String fileName;
    private final String pathStub;
    private final String systemPathStub;
    private final String descriptionKey;
    final PathsAndFiles.Target[] target;

    protected InfrastructureFileDescriptor() {
        this("undef", "undef", "undef", "undef", new PathsAndFiles.Target[0]);
    }

    InfrastructureFileDescriptor(String fileName, String pathStub, String systemPathStub, String descriptionKey, PathsAndFiles.Target ... target) {
        this.fileName = fileName;
        this.pathStub = pathStub;
        this.systemPathStub = systemPathStub;
        this.descriptionKey = descriptionKey;
        this.target = target;
    }

    protected String getPropertiesKey() {
        return null;
    }

    public File getFile() {
        return new File(this.getFullPath());
    }

    public void setValue(String value) {
        this.setValue(value, JNLPRuntime.getConfiguration());
    }

    public String getFullPath() {
        return this.getFullPath(JNLPRuntime.getConfiguration());
    }

    public void setValue(String value, DeploymentConfiguration config) {
        String key = this.getPropertiesKey();
        if (key == null) {
            throw new IllegalStateException("This file is read only");
        }
        config.setProperty(key, value);
    }

    public String getFullPath(DeploymentConfiguration config) {
        String key = this.getPropertiesKey();
        if (key == null) {
            return this.getDefaultFullPath();
        }
        return config.getProperty(key);
    }

    public File getDefaultFile() {
        return new File(this.getDefaultFullPath());
    }

    public String getDefaultDir() {
        return this.clean(this.systemPathStub + File.separator + this.pathStub);
    }

    public String getDefaultFullPath() {
        return this.clean(this.systemPathStub + File.separator + this.pathStub + File.separator + this.fileName);
    }

    protected String getSystemPathStubAcronym() {
        return this.systemPathStub;
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected String getDescriptionKey() {
        return this.descriptionKey;
    }

    private String getStub() {
        return this.clean(this.pathStub + File.separator + this.fileName);
    }

    public String toString() {
        return this.clean(this.getSystemPathStubAcronym() + File.separator + this.getStub());
    }

    public String getDirViaAcronym() {
        return this.clean(this.getSystemPathStubAcronym() + File.separator + this.pathStub);
    }

    protected String clean(String s) {
        while (s.contains(File.separator + File.separator)) {
            s = s.replace(File.separator + File.separator, File.separator);
        }
        return s;
    }

    public String getDescription() {
        return Translator.R(this.descriptionKey);
    }
}

