/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE = new VisualizerNode(0);
    static final Logger LOG = Logger.getLogger(VisualizerNode.class.getName());
    private static final Reference<VisualizerChildren> NO_REF = new WeakReference<Object>(null);
    private static WeakHashMap<VisualizerNode, Reference<VisualizerNode>> cache = new WeakHashMap();
    public static final VisualizerNode EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
    private static final QP QUEUE = new QP();
    private static final String UNKNOWN = new String();
    static final long serialVersionUID = 3726728244698316872L;
    private static final String NO_HTML_DISPLAYNAME = "noHtmlDisplayName";
    private static Icon defaultIcon;
    private static final String DEFAULT_ICON = "org/openide/nodes/defaultNode.png";
    private static final int prefetchCount;
    private Icon icon = null;
    Node node;
    private int hashCode;
    private Reference<VisualizerChildren> children = NO_REF;
    VisualizerChildren parent;
    int indexOf = -1;
    private String name;
    private String displayName;
    private String shortDescription;
    private String htmlDisplayName = null;
    private int cachedIconType = -1;

    private VisualizerNode(int n) {
        this.hashCode = n;
        this.node = null;
    }

    private VisualizerNode(Node node) {
        this.node = node;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)this.node));
        this.name = UNKNOWN;
        this.displayName = UNKNOWN;
        this.shortDescription = UNKNOWN;
    }

    public static VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node) {
        return VisualizerNode.getVisualizer(visualizerChildren, node, true);
    }

    public static synchronized VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node, boolean bl) {
        VisualizerNode visualizerNode;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(node);
        VisualizerNode.TEMPLATE.node = node;
        Reference<VisualizerNode> reference = cache.get(TEMPLATE);
        VisualizerNode.TEMPLATE.hashCode = 0;
        VisualizerNode.TEMPLATE.node = null;
        VisualizerNode visualizerNode2 = visualizerNode = reference == null ? null : reference.get();
        if (visualizerNode == null) {
            if (!bl) {
                return null;
            }
            visualizerNode = new VisualizerNode(node);
            cache.put(visualizerNode, new WeakReference<VisualizerNode>(visualizerNode));
        }
        if (visualizerChildren != null) {
            visualizerNode.parent = visualizerChildren;
        }
        return visualizerNode;
    }

    public String getShortDescription() {
        String string;
        String string2 = this.shortDescription;
        if (string2 == UNKNOWN) {
            this.shortDescription = string2 = this.node.getShortDescription();
        }
        if ((string = ImageUtilities.getImageToolTip((Image)ImageUtilities.icon2Image((Icon)(this.icon != null ? this.icon : this.getIcon(false, false))))).length() > 0) {
            StringBuilder stringBuilder = new StringBuilder(128);
            string2 = string2.replaceAll("</?html>", "");
            stringBuilder.append("<html>").append(string2).append("<br>").append(string).append("</html>");
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    public String getDisplayName() {
        if (this.displayName == UNKNOWN) {
            this.displayName = this.node == null ? null : this.node.getDisplayName();
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == UNKNOWN) {
            this.name = this.node == null ? null : this.node.getName();
        }
        return this.name;
    }

    public VisualizerChildren getChildren() {
        return this.getChildren(true);
    }

    final VisualizerChildren getChildren(boolean bl) {
        VisualizerChildren visualizerChildren = this.children.get();
        if (bl && visualizerChildren == null && !this.node.isLeaf()) {
            Children children = this.node.getChildren();
            int n = children.getNodesCount();
            Node[] nodeArray = null;
            if (prefetchCount > 0) {
                if (n <= prefetchCount) {
                    nodeArray = children.getNodes();
                } else {
                    nodeArray = new Node[Math.min(prefetchCount, n)];
                    for (int i = 0; i < nodeArray.length; ++i) {
                        nodeArray[i] = children.getNodeAt(i);
                    }
                }
            }
            visualizerChildren = (VisualizerChildren)Children.MUTEX.readAccess((Mutex.Action)new Mutex.Action<VisualizerChildren>(){

                public VisualizerChildren run() {
                    List list = VisualizerNode.this.node.getChildren().snapshot();
                    VisualizerChildren visualizerChildren = new VisualizerChildren(VisualizerNode.this, list);
                    VisualizerNode.this.notifyVisualizerChildrenChange(true, visualizerChildren);
                    return visualizerChildren;
                }
            });
        }
        return visualizerChildren == null ? VisualizerChildren.EMPTY : visualizerChildren;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        return this.getChildren().getIndex(treeNode);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    private LogRecord assertAccess(int n) {
        if (Children.MUTEX.isReadAccess()) {
            return null;
        }
        if (Children.MUTEX.isWriteAccess()) {
            return null;
        }
        if (!LOG.isLoggable(Level.FINE)) {
            return null;
        }
        Level level = LOG.isLoggable(Level.FINEST) ? Level.FINEST : Level.FINE;
        LogRecord logRecord = new LogRecord(level, "LOG_NO_READ_ACCESS");
        logRecord.setResourceBundle(NbBundle.getBundle(VisualizerNode.class));
        logRecord.setParameters(new Object[]{this, n});
        logRecord.setLoggerName(LOG.getName());
        if (level == Level.FINEST) {
            logRecord.setThrown((Throwable)((Object)new AssertionError((Object)logRecord.getMessage())));
        }
        return logRecord;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return this.getChildren().getChildAt(n);
    }

    @Override
    public int getChildCount() {
        return this.getChildren().getChildCount();
    }

    public Enumeration<VisualizerNode> children() {
        return this.getChildren().children(true);
    }

    @Override
    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    @Override
    public TreeNode getParent() {
        Node node = this.node.getParentNode();
        return node == null ? null : VisualizerNode.getVisualizer(null, node);
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = this.children.get();
        LOG.log(Level.FINER, "childrenAdded event: {0}\n  ch: {1}", new Object[]{nodeMemberEvent, visualizerChildren});
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenAdded - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(visualizerChildren, nodeMemberEvent.getDeltaIndices(), nodeMemberEvent));
        LOG.log(Level.FINER, "childrenAdded - end");
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = this.children.get();
        LOG.log(Level.FINER, "childrenRemoved event: {0}\n  ch: {1}", new Object[]{nodeMemberEvent, visualizerChildren});
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenRemoved - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(visualizerChildren, nodeMemberEvent.getDeltaIndices(), nodeMemberEvent));
        LOG.log(Level.FINER, "childrenRemoved - end");
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        VisualizerChildren visualizerChildren = this.children.get();
        int[] nArray = nodeReorderEvent.getPermutation();
        LOG.log(Level.FINER, "childrenReordered {0}\n  ch: {1}", new Object[]{nArray, visualizerChildren});
        if (visualizerChildren == null) {
            LOG.log(Level.FINER, "childrenReordered - exit");
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(visualizerChildren, nArray, nodeReorderEvent));
        LOG.log(Level.FINER, "childrenReordered - end");
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
        this.node = Node.EMPTY;
        QUEUE.runSafe(new VisualizerEvent.Destroyed(this.getChildren(false), nodeEvent));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        String string = propertyChangeEvent.getPropertyName();
        boolean bl2 = bl = "icon".equals(string) || "openedIcon".equals(string);
        if ("name".equals(string) || "displayName".equals(string) || bl) {
            if (bl) {
                this.cachedIconType = -1;
            }
            if ("displayName".equals(string)) {
                this.htmlDisplayName = null;
            }
            QUEUE.runSafe(this);
            return;
        }
        if ("shortDescription".equals(string) && this.shortDescription != UNKNOWN) {
            QUEUE.runSafe(this);
            return;
        }
        if ("leaf".equals(string)) {
            QUEUE.runSafe(new PropLeafChange());
            return;
        }
    }

    @Override
    public void run() {
        if (!Children.MUTEX.isReadAccess()) {
            Children.MUTEX.readAccess((Runnable)this);
            return;
        }
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        for (VisualizerNode visualizerNode = this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).update(this);
            }
        }
    }

    void notifyVisualizerChildrenChange(boolean bl, VisualizerChildren visualizerChildren) {
        if (bl) {
            if (this.children.getClass() != StrongReference.class || this.children.get() != visualizerChildren) {
                this.children = new StrongReference<VisualizerChildren>(visualizerChildren);
            }
        } else if (this.children.getClass() != WeakReference.class || this.children.get() != visualizerChildren) {
            this.children = new WeakReference<VisualizerChildren>(visualizerChildren);
        }
    }

    public synchronized void addNodeModel(NodeModel nodeModel) {
        this.add(NodeModel.class, nodeModel);
    }

    public synchronized void removeNodeModel(NodeModel nodeModel) {
        this.remove(NodeModel.class, nodeModel);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode visualizerNode = (VisualizerNode)object;
        return visualizerNode.node == this.node;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    public String toId() {
        return "'" + this.getDisplayName() + "'@" + Integer.toHexString(System.identityHashCode(this)) + " parent: " + this.parent + " indexOf: " + this.indexOf;
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName == null) {
            this.htmlDisplayName = this.node.getHtmlDisplayName();
            if (this.htmlDisplayName == null) {
                this.htmlDisplayName = NO_HTML_DISPLAYNAME;
            }
        }
        return this.htmlDisplayName == NO_HTML_DISPLAYNAME ? null : this.htmlDisplayName;
    }

    Icon getIcon(boolean bl, boolean bl2) {
        int n = VisualizerNode.getCacheType(bl, bl2);
        if (this.cachedIconType != n) {
            Image image;
            int n2 = bl2 ? 2 : 1;
            try {
                Image image2 = image = bl ? this.node.getOpenedIcon(n2) : this.node.getIcon(n2);
                if (image == null) {
                    String string = bl ? "getOpenedIcon" : "getIcon";
                    LOG.warning("Node \"" + this.node.getName() + "\" [" + this.node.getClass().getName() + "] cannot return null from " + string + "(). See Node." + string + " contract.");
                }
            }
            catch (RuntimeException runtimeException) {
                LOG.log(Level.INFO, null, runtimeException);
                image = null;
            }
            this.icon = image == null ? VisualizerNode.getDefaultIcon() : ImageUtilities.image2Icon((Image)image);
        }
        this.cachedIconType = n;
        return this.icon;
    }

    private static final int getCacheType(boolean bl, boolean bl2) {
        return (bl ? 2 : 0) | (bl2 ? 1 : 0);
    }

    private static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = ImageUtilities.loadImageIcon((String)DEFAULT_ICON, (boolean)false);
        }
        return defaultIcon;
    }

    static void runSafe(Runnable runnable) {
        QUEUE.runSafe(runnable);
    }

    VisualizerNode[] getPathToRoot() {
        return this.getPathToRoot(0);
    }

    VisualizerNode[] getPathToRoot(int n) {
        VisualizerNode[] visualizerNodeArray = this.parent == null || this.parent.parent == null ? new VisualizerNode[n] : this.parent.parent.getPathToRoot(++n);
        visualizerNodeArray[visualizerNodeArray.length - n] = this;
        return visualizerNodeArray;
    }

    static {
        prefetchCount = Math.max(Integer.getInteger("org.openide.explorer.VisualizerNode.prefetchCount", 50), 0);
    }

    private class PropLeafChange
    implements Runnable {
        @Override
        public void run() {
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.readAccess((Runnable)this);
                return;
            }
            VisualizerNode.this.children = NO_REF;
            for (VisualizerNode visualizerNode = VisualizerNode.this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
                Object[] objectArray = visualizerNode.getListenerList();
                for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                    ((NodeModel)objectArray[i]).structuralChange(VisualizerNode.this);
                }
            }
        }
    }

    private static final class QP {
        private LinkedList<Runnable> queue = new LinkedList();

        QP() {
        }

        boolean shouldBeInvokedLater(Runnable runnable) {
            return runnable instanceof VisualizerEvent.Removed && ((VisualizerEvent)((Object)runnable)).getSnapshot().getClass().getName().contains("DelayedLazySnapshot");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSafe(Runnable runnable) {
            boolean bl = false;
            QP qP = this;
            synchronized (qP) {
                if (SwingUtilities.isEventDispatchThread() && this.shouldBeInvokedLater(runnable)) {
                    if (!this.queue.isEmpty()) {
                        this.queue.addLast(null);
                    }
                    this.queue.addLast(runnable);
                    SwingUtilities.invokeLater(new ProcessQueue(Integer.MAX_VALUE));
                    return;
                }
                bl = this.queue.isEmpty();
                this.queue.addLast(runnable);
            }
            if (bl) {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.processQueue(Integer.MAX_VALUE);
                } else {
                    SwingUtilities.invokeLater(new ProcessQueue(500));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processQueue(int n) {
            long l = System.currentTimeMillis() + (long)n;
            boolean bl = false;
            while (!bl) {
                Runnable runnable;
                QP qP = this;
                synchronized (qP) {
                    runnable = this.queue.poll();
                    if (runnable == null) {
                        LOG.log(Level.FINER, "Marker found, interrupting queue");
                        return;
                    }
                    bl = this.queue.isEmpty();
                }
                LOG.log(Level.FINER, "Running from queue {0}", runnable);
                Children.MUTEX.readAccess(runnable);
                LOG.log(Level.FINER, "Finished {0}", runnable);
                if (System.currentTimeMillis() <= l) continue;
                SwingUtilities.invokeLater(new ProcessQueue(n));
                LOG.log(Level.FINER, "timeout from {0} ms", n);
                return;
            }
            LOG.log(Level.FINER, "Queue processing over");
        }

        private class ProcessQueue
        implements Runnable {
            private final int limitMillis;

            public ProcessQueue(int n) {
                this.limitMillis = n;
            }

            @Override
            public void run() {
                QP.this.processQueue(this.limitMillis);
            }
        }
    }

    private static final class StrongReference<T>
    extends WeakReference<T> {
        private T o;

        public StrongReference(T t) {
            super(null);
            this.o = t;
        }

        @Override
        public T get() {
            return this.o;
        }
    }
}

