/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sampler.cpu;

import com.sun.tools.visualvm.sampler.cpu.ThreadsCPUInfo;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ThreadsCPU {
    private static final ObjectName THREAD_NAME = ThreadsCPU.getThreadName();
    private final ThreadMXBean threadBean;
    private final MBeanServerConnection connection;

    public ThreadsCPU(ThreadMXBean bean, MBeanServerConnection conn) {
        this.threadBean = bean;
        this.connection = conn;
    }

    public ThreadsCPUInfo getThreadsCPUInfo() throws MBeanException, ReflectionException, IOException, InstanceNotFoundException {
        long[] ids = this.threadBean.getAllThreadIds();
        ThreadInfo[] tids = this.threadBean.getThreadInfo(ids);
        Object[] args = new Object[]{ids};
        String[] sigs = new String[]{"[J"};
        long[] tinfo = (long[])this.connection.invoke(THREAD_NAME, "getThreadCpuTime", args, sigs);
        long time = System.currentTimeMillis();
        return new ThreadsCPUInfo(time, tids, tinfo);
    }

    private static ObjectName getThreadName() {
        try {
            return new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }
}

