/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.axis;

import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.charts.axis.BytesMark;

public class BytesAxisUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.charts.axis.Bundle");
    public static final String UNITS_B = messages.getString("BytesAxisUtils_AbbrBytes");
    public static final String UNITS_KB = messages.getString("BytesAxisUtils_AbbrKiloBytes");
    public static final String UNITS_MB = messages.getString("BytesAxisUtils_AbbrMegaBytes");
    public static final String UNITS_GB = messages.getString("BytesAxisUtils_AbbrGigaBytes");
    public static final String UNITS_TB = messages.getString("BytesAxisUtils_AbbrTeraBytes");
    public static final String UNITS_PB = messages.getString("BytesAxisUtils_AbbrPetaBytes");
    private static final String SIZE_FORMAT = messages.getString("BytesAxisUtils_SizeFormat");
    public static final long[] bytesUnitsGrid = new long[]{1L, 2L, 5L, 10L, 25L, 50L, 100L, 250L, 500L};
    public static final String[] radixUnits = new String[]{UNITS_B, UNITS_KB, UNITS_MB, UNITS_GB, UNITS_TB, UNITS_PB};
    private static final NumberFormat FORMAT = NumberFormat.getInstance();

    public static long[] getBytesUnits(double d, int n) {
        if (Double.isNaN(d) || d == Double.POSITIVE_INFINITY || d <= 0.0) {
            return new long[]{-1L, -1L};
        }
        long l = 1L;
        long l2 = 0L;
        while (true) {
            for (int i = 0; i < bytesUnitsGrid.length; ++i) {
                if (!((double)bytesUnitsGrid[i] * d * (double)l >= (double)n)) continue;
                return new long[]{bytesUnitsGrid[i] * l, l2};
            }
            l *= 1024L;
            ++l2;
        }
    }

    public static String getRadixUnits(BytesMark bytesMark) {
        int n = bytesMark.getRadix();
        if (n < 0 || n >= radixUnits.length) {
            return "";
        }
        return radixUnits[n];
    }

    public static String formatBytes(BytesMark bytesMark) {
        int n = bytesMark.getRadix();
        long l = bytesMark.getValue() / (long)Math.pow(1024.0, n);
        String string = BytesAxisUtils.getRadixUnits(bytesMark);
        return MessageFormat.format(SIZE_FORMAT, FORMAT.format(l), string);
    }
}

