/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.MutexException;
import org.openide.util.Union2;
import org.openide.util.Utilities;

public final class Mutex {
    private static int counter;
    private static final Logger LOG;
    public static final Mutex EVENT;
    static boolean beStrict;
    private static final int NONE = 0;
    private static final int CHAIN = 1;
    private static final int X = 2;
    private static final int S = 3;
    private static final int MODE_COUNT = 4;
    private static final boolean[][] cmatrix;
    private int grantedMode = 0;
    private int origMode;
    private final Object LOCK;
    private final Executor wrapper;
    private final Map<Thread, ThreadInfo> registeredThreads = new HashMap<Thread, ThreadInfo>(7);
    private int readersNo = 0;
    private List<QueueCell> waiters;
    private int cnt;

    public Mutex(Object object) {
        this.LOCK = this.init(object);
        this.wrapper = null;
    }

    public Mutex() {
        this.LOCK = this.init(new InternalLock());
        this.wrapper = null;
    }

    public Mutex(Privileged privileged) {
        if (privileged == null) {
            throw new IllegalArgumentException("privileged == null");
        }
        this.LOCK = this.init(new InternalLock());
        privileged.setParent(this);
        this.wrapper = null;
    }

    public Mutex(Privileged privileged, Executor executor) {
        this.LOCK = new Mutex(privileged);
        this.wrapper = executor;
    }

    private Object init(Object object) {
        this.waiters = new LinkedList<QueueCell>();
        this.cnt = counter++;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "[" + this.cnt + "] created here", new Exception());
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readAccess(Action<T> action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException mutexException) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(mutexException.getException());
            }
        }
        if (this.wrapper != null) {
            try {
                return this.doWrapperAccess(action, null, true);
            }
            catch (MutexException mutexException) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(mutexException.getException());
            }
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread, 0L);
        try {
            T t = action.run();
            return t;
        }
        finally {
            this.leave(thread);
        }
    }

    public <T> T readAccess(ExceptionAction<T> exceptionAction) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(exceptionAction);
        }
        if (this.wrapper != null) {
            return this.doWrapperAccess(exceptionAction, null, true);
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread, 0L);
        try {
            T t = exceptionAction.run();
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MutexException(exception);
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAccess(Runnable runnable) {
        if (this == EVENT) {
            Mutex.doEvent(runnable);
            return;
        }
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, runnable, true);
                return;
            }
            catch (MutexException mutexException) {
                throw new IllegalStateException(mutexException);
            }
        }
        Thread thread = Thread.currentThread();
        this.readEnter(thread, 0L);
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T writeAccess(Action<T> action) {
        if (this == EVENT) {
            try {
                return Mutex.doEventAccess(action);
            }
            catch (MutexException mutexException) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(mutexException.getException());
            }
        }
        if (this.wrapper != null) {
            try {
                return this.doWrapperAccess(action, null, false);
            }
            catch (MutexException mutexException) {
                throw (InternalError)new InternalError("Exception from non-Exception Action").initCause(mutexException.getException());
            }
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread, 0L);
        try {
            T t = action.run();
            return t;
        }
        finally {
            this.leave(thread);
        }
    }

    public <T> T writeAccess(ExceptionAction<T> exceptionAction) throws MutexException {
        if (this == EVENT) {
            return Mutex.doEventAccess(exceptionAction);
        }
        if (this.wrapper != null) {
            return this.doWrapperAccess(exceptionAction, null, false);
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread, 0L);
        try {
            T t = exceptionAction.run();
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new MutexException(exception);
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAccess(Runnable runnable) {
        if (this == EVENT) {
            Mutex.doEvent(runnable);
            return;
        }
        if (this.wrapper != null) {
            try {
                this.doWrapperAccess(null, runnable, false);
            }
            catch (MutexException mutexException) {
                throw new IllegalStateException(mutexException);
            }
            return;
        }
        Thread thread = Thread.currentThread();
        this.writeEnter(thread, 0L);
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        if (this.wrapper != null) {
            Mutex mutex = (Mutex)this.LOCK;
            return mutex.isReadAccess();
        }
        Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null && threadInfo.counts[3] > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriteAccess() {
        if (this == EVENT) {
            return SwingUtilities.isEventDispatchThread();
        }
        if (this.wrapper != null) {
            Mutex mutex = (Mutex)this.LOCK;
            return mutex.isWriteAccess();
        }
        Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            ThreadInfo threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null && threadInfo.counts[2] > 0) {
                return true;
            }
        }
        return false;
    }

    public void postReadRequest(Runnable runnable) {
        this.postRequest(3, runnable, null);
    }

    public void postWriteRequest(Runnable runnable) {
        this.postRequest(2, runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this == EVENT) {
            return "Mutex.EVENT";
        }
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder(512);
        Object object = this.LOCK;
        synchronized (object) {
            stringBuilder.append("threads: ").append(this.getRegisteredThreads()).append(string);
            stringBuilder.append("readersNo: ").append(this.readersNo).append(string);
            stringBuilder.append("waiters: ").append(this.waiters).append(string);
            stringBuilder.append("grantedMode: ").append(this.getGrantedMode(false)).append(string);
        }
        return stringBuilder.toString();
    }

    final boolean writeEnter(Thread thread, long l) {
        return this.enter(2, thread, l);
    }

    final boolean readEnter(Thread thread, long l) {
        return this.enter(3, thread, l);
    }

    private void doLog(String string, Object ... objectArray) {
        String string2 = Integer.toHexString(Thread.currentThread().hashCode());
        LOG.log(Level.FINER, "[#" + this.cnt + "@" + string2 + "] " + string, objectArray);
    }

    private boolean enter(int n, Thread thread, long l) {
        boolean bl = LOG.isLoggable(Level.FINER);
        if (bl) {
            this.doLog("Entering {0}, {1}", n, l);
        }
        boolean bl2 = this.enterImpl(n, thread, l);
        if (bl) {
            this.doLog("Entering exit: {0}", bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean enterImpl(int n, Thread thread, long l) {
        QueueCell queueCell = null;
        int n2 = 0;
        while (true) {
            ++n2;
            Object object = this.LOCK;
            synchronized (object) {
                ThreadInfo threadInfo = this.getThreadInfo(thread);
                if (threadInfo != null) {
                    IllegalStateException illegalStateException;
                    if (this.getGrantedMode(false) == 0) {
                        throw new IllegalStateException();
                    }
                    if (threadInfo.mode == 3 && this.getGrantedMode(false) == 2 || threadInfo.mode == 2 && this.getGrantedMode(false) == 3) {
                        throw new IllegalStateException();
                    }
                    if (threadInfo.mode == 2 || threadInfo.mode == n) {
                        if (threadInfo.forced) {
                            threadInfo.forced = false;
                        } else {
                            if (n == 2 && threadInfo.counts[3] > 0) {
                                illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                                if (beStrict) {
                                    throw illegalStateException;
                                }
                                Exceptions.printStackTrace(illegalStateException);
                            }
                            int n3 = n;
                            threadInfo.counts[n3] = threadInfo.counts[n3] + 1;
                            if (n == 3 && threadInfo.counts[n] == 1) {
                                ++this.readersNo;
                            }
                        }
                        return true;
                    }
                    if (this.canUpgrade(threadInfo.mode, n)) {
                        illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                        if (beStrict) {
                            throw illegalStateException;
                        }
                        Exceptions.printStackTrace(illegalStateException);
                        threadInfo.mode = 2;
                        int n4 = n;
                        threadInfo.counts[n4] = threadInfo.counts[n4] + 1;
                        threadInfo.rsnapshot = threadInfo.counts[3];
                        if (this.getGrantedMode(false) == 3) {
                            this.setGrantedMode(2);
                        } else if (this.getGrantedMode(false) == 2) {
                            throw new IllegalStateException();
                        }
                        return true;
                    }
                    illegalStateException = new IllegalStateException("WARNING: Going from readAccess to writeAccess through queue, see #10778: http://www.netbeans.org/issues/show_bug.cgi?id=10778 ");
                    if (beStrict) {
                        throw illegalStateException;
                    }
                    Exceptions.printStackTrace(illegalStateException);
                } else if (this.isCompatible(n)) {
                    this.setGrantedMode(n);
                    threadInfo = new ThreadInfo(thread, n);
                    this.getRegisteredThreads().put(thread, threadInfo);
                    if (n == 3) {
                        ++this.readersNo;
                    }
                    return true;
                }
                if (l == -1L) {
                    return false;
                }
                this.setGrantedMode(1);
                queueCell = this.chain(n, thread, 0);
            }
            queueCell.sleep(l);
            if (l <= 0L) continue;
            l = -1L;
        }
    }

    private boolean reenter(Thread thread, int n) {
        boolean bl = LOG.isLoggable(Level.FINER);
        if (bl) {
            this.doLog("Re-Entering {0}", n);
        }
        boolean bl2 = this.reenterImpl(thread, n);
        if (bl) {
            this.doLog("Re-Entering exit: {0}", bl2);
        }
        return bl2;
    }

    private boolean reenterImpl(Thread thread, int n) {
        boolean bl;
        if (n == 3) {
            if (this.getGrantedMode(false) != 0 && this.getGrantedMode(false) != 3) {
                throw new IllegalStateException(this.toString());
            }
            this.enter(n, thread, 0L);
            return false;
        }
        ThreadInfo threadInfo = this.getThreadInfo(thread);
        boolean bl2 = bl = this.getGrantedMode(false) == 1 && threadInfo != null && threadInfo.counts[2] > 0;
        if (this.getGrantedMode(false) == 2 || this.getGrantedMode(false) == 0 || bl) {
            this.enter(n, thread, 0L);
            return false;
        }
        if (this.readersNo == 0) {
            throw new IllegalStateException(this.toString());
        }
        ThreadInfo threadInfo2 = new ThreadInfo(thread, n);
        this.getRegisteredThreads().put(thread, threadInfo2);
        this.readersNo += 2;
        this.setGrantedMode(1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privilegedEnter(Thread thread, int n) {
        boolean bl = true;
        Object object = this.LOCK;
        synchronized (object) {
            this.getThreadInfo(thread);
        }
        while (true) {
            Object object2 = this.LOCK;
            synchronized (object2) {
                if (bl) {
                    bl = false;
                    this.readersNo -= 2;
                }
                this.setGrantedMode(1);
                object = this.chain(n, thread, Integer.MAX_VALUE);
                if (this.readersNo == 0) {
                    if (this.waiters.get(0) == object) {
                        this.waiters.remove(0);
                        this.setGrantedMode(n);
                        return;
                    }
                    this.setGrantedMode(0);
                    this.wakeUpOthers();
                }
            }
            ((QueueCell)object).sleep();
        }
    }

    final void leave(Thread thread) {
        boolean bl = LOG.isLoggable(Level.FINER);
        if (bl) {
            this.doLog("Leaving {0}", this.getGrantedMode(true));
        }
        this.leaveImpl(thread);
        if (bl) {
            this.doLog("Leaving exit: {0}", this.getGrantedMode(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leaveImpl(Thread thread) {
        int n;
        ThreadInfo threadInfo;
        int n2 = 0;
        boolean bl = false;
        Object object = this.LOCK;
        synchronized (object) {
            threadInfo = this.getThreadInfo(thread);
            switch (this.getGrantedMode(false)) {
                case 0: {
                    throw new IllegalStateException();
                }
                case 1: {
                    if (threadInfo.counts[2] > 0) {
                        n2 = this.leaveX(threadInfo);
                        break;
                    }
                    if (threadInfo.counts[3] > 0) {
                        n2 = this.leaveS(threadInfo);
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    n2 = this.leaveX(threadInfo);
                    break;
                }
                case 3: {
                    n2 = this.leaveS(threadInfo);
                }
            }
            if (n2 != 0 && (n = threadInfo.getRunnableCount(n2)) != 0) {
                bl = this.reenter(thread, n2);
            }
        }
        if (n2 != 0 && threadInfo.getRunnableCount(n2) > 0) {
            this.doLog("Processing posted requests: {0}", n2);
            try {
                if (bl) {
                    this.privilegedEnter(thread, n2);
                }
                object = threadInfo.dequeue(n2);
                n = object.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        Runnable runnable = (Runnable)object.get(i);
                        runnable.run();
                        continue;
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace(exception);
                        continue;
                    }
                    catch (StackOverflowError stackOverflowError) {
                        stackOverflowError.printStackTrace();
                        Exceptions.printStackTrace(stackOverflowError);
                        continue;
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Error error) {
                        Exceptions.printStackTrace(error);
                    }
                }
                object = null;
            }
            finally {
                this.leave(thread);
            }
        }
    }

    private int leaveX(ThreadInfo threadInfo) {
        if (threadInfo.counts[2] <= 0 || threadInfo.rsnapshot > threadInfo.counts[3]) {
            throw new IllegalStateException();
        }
        if (threadInfo.rsnapshot == threadInfo.counts[3]) {
            threadInfo.counts[2] = threadInfo.counts[2] - 1;
            if (threadInfo.counts[2] == 0) {
                threadInfo.rsnapshot = 0;
                if (threadInfo.counts[3] > 0) {
                    threadInfo.mode = 3;
                    this.setGrantedMode(3);
                } else {
                    threadInfo.mode = 0;
                    this.setGrantedMode(0);
                    this.getRegisteredThreads().remove(threadInfo.t);
                }
                if (threadInfo.getRunnableCount(3) > 0) {
                    this.wakeUpReaders();
                    return 3;
                }
                this.wakeUpOthers();
            }
        } else {
            if (threadInfo.counts[3] <= 0) {
                throw new IllegalStateException();
            }
            threadInfo.counts[3] = threadInfo.counts[3] - 1;
            if (threadInfo.counts[3] == 0) {
                if (this.readersNo <= 0) {
                    throw new IllegalStateException();
                }
                --this.readersNo;
                return 2;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int leaveS(ThreadInfo threadInfo) {
        if (threadInfo.counts[3] <= 0 || threadInfo.counts[2] > 0) {
            throw new IllegalStateException();
        }
        threadInfo.counts[3] = threadInfo.counts[3] - 1;
        if (threadInfo.counts[3] == 0) {
            threadInfo.mode = 0;
            this.getRegisteredThreads().remove(threadInfo.t);
            if (this.readersNo <= 0) {
                throw new IllegalStateException();
            }
            --this.readersNo;
            if (this.readersNo == 0) {
                this.setGrantedMode(0);
                if (threadInfo.getRunnableCount(2) > 0) {
                    return 2;
                }
                this.wakeUpOthers();
            } else {
                if (threadInfo.getRunnableCount(2) > 0) {
                    return 2;
                }
                if (this.getGrantedMode(false) == 1 && this.readersNo == 1) {
                    for (int i = 0; i < this.waiters.size(); ++i) {
                        QueueCell queueCell;
                        QueueCell queueCell2 = queueCell = this.waiters.get(i);
                        synchronized (queueCell2) {
                            if (queueCell.isGotOut()) {
                                this.waiters.remove(i--);
                                continue;
                            }
                            ThreadInfo threadInfo2 = this.getThreadInfo(queueCell.t);
                            if (threadInfo2 != null && threadInfo2.mode == 3) {
                                if (queueCell.mode != 2) {
                                    throw new IllegalStateException();
                                }
                                if (this.waiters.size() == 1) {
                                    this.setGrantedMode(2);
                                }
                                threadInfo2.mode = 2;
                                this.waiters.remove(i);
                                queueCell.wakeMeUp();
                            }
                            break;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private QueueCell chain(int n, Thread thread, int n2) {
        QueueCell queueCell = new QueueCell(n, thread);
        queueCell.priority2 = n2;
        int n3 = this.waiters.size();
        if (n3 == 0) {
            this.waiters.add(queueCell);
        } else if (queueCell.getPriority() == Integer.MAX_VALUE) {
            this.waiters.add(0, queueCell);
        } else {
            int n4 = 0;
            do {
                QueueCell queueCell2;
                if ((queueCell2 = this.waiters.get(n4)).getPriority() >= queueCell.getPriority()) continue;
                this.waiters.add(n4, queueCell);
                break;
            } while (++n4 < n3);
            if (n4 == n3) {
                this.waiters.add(queueCell);
            }
        }
        return queueCell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpOthers() {
        if (this.getGrantedMode(false) == 2 || this.getGrantedMode(false) == 1) {
            throw new IllegalStateException();
        }
        if (this.waiters.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell queueCell;
            QueueCell queueCell2 = queueCell = this.waiters.get(i);
            synchronized (queueCell2) {
                if (queueCell.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (this.isCompatible(queueCell.mode)) {
                    this.waiters.remove(i--);
                    queueCell.wakeMeUp();
                    this.setGrantedMode(queueCell.mode);
                    if (this.getThreadInfo(queueCell.t) == null) {
                        ThreadInfo threadInfo = new ThreadInfo(queueCell.t, queueCell.mode);
                        threadInfo.forced = true;
                        if (queueCell.mode == 3) {
                            ++this.readersNo;
                        }
                        this.getRegisteredThreads().put(queueCell.t, threadInfo);
                    }
                } else {
                    this.setGrantedMode(1);
                    break;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpReaders() {
        assert (this.getGrantedMode(false) == 0 || this.getGrantedMode(false) == 3);
        if (this.waiters.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.waiters.size(); ++i) {
            QueueCell queueCell;
            QueueCell queueCell2 = queueCell = this.waiters.get(i);
            synchronized (queueCell2) {
                if (queueCell.isGotOut()) {
                    this.waiters.remove(i--);
                    continue;
                }
                if (queueCell.mode == 3) {
                    this.waiters.remove(i--);
                    queueCell.wakeMeUp();
                    this.setGrantedMode(3);
                    if (this.getThreadInfo(queueCell.t) == null) {
                        ThreadInfo threadInfo = new ThreadInfo(queueCell.t, queueCell.mode);
                        threadInfo.forced = true;
                        ++this.readersNo;
                        this.getRegisteredThreads().put(queueCell.t, threadInfo);
                    }
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRequest(final int n, final Runnable runnable, Executor executor) {
        ThreadInfo threadInfo;
        if (this == EVENT) {
            Mutex.doEventRequest(runnable);
            return;
        }
        if (this.wrapper != null) {
            Mutex mutex = (Mutex)this.LOCK;
            mutex.postRequest(n, runnable, this.wrapper);
            return;
        }
        final Thread thread = Thread.currentThread();
        Object object = this.LOCK;
        synchronized (object) {
            threadInfo = this.getThreadInfo(thread);
            if (threadInfo != null) {
                if (n == threadInfo.mode && threadInfo.counts[5 - n] == 0) {
                    this.enter(n, thread, 0L);
                } else {
                    threadInfo.enqueue(n, runnable);
                    return;
                }
            }
        }
        if (threadInfo == null) {
            if (executor != null) {
                class Exec
                implements Runnable {
                    Exec() {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Mutex.this.enter(n, thread, 0L);
                        try {
                            runnable.run();
                        }
                        finally {
                            Mutex.this.leave(thread);
                        }
                    }
                }
                executor.execute(new Exec());
                return;
            }
            this.enter(n, thread, 0L);
            try {
                runnable.run();
            }
            finally {
                this.leave(thread);
            }
            return;
        }
        try {
            runnable.run();
        }
        finally {
            this.leave(thread);
        }
    }

    private boolean isCompatible(int n) {
        if (n == 3 && this.getGrantedMode(false) == 1 && this.getOrigMode() == 3) {
            return true;
        }
        return cmatrix[n][this.getGrantedMode(false)];
    }

    private ThreadInfo getThreadInfo(Thread thread) {
        return this.getRegisteredThreads().get(thread);
    }

    private boolean canUpgrade(int n, int n2) {
        return n == 3 && n2 == 2 && this.readersNo == 1;
    }

    private <T> T doWrapperAccess(final ExceptionAction<T> exceptionAction, final Runnable runnable, final boolean bl) throws MutexException {
        class R
        implements Runnable {
            T ret;
            MutexException e;

            R() {
            }

            @Override
            public void run() {
                Mutex mutex = (Mutex)Mutex.this.LOCK;
                try {
                    if (bl) {
                        if (exceptionAction != null) {
                            this.ret = mutex.readAccess(exceptionAction);
                        } else {
                            mutex.readAccess(runnable);
                        }
                    } else if (exceptionAction != null) {
                        this.ret = mutex.writeAccess(exceptionAction);
                    } else {
                        mutex.writeAccess(runnable);
                    }
                }
                catch (MutexException mutexException) {
                    this.e = mutexException;
                }
            }
        }
        R r = new R();
        Mutex mutex = (Mutex)this.LOCK;
        if (mutex.isWriteAccess() || mutex.isReadAccess()) {
            r.run();
        } else {
            this.wrapper.execute(r);
        }
        if (r.e != null) {
            throw r.e;
        }
        return r.ret;
    }

    private static void doEvent(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    private static void doEventRequest(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    private static <T> T doEventAccess(final ExceptionAction<T> exceptionAction) throws MutexException {
        Object object;
        if (Mutex.isDispatchThread()) {
            try {
                return exceptionAction.run();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new MutexException(exception);
            }
        }
        final AtomicReference atomicReference = new AtomicReference();
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        final AtomicBoolean atomicBoolean2 = new AtomicBoolean();
        AtomicBoolean atomicBoolean3 = new AtomicBoolean();
        try {
            class AWTWorker
            implements Runnable {
                AWTWorker() {
                }

                @Override
                public void run() {
                    atomicBoolean.set(true);
                    try {
                        atomicReference.set(Union2.createFirst(exceptionAction.run()));
                    }
                    catch (Exception exception) {
                        atomicReference.set(Union2.createSecond(exception));
                    }
                    catch (LinkageError linkageError) {
                        atomicReference.set(Union2.createSecond(linkageError));
                    }
                    catch (StackOverflowError stackOverflowError) {
                        atomicReference.set(Union2.createSecond(stackOverflowError));
                    }
                    atomicBoolean2.set(true);
                }
            }
            object = new AWTWorker();
            EventQueue.invokeAndWait((Runnable)object);
            atomicBoolean3.set(true);
        }
        catch (InterruptedException interruptedException) {
            atomicReference.set(Union2.createSecond(interruptedException));
        }
        catch (InvocationTargetException invocationTargetException) {
            atomicReference.set(Union2.createSecond(invocationTargetException));
        }
        object = (Union2)atomicReference.get();
        if (object == null) {
            throw new IllegalStateException("#210991: got neither a result nor an exception; started=" + atomicBoolean + " finished=" + atomicBoolean2 + " invoked=" + atomicBoolean3);
        }
        if (((Union2)object).hasFirst()) {
            return (T)((Union2)object).first();
        }
        Throwable throwable = (Throwable)((Union2)object).second();
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw Mutex.notifyException(throwable);
    }

    static boolean isDispatchThread() {
        boolean bl = EventQueue.isDispatchThread();
        if (!bl && Utilities.getOperatingSystem() == 8) {
            bl = Thread.currentThread().getClass().getName().indexOf("EventDispatchThread") >= 0;
        }
        return bl;
    }

    private static MutexException notifyException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = Mutex.unfoldInvocationTargetException((InvocationTargetException)throwable);
        }
        if (throwable instanceof Error) {
            Mutex.annotateEventStack(throwable);
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            Mutex.annotateEventStack(throwable);
            throw (RuntimeException)throwable;
        }
        MutexException mutexException = new MutexException((Exception)throwable);
        mutexException.initCause(throwable);
        return mutexException;
    }

    private static void annotateEventStack(Throwable throwable) {
    }

    private static Throwable unfoldInvocationTargetException(InvocationTargetException invocationTargetException) {
        Throwable throwable;
        while ((invocationTargetException = (throwable = invocationTargetException.getTargetException()) instanceof InvocationTargetException ? (InvocationTargetException)throwable : null) != null) {
        }
        return throwable;
    }

    private void setGrantedMode(int n) {
        assert (Thread.holdsLock(this.LOCK));
        if (this.grantedMode != 1 && n == 1) {
            this.origMode = this.grantedMode;
        }
        this.grantedMode = n;
    }

    private int getGrantedMode(boolean bl) {
        assert (bl || Thread.holdsLock(this.LOCK));
        return this.grantedMode;
    }

    private int getOrigMode() {
        assert (Thread.holdsLock(this.LOCK));
        return this.origMode;
    }

    private Map<Thread, ThreadInfo> getRegisteredThreads() {
        assert (Thread.holdsLock(this.LOCK));
        return this.registeredThreads;
    }

    static {
        LOG = Logger.getLogger(Mutex.class.getName());
        EVENT = new Mutex();
        cmatrix = new boolean[][]{null, null, {true, false, false, false}, {true, false, false, true}};
    }

    public static final class Privileged {
        private Mutex parent;

        final void setParent(Mutex mutex) {
            this.parent = mutex;
        }

        public void enterReadAccess() {
            this.parent.readEnter(Thread.currentThread(), 0L);
        }

        public boolean tryReadAccess(long l) {
            return this.parent.readEnter(Thread.currentThread(), l);
        }

        public void enterWriteAccess() {
            this.parent.writeEnter(Thread.currentThread(), 0L);
        }

        public boolean tryWriteAccess(long l) {
            return this.parent.writeEnter(Thread.currentThread(), l);
        }

        public void exitReadAccess() {
            this.parent.leave(Thread.currentThread());
        }

        public void exitWriteAccess() {
            this.parent.leave(Thread.currentThread());
        }
    }

    private static final class QueueCell {
        int mode;
        Thread t;
        boolean signal;
        boolean left;
        int priority2;

        public QueueCell(int n, Thread thread) {
            this.mode = n;
            this.t = thread;
            this.left = false;
            this.priority2 = 0;
        }

        public String toString() {
            return super.toString() + " mode: " + this.mode + " thread: " + this.t;
        }

        public long getPriority() {
            return this.priority2 == 0 ? this.t.getPriority() : this.priority2;
        }

        public boolean isGotOut() {
            return this.left;
        }

        public void sleep() {
            this.sleep(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void sleep(long l) {
            block9: {
                boolean bl = false;
                while (true) {
                    if (this.signal) break block9;
                    try {
                        long l2 = System.currentTimeMillis();
                        this.wait(l);
                        if (LOG.isLoggable(Level.FINE) && EventQueue.isDispatchThread() && System.currentTimeMillis() - l2 > 1000L) {
                            LOG.log(Level.WARNING, this.toString(), new IllegalStateException("blocking on a mutex from EQ"));
                        }
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        LOG.log(Level.FINE, null, interruptedException);
                    }
                }
                finally {
                    this.left = true;
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void wakeMeUp() {
            this.signal = true;
            this.notifyAll();
        }
    }

    private static final class InternalLock {
        InternalLock() {
        }
    }

    private static final class ThreadInfo {
        boolean forced;
        final Thread t;
        int mode;
        int[] counts;
        List<Runnable>[] queues;
        int rsnapshot;

        public ThreadInfo(Thread thread, int n) {
            this.t = thread;
            this.mode = n;
            this.counts = new int[4];
            this.queues = new List[4];
            this.counts[n] = 1;
        }

        public String toString() {
            return super.toString() + " thread: " + this.t + " mode: " + this.mode + " X: " + this.counts[2] + " S: " + this.counts[3];
        }

        public void enqueue(int n, Runnable runnable) {
            if (this.queues[n] == null) {
                this.queues[n] = new ArrayList<Runnable>(13);
            }
            this.queues[n].add(runnable);
        }

        public List dequeue(int n) {
            List<Runnable> list = this.queues[n];
            this.queues[n] = null;
            return list;
        }

        public int getRunnableCount(int n) {
            return this.queues[n] == null ? 0 : this.queues[n].size();
        }
    }

    public static interface ExceptionAction<T> {
        public T run() throws Exception;
    }

    public static interface Action<T>
    extends ExceptionAction<T> {
        @Override
        public T run();
    }
}

