/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofInstanceValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class InstanceDump
extends HprofObject
implements Instance {
    final ClassDump dumpClass;

    InstanceDump(ClassDump classDump, long l) {
        super(l);
        this.dumpClass = classDump;
    }

    @Override
    public List getFieldValues() {
        long l = this.fileOffset + (long)this.getInstanceFieldValuesOffset();
        List list = this.dumpClass.getAllInstanceFields();
        ArrayList<HprofInstanceValue> arrayList = new ArrayList<HprofInstanceValue>(list.size());
        for (HprofField hprofField : list) {
            if (hprofField.getValueType() == 2) {
                arrayList.add(new HprofInstanceObjectValue(this, hprofField, l));
            } else {
                arrayList.add(new HprofInstanceValue(this, hprofField, l));
            }
            l += (long)hprofField.getValueSize();
        }
        return arrayList;
    }

    @Override
    public boolean isGCRoot() {
        return this.getHprof().getGCRoot(this) != null;
    }

    @Override
    public long getInstanceId() {
        return this.dumpClass.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    @Override
    public int getInstanceNumber() {
        return this.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    @Override
    public JavaClass getJavaClass() {
        return this.dumpClass;
    }

    @Override
    public Instance getNearestGCRootPointer() {
        return this.getHprof().getNearestGCRootPointer(this);
    }

    @Override
    public long getReachableSize() {
        return 0L;
    }

    @Override
    public List getReferences() {
        return this.getHprof().findReferencesFor(this.getInstanceId());
    }

    @Override
    public long getRetainedSize() {
        return this.getHprof().getRetainedSize(this);
    }

    @Override
    public long getSize() {
        return this.dumpClass.getInstanceSize();
    }

    @Override
    public List getStaticFieldValues() {
        return this.dumpClass.getStaticFieldValues();
    }

    @Override
    public Object getValueOfField(String string) {
        Iterator iterator = this.getFieldValues().iterator();
        FieldValue fieldValue = null;
        while (iterator.hasNext()) {
            FieldValue fieldValue2 = (FieldValue)iterator.next();
            if (!fieldValue2.getField().getName().equals(string)) continue;
            fieldValue = fieldValue2;
        }
        if (fieldValue == null) {
            return null;
        }
        if (fieldValue instanceof HprofInstanceObjectValue) {
            return ((HprofInstanceObjectValue)fieldValue).getInstance();
        }
        return ((HprofInstanceValue)fieldValue).getTypeValue();
    }

    private int getInstanceFieldValuesOffset() {
        int n = this.dumpClass.getHprofBuffer().getIDSize();
        return 1 + n + 4 + n + 4;
    }

    private HprofHeap getHprof() {
        return this.dumpClass.getHprof();
    }
}

