/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.utils.StringUtils;

public class ResultsSnapshot {
    protected static final Logger LOGGER = Logger.getLogger(ResultsSnapshot.class.getName());
    private static final int SNAPSHOT_VERSION = 1;
    protected long beginTime;
    protected long timeTaken;

    public ResultsSnapshot() {
    }

    protected ResultsSnapshot(long l, long l2) {
        this.beginTime = l;
        this.timeTaken = l2;
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getTimeTaken() {
        return this.timeTaken;
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != 1) {
            throw new IOException("Stored version not supported: " + n);
        }
        this.beginTime = dataInputStream.readLong();
        this.timeTaken = dataInputStream.readLong();
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.debugValues();
        }
    }

    public String toString() {
        return StringUtils.formatUserDate(new Date(this.timeTaken));
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(1);
        dataOutputStream.writeLong(this.beginTime);
        dataOutputStream.writeLong(this.timeTaken);
    }

    protected String debugLength(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof int[]) {
            return "" + ((int[])object).length;
        }
        if (object instanceof long[]) {
            return "" + ((long[])object).length;
        }
        if (object instanceof float[]) {
            return "" + ((float[])object).length;
        }
        if (object instanceof Object[]) {
            return "" + ((Object[])object).length;
        }
        return "Unknown";
    }

    private void debugValues() {
        LOGGER.finest("beginTime: " + this.beginTime);
        LOGGER.finest("timeTaken: " + this.timeTaken);
    }
}

