/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.Bundle;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ui.FormLayoutHelper;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class PatternSandbox
extends JPanel
implements HierarchyListener {
    private static final Logger LOG = Logger.getLogger(PatternSandbox.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(PatternSandbox.class);
    protected JComboBox<String> cboxPattern;
    private JLabel lblPattern;
    protected JLabel lblHint;
    private JLabel lblOptions;
    private JPanel pnlOptions;
    protected JTextPane textPane;
    private JButton btnApply;
    private JButton btnCancel;
    private JScrollPane textScrollPane;
    protected Highlighter highlighter;
    protected Highlighter.HighlightPainter painter;
    protected BasicSearchCriteria searchCriteria;
    private Color cboxPatternForegroundStd = null;
    private static final Color errorColor = PatternSandbox.chooseErrorColor();

    protected void initComponents() {
        this.cboxPattern = new JComboBox();
        this.cboxPattern.setEditable(true);
        this.cboxPattern.setRenderer(new ShorteningCellRenderer());
        this.lblPattern = new JLabel();
        this.lblPattern.setLabelFor(this.cboxPattern);
        this.lblHint = new JLabel();
        this.lblHint.setForeground(SystemColor.controlDkShadow);
        this.lblOptions = new JLabel();
        this.textPane = new JTextPane();
        this.textScrollPane = new JScrollPane();
        this.textScrollPane.setViewportView(this.textPane);
        this.textScrollPane.setPreferredSize(new Dimension(350, 100));
        this.textScrollPane.setBorder(new BevelBorder(1));
        this.searchCriteria = new BasicSearchCriteria();
        this.initSpecificComponents();
        this.pnlOptions = this.createOptionsPanel();
        this.btnApply = new JButton();
        this.btnCancel = new JButton();
        this.cboxPatternForegroundStd = this.cboxPattern.getEditor().getEditorComponent().getForeground();
        this.initTextPaneContent();
        this.initHighlighter();
        this.setMnemonics();
        this.layoutComponents();
        this.initInteraction();
        this.addHierarchyListener(this);
        this.highlightMatchesLater();
    }

    private void initButtonsInteraction() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.closeDialog();
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.apply();
                PatternSandbox.this.closeDialog();
            }
        });
    }

    private void initTextInputInteraction() {
        this.cboxPattern.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!keyEvent.isActionKey()) {
                    PatternSandbox.this.highlightMatchesLater();
                }
            }
        });
        this.cboxPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }
        });
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }
        });
    }

    private void layoutComponents() {
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(this, FormLayoutHelper.EAGER_COLUMN);
        formLayoutHelper.setAllGaps(true);
        JPanel jPanel = this.createFormPanel();
        JPanel jPanel2 = this.createButtonsPanel();
        formLayoutHelper.addRow(-1, jPanel.getPreferredSize().height, jPanel.getPreferredSize().height, jPanel);
        formLayoutHelper.addRow(-1, 200, Short.MAX_VALUE, this.textScrollPane);
        formLayoutHelper.addRow(-1, jPanel2.getPreferredSize().height, jPanel2.getPreferredSize().height, jPanel2);
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel();
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.EAGER_COLUMN, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);
        formLayoutHelper.setInlineGaps(true);
        formLayoutHelper.addRow(this.getExtraButton(), this.btnApply, this.btnCancel);
        return jPanel;
    }

    private JPanel createFormPanel() {
        JPanel jPanel = new JPanel();
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.EAGER_COLUMN);
        formLayoutHelper.setInlineGaps(true);
        formLayoutHelper.addRow(this.lblPattern, this.cboxPattern);
        if (this.lblHint.getText() != null && !"".equals(this.lblHint.getText())) {
            formLayoutHelper.addRow(new JLabel(), this.lblHint);
        }
        formLayoutHelper.addRow(this.lblOptions, this.pnlOptions);
        return jPanel;
    }

    private void setMnemonics() {
        Mnemonics.setLocalizedText((JLabel)this.lblPattern, (String)this.getPatternLabelText());
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)this.getHintLabelText());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)PatternSandbox.getText("PatternSandbox.btnCancel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApply, (String)PatternSandbox.getText("PatternSandbox.btnApply.text"));
    }

    private void initHighlighter() {
        this.highlighter = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(PatternSandbox.chooseHighlightColor());
        this.textPane.setHighlighter(this.highlighter);
    }

    private void initInteraction() {
        this.initTextInputInteraction();
        this.initButtonsInteraction();
    }

    private void setKeys() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        String string = "cancel";
        this.getRootPane().getInputMap(1).put(keyStroke, string);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(string, abstractAction);
        this.getRootPane().setDefaultButton(this.btnApply);
    }

    protected void highlightMatchesLater() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatternSandbox.this.highlightMatches();
            }
        });
    }

    protected void highlightMatches() {
        Pattern pattern;
        this.highlighter.removeAllHighlights();
        Object object = this.cboxPattern.getEditor().getItem();
        if (object == null || object.toString().isEmpty()) {
            return;
        }
        String string = object.toString();
        try {
            pattern = this.getPatternForHighlighting(string);
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.cboxPattern.getEditor().getEditorComponent().setForeground(this.cboxPatternForegroundStd);
        }
        catch (Throwable throwable) {
            this.cboxPattern.getEditor().getEditorComponent().setForeground(errorColor);
            return;
        }
        try {
            this.highlightIndividualMatches(pattern);
        }
        catch (TimeoutExeption timeoutExeption) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_PatternSansboxTimout(), 0));
            LOG.log(Level.INFO, timeoutExeption.getMessage(), timeoutExeption);
        }
    }

    private static String getText(String string) {
        return NbBundle.getMessage(PatternSandbox.class, (String)string);
    }

    private static <T> List<T> reverse(List<T> list) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : list) {
            linkedList.add(0, t);
        }
        return linkedList;
    }

    private void closeDialog() {
        this.saveTextPaneContent();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            window.dispose();
        }
    }

    private static String getSelectedItemAsString(JComboBox<String> jComboBox) {
        if (jComboBox.getSelectedItem() != null) {
            return jComboBox.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getID() == 1400) {
            this.setKeys();
        }
    }

    protected JComponent getExtraButton() {
        return new JLabel();
    }

    protected abstract String getPatternLabelText();

    protected abstract String getHintLabelText();

    protected abstract JPanel createOptionsPanel();

    protected abstract void initSpecificComponents();

    protected abstract void apply();

    protected abstract Pattern getPatternForHighlighting(String var1);

    protected abstract void highlightIndividualMatches(Pattern var1);

    protected abstract void initTextPaneContent();

    protected abstract void saveTextPaneContent();

    protected abstract String getTitle();

    public static void openDialog(PatternSandbox patternSandbox, JComponent jComponent) {
        JDialog jDialog = new JDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jComponent));
        jDialog.add(patternSandbox);
        jDialog.setTitle(patternSandbox.getTitle());
        jDialog.setModal(true);
        jDialog.setLocation(jComponent.getLocationOnScreen());
        jDialog.pack();
        patternSandbox.cboxPattern.requestFocusInWindow();
        jDialog.setVisible(true);
    }

    private static Color chooseErrorColor() {
        return PatternSandbox.chooseColor("nb.search.sandbox.regexp.wrong", Color.RED);
    }

    private static Color chooseHighlightColor() {
        return PatternSandbox.chooseColor("nb.search.sandbox.highlight", Color.ORANGE);
    }

    private static Color chooseColor(String string, Color color) {
        Color color2 = UIManager.getColor(string);
        return color2 == null ? color : color2;
    }

    private class ShorteningCellRenderer
    extends DefaultListCellRenderer {
        private static final int MAX_LENGTH = 50;
        private static final String THREE_DOTS = "...";

        private ShorteningCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
            if (object instanceof String && component instanceof JLabel && object.toString().length() > 50) {
                ((JLabel)component).setText(object.toString().substring(0, 50 - THREE_DOTS.length()) + THREE_DOTS);
            }
            return component;
        }
    }

    private static class TimeoutExeption
    extends RuntimeException {
        private TimeoutExeption() {
        }
    }

    private static class TimeLimitedCharSequence
    implements CharSequence {
        private final CharSequence content;
        private final long dateCreated;
        int counter = 0;

        public TimeLimitedCharSequence(CharSequence charSequence) {
            this(charSequence, System.currentTimeMillis());
        }

        public TimeLimitedCharSequence(CharSequence charSequence, long l) {
            this.content = charSequence == null ? "" : charSequence;
            this.dateCreated = l;
        }

        @Override
        public int length() {
            return this.content.length();
        }

        @Override
        public char charAt(int n) {
            if (this.counter++ % 1024 == 0 && System.currentTimeMillis() - this.dateCreated > 1000L) {
                throw new TimeoutExeption();
            }
            return this.content.charAt(n);
        }

        @Override
        public CharSequence subSequence(int n, int n2) {
            return new TimeLimitedCharSequence(this.content.subSequence(n, n2), this.dateCreated);
        }
    }

    protected class RegexpModeListener
    implements ItemListener {
        protected RegexpModeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            PatternSandbox.this.lblHint.setText(UiUtils.getFileNamePatternsExample(itemEvent.getStateChange() == 1));
        }
    }

    static class PathPatternComposer
    extends PathPatternSandbox
    implements ItemListener {
        private JCheckBox chkFileRegexp;

        public PathPatternComposer(String string, boolean bl) {
            super(string);
            this.pathRegexp = bl;
            this.initComponents();
            if (bl) {
                this.searchCriteria.setFileNameRegexp(true);
            }
        }

        @Override
        protected void initSpecificComponents() {
            super.initSpecificComponents();
            this.chkFileRegexp = new JCheckBox();
            this.chkFileRegexp.addItemListener(this);
            this.chkFileRegexp.addItemListener(new RegexpModeListener());
            this.chkFileRegexp.setSelected(this.pathRegexp);
            Mnemonics.setLocalizedText((AbstractButton)this.chkFileRegexp, (String)PatternSandbox.getText("BasicSearchForm.chkFileNameRegex.text"));
        }

        @Override
        protected JPanel createOptionsPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.chkFileRegexp);
            return jPanel;
        }

        @Override
        protected final void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern), this.chkFileRegexp.isSelected());
        }

        protected void onApply(String string, boolean bl) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.chkFileRegexp) {
                this.searchCriteria.setFileNameRegexp(this.chkFileRegexp.isSelected());
                this.highlightMatchesLater();
            }
        }

        @Override
        protected String getHintLabelText() {
            return UiUtils.getFileNamePatternsExample(this.pathRegexp);
        }
    }

    public static class PathPatternSandbox
    extends PatternSandbox {
        protected boolean pathRegexp;
        protected String value;

        public PathPatternSandbox(String string) {
            this.value = string;
            this.initComponents();
            this.searchCriteria.setFileNameRegexp(true);
        }

        @Override
        protected void initSpecificComponents() {
            this.cboxPattern.setSelectedItem(this.value);
            FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
            for (String string : PatternSandbox.reverse(findDialogMemory.getFileNamePatterns())) {
                this.cboxPattern.addItem(string);
            }
        }

        @Override
        protected String getPatternLabelText() {
            return PatternSandbox.getText("BasicSearchForm.lblFileNamePattern.text");
        }

        @Override
        protected String getHintLabelText() {
            return "";
        }

        @Override
        protected JPanel createOptionsPanel() {
            return new JPanel();
        }

        @Override
        protected void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern));
        }

        protected void onApply(String string) {
        }

        @Override
        protected void initTextPaneContent() {
            String string = FindDialogMemory.getDefault().getPathSandboxContent();
            this.textPane.setText(string);
        }

        @Override
        protected void saveTextPaneContent() {
            String string = this.textPane.getText();
            FindDialogMemory.getDefault().setPathSandboxContent(string);
        }

        @Override
        protected Pattern getPatternForHighlighting(String string) {
            this.searchCriteria.setFileNamePattern(string);
            this.searchCriteria.onOk();
            return this.searchCriteria.getFileNamePattern();
        }

        @Override
        protected void highlightIndividualMatches(Pattern pattern) {
            String string = this.textPane.getText().replaceAll("\r\n", "\n");
            Pattern pattern2 = Pattern.compile("\n");
            Matcher matcher = pattern2.matcher(new TimeLimitedCharSequence(string));
            int n = 0;
            while (matcher.find()) {
                this.matchLine(string, pattern, n, matcher.start());
                n = matcher.end();
            }
            this.matchLine(string, pattern, n, string.length());
            this.textPane.repaint();
        }

        private void matchLine(String string, Pattern pattern, int n, int n2) {
            boolean bl;
            if (this.searchCriteria.isFileNameRegexp()) {
                Matcher matcher = pattern.matcher(string.substring(n, n2));
                bl = matcher.find();
            } else {
                int n3 = string.lastIndexOf("/", n2);
                if (n3 == -1 || n3 < n) {
                    n3 = string.lastIndexOf("\\", n2);
                }
                int n4 = n3 == -1 || n3 < n ? n : n3 + 1;
                Matcher matcher = pattern.matcher(string.substring(n4, n2));
                bl = matcher.matches();
            }
            if (bl) {
                try {
                    this.highlighter.addHighlight(n, n2, this.painter);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }

        @Override
        protected JComponent getExtraButton() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            final JButton jButton = new JButton();
            jPanel.add(jButton);
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)PatternSandbox.getText("PathPatternSandbox.browseButton.text"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setMultiSelectionEnabled(true);
                    jFileChooser.showOpenDialog(jButton);
                    if (jFileChooser.getSelectedFiles() == null) {
                        return;
                    }
                    for (File file : jFileChooser.getSelectedFiles()) {
                        PathPatternSandbox.this.textPane.setText(PathPatternSandbox.this.textPane.getText() + "\n" + file.getAbsolutePath());
                    }
                }
            });
            return jPanel;
        }

        @Override
        protected String getTitle() {
            return PatternSandbox.getText("PathPatternSandbox.title");
        }
    }

    static class TextPatternSandbox
    extends PatternSandbox
    implements ItemListener {
        private static final String LINE_SEP = "pattern.sandbox.line.separator";
        private JCheckBox chkMatchCase;
        private String regexp;
        private boolean matchCase;
        private LineEnding lineEnding = null;

        public TextPatternSandbox(String string, boolean bl) {
            this.regexp = string;
            this.matchCase = bl;
            this.initComponents();
            this.searchCriteria.setMatchType(SearchPattern.MatchType.REGEXP);
        }

        @Override
        protected void initSpecificComponents() {
            this.chkMatchCase = new JCheckBox();
            this.chkMatchCase.addItemListener(this);
            this.setSpecificMnemonics();
            this.chkMatchCase.setSelected(this.matchCase);
            this.cboxPattern.setSelectedItem(this.regexp);
            SearchHistory searchHistory = SearchHistory.getDefault();
            for (SearchPattern searchPattern : searchHistory.getSearchPatterns()) {
                this.cboxPattern.addItem(searchPattern.getSearchExpression());
            }
        }

        private void setSpecificMnemonics() {
            Mnemonics.setLocalizedText((AbstractButton)this.chkMatchCase, (String)PatternSandbox.getText("BasicSearchForm.chkCaseSensitive.text"));
        }

        @Override
        protected String getPatternLabelText() {
            return PatternSandbox.getText("BasicSearchForm.lblTextToFind.text");
        }

        @Override
        protected JPanel createOptionsPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.add(this.chkMatchCase);
            return jPanel;
        }

        @Override
        protected final void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern), this.chkMatchCase.isSelected());
        }

        protected void onApply(String string, boolean bl) {
        }

        @Override
        protected void initTextPaneContent() {
            String string = FindDialogMemory.getDefault().getTextSandboxContent();
            this.textPane.setText(string);
        }

        @Override
        protected void saveTextPaneContent() {
            String string = this.textPane.getText();
            FindDialogMemory.getDefault().setTextSandboxContent(string);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.chkMatchCase) {
                this.searchCriteria.setCaseSensitive(this.chkMatchCase.isSelected());
            }
            this.highlightMatchesLater();
        }

        @Override
        protected Pattern getPatternForHighlighting(String string) {
            this.searchCriteria.onOk();
            this.searchCriteria.setTextPattern(string);
            return this.searchCriteria.getTextPattern();
        }

        @Override
        protected void highlightIndividualMatches(Pattern pattern) {
            String string = this.textPane.getText();
            Matcher matcher = pattern.matcher(new TimeLimitedCharSequence(string));
            int n = 0;
            int n2 = 0;
            while (matcher.find()) {
                try {
                    int n3 = matcher.start() - (n += this.countCRs(string, n2, matcher.start()));
                    int n4 = matcher.end() - (n += this.countCRs(string, matcher.start(), matcher.end()));
                    n2 = matcher.end();
                    this.highlighter.addHighlight(n3, n4, this.painter);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, badLocationException);
                }
            }
            this.textPane.repaint();
        }

        private int countCRs(String string, int n, int n2) {
            if (!LineEnding.CRLF.equals((Object)this.lineEnding)) {
                return 0;
            }
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                if (string.charAt(i) != '\r') continue;
                ++n3;
            }
            return n3;
        }

        @Override
        protected String getTitle() {
            return PatternSandbox.getText("TextPatternSandbox.title");
        }

        @Override
        protected String getHintLabelText() {
            return "";
        }

        @Override
        protected JComponent getExtraButton() {
            JPanel jPanel = new JPanel();
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.LBL_LineEnding());
            JComboBox<LineEnding> jComboBox = new JComboBox<LineEnding>(new LineEnding[0]);
            jComboBox.getAccessibleContext().setAccessibleName(Bundle.LBL_LineEnding_accName());
            jComboBox.setToolTipText(Bundle.LBL_LineEnding_tooltip());
            jLabel.setLabelFor(jComboBox);
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.add(jLabel);
            jPanel.add(jComboBox);
            this.loadLineEnding(jComboBox);
            return jPanel;
        }

        private void updateLineEnding() {
            if (this.lineEnding != null) {
                this.textPane.getDocument().putProperty("__EndOfLine__", this.lineEnding.getSequence());
                this.highlightMatchesLater();
            }
        }

        private void loadLineEnding(final JComboBox<LineEnding> jComboBox) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    String string = NbPreferences.forModule(PatternSandbox.class).get(TextPatternSandbox.LINE_SEP, null);
                    if (string != null) {
                        try {
                            TextPatternSandbox.this.lineEnding = LineEnding.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LOG.log(Level.FINE, "Unknown LEType {0}", string);
                        }
                    }
                    if (TextPatternSandbox.this.lineEnding == null) {
                        TextPatternSandbox.this.lineEnding = Utilities.isWindows() ? LineEnding.CRLF : LineEnding.LF;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextPatternSandbox.this.fillLineEndingComboBox(jComboBox);
                        }
                    });
                }
            });
        }

        private void fillLineEndingComboBox(final JComboBox<LineEnding> jComboBox) {
            jComboBox.addItem(LineEnding.CRLF);
            jComboBox.addItem(LineEnding.LF);
            jComboBox.addItem(LineEnding.CR);
            jComboBox.setSelectedItem((Object)this.lineEnding);
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TextPatternSandbox.this.lineEnding = (LineEnding)((Object)jComboBox.getSelectedItem());
                    TextPatternSandbox.this.updateLineEnding();
                    TextPatternSandbox.this.saveLineEnding();
                }
            });
            this.updateLineEnding();
        }

        private void saveLineEnding() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    if (TextPatternSandbox.this.lineEnding != null) {
                        NbPreferences.forModule(PatternSandbox.class).put(TextPatternSandbox.LINE_SEP, TextPatternSandbox.this.lineEnding.name());
                    }
                }
            });
        }

        private static enum LineEnding {
            CRLF("\r\n", Bundle.LBL_Windows()),
            LF("\n", Bundle.LBL_Unix()),
            CR("\r", Bundle.LBL_MacOld());

            private final String sequence;
            private final String name;

            private LineEnding(String string2, String string3) {
                this.sequence = string2;
                this.name = string3;
            }

            public String toString() {
                return this.name;
            }

            public String getSequence() {
                return this.sequence;
            }
        }
    }
}

