/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.modules.ModuleInstall;

public final class ProfilerModule
extends ModuleInstall {
    public static final String LIBS_DIR = "lib";

    public boolean closing() {
        if (!NetBeansProfiler.isInitialized()) {
            return true;
        }
        int n = Profiler.getDefault().getProfilingState();
        int n2 = Profiler.getDefault().getProfilingMode();
        if (n == 8 || n == 4) {
            if (n2 == 1) {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromProfileMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().stopApp();
            } else {
                if (!ProfilerDialogs.displayConfirmation((String)Bundle.ProfilerModule_ExitingFromAttachMessage(), (String)Bundle.ProfilerModule_QuestionDialogCaption())) {
                    return false;
                }
                Profiler.getDefault().detachFromApp();
            }
        }
        if (LiveResultsWindow.hasDefault()) {
            LiveResultsWindow.getDefault().ideClosing();
        }
        return true;
    }

    public void restored() {
        super.restored();
        MiscUtils.setVerbosePrint();
        MiscUtils.deleteHeapTempFiles();
    }

    public void uninstalled() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    int n = Profiler.getDefault().getProfilingState();
                    int n2 = Profiler.getDefault().getProfilingMode();
                    if (n == 8 || n == 4) {
                        if (n2 == 1) {
                            Profiler.getDefault().stopApp();
                        } else {
                            Profiler.getDefault().detachFromApp();
                        }
                    }
                    ((NetBeansProfiler)Profiler.getDefault()).shutdown();
                    ResetResultsAction.getInstance().actionPerformed(null);
                }
            });
        }
        catch (Exception exception) {
            ProfilerLogger.log((Exception)exception);
        }
        super.uninstalled();
    }
}

