/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.StackTraceSnapshotBuilder;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.api.GoToSource;
import org.openide.filesystems.FileObject;

public final class SampledCPUSnapshot {
    public static final String OPEN_THREADS_URL = "file:/stackframe/";
    private FileObject npssFile;
    private LoadedSnapshot.SamplesInputStream samplesStream;
    private long lastTimestamp;
    private int samples;
    private int currentIndex;
    private LoadedSnapshot.ThreadsSample sample;
    private StackTraceSnapshotBuilder builder;
    private long startTime;

    public SampledCPUSnapshot(FileObject fileObject) throws IOException {
        this.samplesStream = new LoadedSnapshot.SamplesInputStream(fileObject.getInputStream());
        this.npssFile = fileObject;
        this.samples = this.samplesStream.getSamples();
        this.lastTimestamp = this.samplesStream.getLastTimestamp();
        if (this.samples == 0) {
            this.initSamples();
        }
        this.currentIndex = -1;
    }

    public int getSamplesCount() {
        return this.samples;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimestamp(int n) throws IOException {
        if (n == this.getSamplesCount() - 1) {
            return this.lastTimestamp;
        }
        this.getSample(n);
        long l = this.sample.getTime();
        if (this.startTime == 0L) {
            this.startTime = l;
            this.builder = new StackTraceSnapshotBuilder();
        }
        this.builder.addStacktrace(this.sample.getTinfos(), l);
        return l;
    }

    public long getValue(int n, int n2) throws IOException {
        this.getSample(n);
        long l = 0L;
        for (ThreadInfo threadInfo : this.sample.getTinfos()) {
            if (!threadInfo.getThreadState().equals((Object)Thread.State.RUNNABLE)) continue;
            l += (long)threadInfo.getStackTrace().length;
        }
        return l;
    }

    public List<Integer> getIntervals(int n, int n2, PrestimeCPUCCTNode prestimeCPUCCTNode) throws IOException {
        Object object;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        LoadedSnapshot.SamplesInputStream samplesInputStream = this.seek(n);
        PrestimeCPUCCTNode prestimeCPUCCTNode2 = prestimeCPUCCTNode;
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        boolean bl = false;
        do {
            PrestimeCPUCCTNode prestimeCPUCCTNode3;
            if (!(prestimeCPUCCTNode2 instanceof PrestimeCPUCCTNode) || !this.isRegular(prestimeCPUCCTNode3 = prestimeCPUCCTNode2)) continue;
            object = prestimeCPUCCTNode3.getMethodClassNameAndSig();
            if (object[1].endsWith("[native]")) {
                object[1] = ((String)object[1]).substring(0, ((String)object[1]).length() - "[native]".length());
            }
            arrayList2.add(0, (String[])object);
        } while ((prestimeCPUCCTNode2 = prestimeCPUCCTNode2.getParent()) != null);
        for (int i = n; i <= n2; ++i) {
            object = samplesInputStream.readSample();
            ThreadInfo[] threadInfoArray = ((LoadedSnapshot.ThreadsSample)object).getTinfos();
            if (this.findStack(arrayList2, threadInfoArray)) {
                if (!bl) {
                    arrayList.add(i);
                }
                bl = true;
                continue;
            }
            if (bl) {
                arrayList.add(i - 1);
            }
            bl = false;
        }
        if (bl) {
            arrayList.add(n2);
        }
        samplesInputStream.close();
        samplesInputStream = null;
        return arrayList;
    }

    private boolean findStack(List<String[]> list, ThreadInfo[] threadInfoArray) {
        for (ThreadInfo threadInfo : threadInfoArray) {
            int n;
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            if (stackTraceElementArray == null || stackTraceElementArray.length < list.size()) continue;
            for (n = 0; n < list.size(); ++n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - n - 1];
                String[] stringArray = list.get(n);
                if (!stackTraceElement.getClassName().equals(stringArray[0]) || !stackTraceElement.getMethodName().equals(stringArray[1])) break;
            }
            if (n != list.size()) continue;
            return true;
        }
        return false;
    }

    public String getThreadDump(int n) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(4096);
        LoadedSnapshot.SamplesInputStream samplesInputStream = this.seek(n);
        LoadedSnapshot.ThreadsSample threadsSample = samplesInputStream.readSample();
        ThreadInfo[] threadInfoArray = threadsSample.getTinfos();
        samplesInputStream.close();
        samplesInputStream = null;
        this.printThreads(stringBuilder, threadInfoArray);
        return stringBuilder.toString();
    }

    public LoadedSnapshot getCPUSnapshot(int n, int n2) throws IOException {
        LoadedSnapshot loadedSnapshot;
        if (this.builder != null && this.samplesStream == null && n == 0 && n2 == this.getSamplesCount() - 1) {
            loadedSnapshot = this.createSnapshot(this.startTime / 1000000L, this.builder);
            this.builder = null;
        } else {
            LoadedSnapshot.SamplesInputStream samplesInputStream = this.seek(n);
            StackTraceSnapshotBuilder stackTraceSnapshotBuilder = new StackTraceSnapshotBuilder();
            long l = 0L;
            for (int i = n; i <= n2; ++i) {
                LoadedSnapshot.ThreadsSample threadsSample = samplesInputStream.readSample();
                if (l == 0L) {
                    l = threadsSample.getTime() / 1000000L;
                }
                stackTraceSnapshotBuilder.addStacktrace(threadsSample.getTinfos(), threadsSample.getTime());
            }
            samplesInputStream.close();
            samplesInputStream = null;
            loadedSnapshot = this.createSnapshot(l, stackTraceSnapshotBuilder);
        }
        return loadedSnapshot;
    }

    private LoadedSnapshot createSnapshot(long l, StackTraceSnapshotBuilder stackTraceSnapshotBuilder) throws IOException {
        CPUResultsSnapshot cPUResultsSnapshot;
        try {
            cPUResultsSnapshot = stackTraceSnapshotBuilder.createSnapshot(l);
        }
        catch (CPUResultsSnapshot.NoDataAvailableException noDataAvailableException) {
            throw new IOException(noDataAvailableException);
        }
        LoadedSnapshot loadedSnapshot = new LoadedSnapshot((ResultsSnapshot)cPUResultsSnapshot, ProfilingSettingsPresets.createCPUPreset(), null, null);
        loadedSnapshot.setSaved(true);
        return loadedSnapshot;
    }

    private LoadedSnapshot.SamplesInputStream seek(int n) throws IOException {
        LoadedSnapshot.SamplesInputStream samplesInputStream = new LoadedSnapshot.SamplesInputStream(this.npssFile.getInputStream());
        for (int i = 0; i < n; ++i) {
            samplesInputStream.readSample();
        }
        return samplesInputStream;
    }

    private void getSample(int n) throws IllegalArgumentException, IOException {
        if (this.currentIndex > n || this.currentIndex + 1 < n) {
            throw new IllegalArgumentException("current sample " + this.currentIndex + " requestd sample " + n);
        }
        if (this.currentIndex + 1 == n) {
            ++this.currentIndex;
            this.sample = this.samplesStream.readSample();
            if (n == this.getSamplesCount() - 1) {
                this.samplesStream.close();
                this.samplesStream = null;
            }
        }
    }

    private void printThreads(StringBuilder stringBuilder, ThreadInfo[] threadInfoArray) {
        boolean bl = GoToSource.isAvailable();
        stringBuilder.append("<pre>");
        for (ThreadInfo threadInfo : threadInfoArray) {
            if (threadInfo == null) continue;
            this.print16Thread(stringBuilder, threadInfo, bl);
        }
        stringBuilder.append("</pre>");
    }

    private void print16Thread(StringBuilder stringBuilder, ThreadInfo threadInfo, boolean bl) {
        LockInfo[] lockInfoArray;
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        stringBuilder.append("&nbsp;<b>");
        stringBuilder.append("\"").append(threadInfo.getThreadName()).append("\" - Thread t@").append(threadInfo.getThreadId()).append("<br>");
        stringBuilder.append("    java.lang.Thread.State: ").append((Object)threadInfo.getThreadState());
        stringBuilder.append("</b><br>");
        int n = 0;
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            LockInfo lockInfo = threadInfo.getLockInfo();
            String object = SampledCPUSnapshot.htmlize(stackTraceElement.toString());
            String string = threadInfo.getLockOwnerName();
            String string2 = stackTraceElement.getClassName();
            String string3 = stackTraceElement.getMethodName();
            int n2 = stackTraceElement.getLineNumber();
            String string4 = object;
            if (bl) {
                String string5 = OPEN_THREADS_URL + string2 + "|" + string3 + "|" + n2;
                string4 = "<a href=\"" + string5 + "\">" + object + "</a>";
            }
            stringBuilder.append("\tat ").append(string4).append("<br>");
            if (n == 0) {
                if ("java.lang.Object".equals(stackTraceElement.getClassName()) && "wait".equals(stackTraceElement.getMethodName())) {
                    if (lockInfo != null) {
                        stringBuilder.append("\t- waiting on ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append("<br>");
                    }
                } else if (lockInfo != null) {
                    if (string == null) {
                        stringBuilder.append("\t- parking to wait for ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append("<br>");
                    } else {
                        stringBuilder.append("\t- waiting to lock ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append(" owned by \"").append(string).append("\" t@").append(threadInfo.getLockOwnerId()).append("<br>");
                    }
                }
            }
            this.printMonitors(stringBuilder, monitorInfoArray, n);
            ++n;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        this.printMonitors(stringBuilder2, monitorInfoArray, -1);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("   JNI locked monitors:<br>");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if ((lockInfoArray = threadInfo.getLockedSynchronizers()) != null) {
            stringBuilder.append("<br>   Locked ownable synchronizers:");
            if (lockInfoArray.length == 0) {
                stringBuilder.append("<br>\t- None\n");
            } else {
                for (LockInfo lockInfo : lockInfoArray) {
                    stringBuilder.append("<br>\t- locked ");
                    this.printLock(stringBuilder, lockInfo);
                    stringBuilder.append("<br>");
                }
            }
        }
        stringBuilder.append("<br>");
    }

    private void printMonitors(StringBuilder stringBuilder, MonitorInfo[] monitorInfoArray, int n) {
        if (monitorInfoArray != null) {
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != n) continue;
                stringBuilder.append("\t- locked ");
                this.printLock(stringBuilder, monitorInfo);
                stringBuilder.append("<br>");
            }
        }
    }

    private void printLock(StringBuilder stringBuilder, LockInfo lockInfo) {
        String string = Integer.toHexString(lockInfo.getIdentityHashCode());
        String string2 = lockInfo.getClassName();
        stringBuilder.append("&lt;").append(string).append("&gt; (a ").append(string2).append(")");
    }

    private static String htmlize(String string) {
        return string.replace(">", "&gt;").replace("<", "&lt;");
    }

    private boolean isRegular(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        return prestimeCPUCCTNode.getThreadId() != -1 && prestimeCPUCCTNode.getMethodId() != 0 && !prestimeCPUCCTNode.isFilteredNode();
    }

    private void initSamples() throws IOException {
        LoadedSnapshot.SamplesInputStream samplesInputStream = new LoadedSnapshot.SamplesInputStream(this.npssFile.getInputStream());
        int n = (int)(this.npssFile.getSize() / 130L);
        ProgressHandle progressHandle = ProgressHandleFactory.createSystemHandle((String)"Computing snapshot samples");
        progressHandle.start(n);
        LoadedSnapshot.ThreadsSample threadsSample = samplesInputStream.readSample();
        while (threadsSample != null) {
            ++this.samples;
            this.lastTimestamp = threadsSample.getTime();
            if (this.samples < n) {
                progressHandle.progress(this.samples);
            }
            threadsSample = samplesInputStream.readSample();
        }
        progressHandle.finish();
    }
}

