/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.memory.AllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;

public class LiveAllocResultsPanel
extends AllocResultsPanel
implements LiveResultsPanel,
ActionListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private static final String SHOW_STACK_TRACES_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_LiveShowStackTracesPopupItemName");
    private static final String LOG_CLASS_HISTORY = messages.getString("LiveResultsPanel_LogClassHistory");
    protected TargetAppRunner runner;
    private ClassHistoryActionsHandler historyActionsHandler;
    private ClassHistoryDataManager classHistoryManager;
    private JMenuItem popupShowSource;
    private JMenuItem popupShowStacks;
    private JMenuItem startHisto;
    private JPopupMenu memoryResPopupMenu;
    private ProfilingSessionStatus status;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveAllocResultsPanel(TargetAppRunner targetAppRunner, MemoryResUserActionsHandler memoryResUserActionsHandler, ClassHistoryActionsHandler classHistoryActionsHandler, ClassHistoryDataManager classHistoryDataManager) {
        super(memoryResUserActionsHandler);
        this.status = targetAppRunner.getProfilerClient().getStatus();
        this.runner = targetAppRunner;
        this.historyActionsHandler = classHistoryActionsHandler;
        this.classHistoryManager = classHistoryDataManager;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "memory-allocations-live";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupShowStacks) {
            this.actionsHandler.showStacksForClass(this.selectedClassId, this.getSortingColumn(), this.getSortingOrder());
        } else if (actionEvent.getSource() == this.popupShowSource && this.popupShowSource != null) {
            this.showSourceForClass(this.selectedClassId);
        } else if (actionEvent.getSource() == this.startHisto) {
            String string = StringUtils.userFormClassName((String)this.getClassName(this.selectedClassId));
            this.historyActionsHandler.showClassHistory(this.selectedClassId, string);
        }
    }

    public void fetchResultsFromTargetApp() throws ClientUtils.TargetAppOrVMTerminated {
        MemoryCCTProvider memoryCCTProvider = this.runner.getProfilerClient().getMemoryCCTProvider();
        if (memoryCCTProvider == null) {
            throw new ClientUtils.TargetAppOrVMTerminated(1);
        }
        this.totalAllocObjectsSize = memoryCCTProvider.getAllocObjectNumbers();
        this.nTotalAllocObjects = this.runner.getProfilerClient().getAllocatedObjectsCountResults();
        this.nTrackedItems = this.status.getNInstrClasses();
        if (this.nTrackedItems > this.nTotalAllocObjects.length) {
            this.nTrackedItems = this.nTotalAllocObjects.length;
        }
        if (this.nTrackedItems > this.totalAllocObjectsSize.length) {
            this.nTrackedItems = this.totalAllocObjectsSize.length;
        }
        this.maxValue = 0L;
        this.nTotalBytes = 0L;
        this.nTotalClasses = 0L;
        for (int i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.totalAllocObjectsSize[i]) {
                this.maxValue = this.totalAllocObjectsSize[i];
            }
            this.nTotalBytes += this.totalAllocObjectsSize[i];
            this.nTotalClasses += (long)this.nTotalAllocObjects[i];
        }
        if (this.classHistoryManager.isTrackingClass()) {
            this.classHistoryManager.processData(this.nTotalAllocObjects, this.totalAllocObjectsSize);
        }
        this.initDataUponResultsFetch();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = false;
            this.memoryResPopupMenu.setVisible(false);
        }
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public boolean supports(int n) {
        return n == 5;
    }

    @Override
    public void updateLiveResults() {
        if (this.memoryResPopupMenu != null && this.memoryResPopupMenu.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        try {
            if (this.runner.getProfilingSessionStatus().targetAppRunning) {
                this.reset();
                this.fetchResultsFromTargetApp();
            }
            this.prepareResults();
            if (string != null) {
                this.resTable.selectRowByContents(string, 0, false);
            }
            if (this.resTable != null && this.resTable.isFocusOwner()) {
                this.resTable.requestFocusInWindow();
            }
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            ProfilerDialogs.displayWarning((String)targetAppOrVMTerminated.getMessage());
            ProfilerLogger.log((String)targetAppOrVMTerminated.getMessage());
        }
        this.updateResultsInProgress = false;
    }

    @Override
    protected String getClassName(int n) {
        return this.status.getClassNames()[n];
    }

    @Override
    protected String[] getClassNames() {
        return this.status.getClassNames();
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
            if (GoToSource.isAvailable()) {
                Font font = this.memoryResPopupMenu.getFont().deriveFont(1);
                this.popupShowSource = new JMenuItem();
                this.popupShowSource.setFont(font);
                this.popupShowSource.setText(GO_SOURCE_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowSource);
                this.popupShowSource.addActionListener(this);
                this.memoryResPopupMenu.addSeparator();
            }
            if (this.runner.getProfilerEngineSettings().getAllocStackTraceLimit() != 0) {
                this.popupShowStacks = new JMenuItem();
                this.popupShowStacks.setText(SHOW_STACK_TRACES_POPUP_ITEM_NAME);
                this.memoryResPopupMenu.add(this.popupShowStacks);
                this.popupShowStacks.addActionListener(this);
                this.memoryResPopupMenu.addSeparator();
            }
            this.startHisto = new JMenuItem();
            this.startHisto.setText(LOG_CLASS_HISTORY);
            this.memoryResPopupMenu.add(this.startHisto);
            this.startHisto.addActionListener(this);
            this.memoryResPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (LiveAllocResultsPanel.this.updateResultsPending) {
                                LiveAllocResultsPanel.this.updateLiveResults();
                                LiveAllocResultsPanel.this.updateResultsPending = false;
                            }
                        }
                    });
                }
            });
        }
        boolean bl = this.status.targetAppRunning;
        if (this.popupShowStacks != null) {
            this.popupShowStacks.setEnabled(bl);
        }
        this.startHisto.setEnabled(bl);
        return this.memoryResPopupMenu;
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
        this.percentFormat.setMinimumFractionDigits(0);
        this.percentFormat.setMaximumFractionDigits(1);
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append("<th>").append(this.columnNames[n]).append("</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.sortedClassNames[n]) + "</td>");
            stringBuffer.append("<td align=\"right\">").append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append("</td>");
            stringBuffer.append("<td align=\"right\">").append(this.totalAllocObjectsSize[n]).append(" B</td>");
            stringBuffer.append("<td align=\"right\">").append(this.nTotalAllocObjects[n]).append("</td></tr>");
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\">" + string2);
        stringBuffer.append("<TableData NumRows=\"").append(this.nTrackedItems).append("\" NumColumns=\"4\">").append(string2).append("<TableHeader>");
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append("  <TableColumn><![CDATA[").append(this.columnNames[n]).append("]]></TableColumn>").append(string2);
        }
        stringBuffer.append("</TableHeader>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer("  <TableRow>" + string2 + "   <TableColumn><![CDATA[" + this.sortedClassNames[n] + "]]></TableColumn>" + string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append("]]></TableColumn>").append(string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.totalAllocObjectsSize[n]).append("]]></TableColumn>").append(string2);
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.nTotalAllocObjects[n]).append("]]></TableColumn>").append(string2).append("  </TableRow>").append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        for (n = 0; n < this.columnNames.length; ++n) {
            stringBuffer.append(string3).append(this.columnNames[n]).append(string3).append(string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.nTrackedItems; ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3).append(this.sortedClassNames[n]).append(string3).append(string);
            stringBuffer.append(string3).append(this.percentFormat.format((double)this.totalAllocObjectsSize[n] / (double)this.nTotalBytes)).append(string3).append(string);
            stringBuffer.append(string3).append(this.totalAllocObjectsSize[n]).append(string3).append(string);
            stringBuffer.append(string3).append(this.nTotalAllocObjects[n]).append(string3).append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

