/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Bundle;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsProvider;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

public final class AwtDetailsProvider
extends DetailsProvider.Basic {
    private static final String FONT_MASK = "java.awt.Font+";
    private static final String COLOR_MASK = "java.awt.Color+";
    private static final String POINT_MASK = "java.awt.Point+";
    private static final String DIMENSION_MASK = "java.awt.Dimension+";
    private static final String RECTANGLE_MASK = "java.awt.Rectangle+";
    private static final String INSETS_MASK = "java.awt.Insets+";
    private static final String TEXTATTRIBUTE_MASK = "java.text.AttributedCharacterIterator$Attribute+";
    private static final String CURSOR_MASK = "java.awt.Cursor+";

    public AwtDetailsProvider() {
        super(FONT_MASK, COLOR_MASK, POINT_MASK, DIMENSION_MASK, RECTANGLE_MASK, INSETS_MASK, TEXTATTRIBUTE_MASK, CURSOR_MASK);
    }

    @Override
    public String getDetailsString(String string, Instance instance, Heap heap) {
        if (FONT_MASK.equals(string)) {
            String string2 = Utils.getFontName(instance, heap);
            if (string2 == null) {
                string2 = "Default";
            }
            int n = DetailsUtils.getIntFieldValue(instance, "size", 10);
            string2 = string2 + ", " + n + "pt";
            int n2 = DetailsUtils.getIntFieldValue(instance, "style", 0);
            if ((n2 & 1) != 0) {
                string2 = string2 + ", bold";
            }
            if ((n2 & 2) != 0) {
                string2 = string2 + ", italic";
            }
            return string2;
        }
        if (COLOR_MASK.equals(string)) {
            Color color = (Color)new BaseBuilders.ColorBuilder(instance, heap).createInstance();
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ", " + color.getAlpha();
        }
        if (POINT_MASK.equals(string)) {
            Point point = (Point)new BaseBuilders.PointBuilder(instance, heap).createInstance();
            return point.x + ", " + point.y;
        }
        if (DIMENSION_MASK.equals(string)) {
            Dimension dimension = (Dimension)new BaseBuilders.DimensionBuilder(instance, heap).createInstance();
            return dimension.width + ", " + dimension.height;
        }
        if (RECTANGLE_MASK.equals(string)) {
            Rectangle rectangle = (Rectangle)new BaseBuilders.RectangleBuilder(instance, heap).createInstance();
            return rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
        }
        if (INSETS_MASK.equals(string)) {
            Insets insets = (Insets)new BaseBuilders.InsetsBuilder(instance, heap).createInstance();
            return insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
        }
        if (TEXTATTRIBUTE_MASK.equals(string) || CURSOR_MASK.equals(string)) {
            return DetailsUtils.getInstanceFieldString(instance, "name", heap);
        }
        return null;
    }

    @Override
    public DetailsProvider.View getDetailsView(String string, Instance instance, Heap heap) {
        if (FONT_MASK.equals(string)) {
            return new FontView(instance, heap);
        }
        if (COLOR_MASK.equals(string)) {
            return new ColorView(instance, heap);
        }
        return null;
    }

    private static class ColorView
    extends Utils.View<BaseBuilders.ColorBuilder> {
        ColorView(Instance instance, Heap heap) {
            super(0, true, true, instance, heap);
        }

        @Override
        protected BaseBuilders.ColorBuilder getBuilder(Instance instance, Heap heap) {
            return new BaseBuilders.ColorBuilder(instance, heap);
        }

        @Override
        protected Component getComponent(BaseBuilders.ColorBuilder colorBuilder) {
            final Color color = (Color)colorBuilder.createInstance();
            JPanel jPanel = new JPanel(null){

                @Override
                public void paint(Graphics graphics) {
                    graphics.setColor(color);
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            };
            jPanel.setOpaque(false);
            return jPanel;
        }
    }

    private static class FontView
    extends Utils.View<BaseBuilders.FontBuilder> {
        FontView(Instance instance, Heap heap) {
            super(0, false, true, instance, heap);
        }

        @Override
        protected BaseBuilders.FontBuilder getBuilder(Instance instance, Heap heap) {
            return new BaseBuilders.FontBuilder(instance, heap);
        }

        @Override
        protected Component getComponent(BaseBuilders.FontBuilder fontBuilder) {
            JLabel jLabel = new JLabel();
            jLabel.setHorizontalAlignment(0);
            jLabel.setFont((Font)fontBuilder.createInstance());
            jLabel.setText(Bundle.FontView_Preview());
            return jLabel;
        }
    }
}

