/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.jdk.ui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BaseBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.BorderBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.ComponentBuilders;
import org.netbeans.modules.profiler.heapwalk.details.jdk.ui.Utils;
import org.netbeans.modules.profiler.heapwalk.details.spi.DetailsUtils;

final class PaneBuilders {
    PaneBuilders() {
    }

    static ComponentBuilders.ComponentBuilder getBuilder(Instance instance, Heap heap) {
        if (DetailsUtils.isSubclassOf(instance, JViewport.class.getName())) {
            return new JViewportBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JScrollPane.class.getName())) {
            return new JScrollPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JSplitPane.class.getName())) {
            return new JSplitPaneBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, BasicSplitPaneDivider.class.getName())) {
            return new BasicSplitPaneDividerBuilder(instance, heap);
        }
        if (DetailsUtils.isSubclassOf(instance, JTabbedPane.class.getName())) {
            return new JTabbedPaneBuilder(instance, heap);
        }
        return null;
    }

    private static class JTabbedPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JTabbedPane> {
        private final int tabPlacement;
        private final int tabLayoutPolicy;
        private final PageImplBuilder pages;
        private final long visCompId;
        private final Utils.InstanceBuilder<Component> visComp;
        private int selComp = -1;

        JTabbedPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.tabPlacement = DetailsUtils.getIntFieldValue(instance, "tabPlacement", 1);
            this.tabLayoutPolicy = DetailsUtils.getIntFieldValue(instance, "tabLayoutPolicy", 0);
            this.pages = PageImplBuilder.fromField(instance, "pages", heap);
            Object object = instance.getValueOfField("visComp");
            if (object instanceof Instance) {
                Instance instance2 = (Instance)object;
                this.visCompId = instance2.getInstanceId();
                this.visComp = ComponentBuilders.getBuilder(instance2, heap);
            } else {
                this.visCompId = Long.MIN_VALUE;
                this.visComp = null;
            }
        }

        @Override
        protected void setupInstance(JTabbedPane jTabbedPane) {
            super.setupInstance(jTabbedPane);
            if (this.pages != null) {
                List list = (List)this.pages.createInstance();
                for (PageImpl pageImpl : list) {
                    Color color;
                    int n = jTabbedPane.getTabCount();
                    Component component = null;
                    if (this.selComp == -1 && this.visComp != null && this.visCompId == pageImpl.component) {
                        component = this.visComp.createInstance();
                        this.selComp = n;
                    }
                    jTabbedPane.addTab(pageImpl.title, pageImpl.icon == null ? null : (Icon)pageImpl.icon.createInstance(), component);
                    if (pageImpl.background != null && (color = (Color)pageImpl.background.createInstance()) != null) {
                        jTabbedPane.setBackgroundAt(n, color);
                    }
                    if (pageImpl.foreground != null && (color = (Color)pageImpl.foreground.createInstance()) != null) {
                        jTabbedPane.setForegroundAt(n, color);
                    }
                    jTabbedPane.setEnabledAt(n, pageImpl.enabled);
                }
            }
            if (this.selComp != -1) {
                jTabbedPane.setSelectedIndex(this.selComp);
                this.selComp = -1;
            }
        }

        @Override
        protected JTabbedPane createInstanceImpl() {
            return new JTabbedPane(this.tabPlacement, this.tabLayoutPolicy){};
        }
    }

    private static class PageImplBuilder
    extends Utils.InstanceBuilder<List<PageImpl>> {
        private final List<PageImpl> pages = new ArrayList<PageImpl>(1);

        PageImplBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            Object object = instance.getValueOfField("elementData");
            if (object instanceof ObjectArrayInstance) {
                int n = DetailsUtils.getIntFieldValue(instance, "size", Integer.MIN_VALUE);
                if (n == Integer.MIN_VALUE) {
                    n = DetailsUtils.getIntFieldValue(instance, "elementCount", 0);
                }
                if (n > 0) {
                    ObjectArrayInstance objectArrayInstance = (ObjectArrayInstance)object;
                    for (Object e : objectArrayInstance.getValues()) {
                        if (!(e instanceof Instance)) continue;
                        Instance instance2 = (Instance)e;
                        Object object2 = instance2.getValueOfField("component");
                        this.pages.add(new PageImpl(Utils.getFieldString(instance2, "title"), BaseBuilders.ColorBuilder.fromField(instance2, "background", heap), BaseBuilders.ColorBuilder.fromField(instance2, "foreground", heap), BaseBuilders.IconBuilder.fromField(instance2, "icon", heap), object2 instanceof Instance ? ((Instance)object2).getInstanceId() : -1L, DetailsUtils.getBooleanFieldValue(instance2, "enabled", true)));
                    }
                }
            }
        }

        static PageImplBuilder fromField(Instance instance, String string, Heap heap) {
            Object object = instance.getValueOfField(string);
            if (!(object instanceof Instance)) {
                return null;
            }
            return new PageImplBuilder((Instance)object, heap);
        }

        @Override
        protected List<PageImpl> createInstanceImpl() {
            return this.pages;
        }
    }

    private static class PageImpl {
        final String title;
        final BaseBuilders.ColorBuilder background;
        final BaseBuilders.ColorBuilder foreground;
        final BaseBuilders.IconBuilder icon;
        final long component;
        final boolean enabled;

        PageImpl(String string, BaseBuilders.ColorBuilder colorBuilder, BaseBuilders.ColorBuilder colorBuilder2, BaseBuilders.IconBuilder iconBuilder, long l, boolean bl) {
            this.title = string;
            this.background = colorBuilder;
            this.foreground = colorBuilder2;
            this.icon = iconBuilder;
            this.component = l;
            this.enabled = bl;
        }
    }

    private static class BasicSplitPaneDividerBuilder
    extends ComponentBuilders.ContainerBuilder<BasicSplitPaneDivider> {
        private final int orientation;
        private final BorderBuilders.BorderBuilder border;

        BasicSplitPaneDividerBuilder(Instance instance, Heap heap) {
            super(instance, heap, false);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
            this.border = BorderBuilders.fromField(instance, "border", false, heap);
        }

        @Override
        protected void setupInstance(BasicSplitPaneDivider basicSplitPaneDivider) {
            Border border;
            super.setupInstance(basicSplitPaneDivider);
            if (this.border != null && (border = (Border)this.border.createInstance()) != null) {
                basicSplitPaneDivider.setBorder(border);
            }
        }

        @Override
        protected BasicSplitPaneDivider createInstanceImpl() {
            final JSplitPane jSplitPane = new JSplitPane(this.orientation);
            BasicSplitPaneUI basicSplitPaneUI = jSplitPane.getUI() instanceof BasicSplitPaneUI ? (BasicSplitPaneUI)jSplitPane.getUI() : new BasicSplitPaneUI(){
                {
                    this.installUI(jSplitPane);
                }
            };
            return new BasicSplitPaneDivider(basicSplitPaneUI);
        }
    }

    private static class JSplitPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JSplitPane> {
        private final int orientation;

        JSplitPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.orientation = DetailsUtils.getIntFieldValue(instance, "orientation", 1);
        }

        @Override
        protected JSplitPane createInstanceImpl() {
            return new JSplitPane(this.orientation);
        }
    }

    private static class JScrollPaneBuilder
    extends ComponentBuilders.JComponentBuilder<JScrollPane> {
        private final BorderBuilders.BorderBuilder viewportBorder;

        JScrollPaneBuilder(Instance instance, Heap heap) {
            super(instance, heap);
            this.viewportBorder = BorderBuilders.fromField(instance, "viewportBorder", false, heap);
        }

        @Override
        protected void setupInstance(JScrollPane jScrollPane) {
            Border border;
            super.setupInstance(jScrollPane);
            if (this.viewportBorder != null && (border = (Border)this.viewportBorder.createInstance()) != null) {
                jScrollPane.setViewportBorder(border);
            }
        }

        @Override
        protected JScrollPane createInstanceImpl() {
            return new JScrollPane();
        }
    }

    private static class JViewportBuilder
    extends ComponentBuilders.JComponentBuilder<JViewport> {
        JViewportBuilder(Instance instance, Heap heap) {
            super(instance, heap);
        }

        @Override
        protected JViewport createInstanceImpl() {
            return new JViewport();
        }
    }
}

