/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.DuplicateException;
import org.netbeans.Events;
import org.netbeans.JaveleonModule;
import org.netbeans.Module;
import org.netbeans.ModuleInstaller;
import org.netbeans.ModuleManager;
import org.netbeans.Stamps;
import org.netbeans.core.startup.JaveleonModuleReloader;
import org.netbeans.core.startup.MainLookup;
import org.netbeans.core.startup.ModuleHistory;
import org.netbeans.core.startup.ModuleLifecycleManager;
import org.netbeans.core.startup.ModuleList;
import org.netbeans.core.startup.NbEvents;
import org.netbeans.core.startup.NbInstaller;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public final class ModuleSystem {
    private static final Logger LOG = Logger.getLogger(ModuleSystem.class.getName());
    private final ModuleManager mgr;
    private final NbInstaller installer;
    private ModuleList list;
    private final Events ev = Boolean.getBoolean("netbeans.modules.quiet") ? new QuietEvents() : new NbEvents();
    private Set<Module> bootModules = null;

    public ModuleSystem(FileSystem fileSystem) throws IOException {
        this();
        this.init(fileSystem);
    }

    ModuleSystem() {
        this.installer = new NbInstaller(this.ev);
        this.mgr = new ModuleManager((ModuleInstaller)this.installer, this.ev);
    }

    final void init(FileSystem fileSystem) throws IOException {
        if (Boolean.getBoolean("org.netbeans.core.startup.ModuleSystem.CULPRIT")) {
            Thread.dumpStack();
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("classLoader".equals(propertyChangeEvent.getPropertyName())) {
                    MainLookup.systemClassLoaderChanged(ModuleSystem.this.mgr.getClassLoader());
                }
            }
        };
        this.mgr.addPropertyChangeListener(propertyChangeListener);
        MainLookup.systemClassLoaderChanged(((Object)((Object)this.installer)).getClass().getClassLoader());
        MainLookup.moduleLookupReady(this.mgr.getModuleLookup());
        if (fileSystem.isReadOnly()) {
            this.list = null;
        } else {
            FileObject fileObject = fileSystem.getRoot();
            FileObject fileObject2 = fileObject.getFileObject("Modules");
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder("Modules");
            }
            this.list = new ModuleList(this.mgr, fileObject2, this.ev);
            this.installer.registerList(this.list);
            this.installer.registerManager(this.mgr);
        }
        this.ev.log("createdModuleSystem", new Object[0]);
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    public Events getEvents() {
        return this.ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getModuleJars() {
        this.mgr.mutexPrivileged().enterReadAccess();
        try {
            ArrayList arrayList = new ArrayList();
            for (Module module : this.mgr.getEnabledModules()) {
                arrayList.addAll(module.getAllJars());
            }
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.mgr.mutexPrivileged().exitReadAccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBootModules() {
        Object object;
        HashSet<File> hashSet = new HashSet<File>();
        String string = System.getProperty("java.home");
        if (string != null) {
            object = new File(new File(string).getParentFile(), "lib");
            hashSet.add(new File((File)object, "tools.jar"));
            hashSet.add(new File((File)object, "dt.jar"));
        }
        for (String object2 : System.getProperty("sun.boot.class.path", "").split(File.pathSeparator)) {
            hashSet.add(new File(object2));
        }
        LOG.log(Level.FINE, "Ignored JARs: {0}", hashSet);
        this.mgr.mutexPrivileged().enterWriteAccess();
        this.ev.log("startLoadBootModules", new Object[0]);
        try {
            this.bootModules = new HashSet<Module>(10);
            object = ModuleSystem.class.getClassLoader();
            Enumeration<URL> enumeration = ((ClassLoader)object).getResources("META-INF/MANIFEST.MF");
            this.ev.log("perfTick", new Object[]{"got all manifests"});
            HashSet<URL> hashSet2 = new HashSet<URL>();
            while (enumeration.hasMoreElements()) {
                InputStream inputStream;
                URL uRL = enumeration.nextElement();
                if (!hashSet2.add(uRL)) continue;
                URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
                if (uRL2 != null && uRL2.getProtocol().equals("file") && uRL2.getPath().startsWith("/")) {
                    LOG.log(Level.FINE, "Considering JAR: {0}", uRL2);
                    try {
                        if (hashSet.contains(Utilities.toFile((URI)uRL2.toURI()))) {
                            LOG.log(Level.FINE, "ignoring JDK/JRE manifest: {0}", uRL);
                            continue;
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Exceptions.printStackTrace((Throwable)uRISyntaxException);
                    }
                }
                LOG.log(Level.FINE, "Checking boot manifest: {0}", uRL);
                try {
                    inputStream = uRL.openStream();
                }
                catch (IOException iOException) {
                    Exceptions.attachMessage((Throwable)iOException, (String)("URL: " + uRL));
                    throw iOException;
                }
                try {
                    Manifest manifest = new Manifest(inputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes.getValue("OpenIDE-Module") == null) continue;
                    this.bootModules.add(this.mgr.createFixed(manifest, (Object)uRL, (ClassLoader)object));
                }
                finally {
                    inputStream.close();
                }
            }
            if (this.list == null) {
                this.mgr.enable(this.bootModules);
            }
            this.ev.log("perfTick", new Object[]{"added all classpath modules"});
        }
        catch (IOException iOException) {
            LOG.log(Level.WARNING, null, iOException);
        }
        catch (DuplicateException duplicateException) {
            LOG.log(Level.WARNING, null, duplicateException);
        }
        finally {
            this.ev.log("finishLoadBootModules", new Object[0]);
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
    }

    public final void refresh() {
        this.list.moduleListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readList() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.readList"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            this.list.readInitial();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.readList"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore() {
        this.ev.log("perfStart", new Object[]{"ModuleSystem.restore"});
        this.mgr.mutexPrivileged().enterWriteAccess();
        try {
            HashSet<Module> hashSet = new HashSet<Module>(this.bootModules);
            this.list.trigger(hashSet);
            this.mgr.releaseModuleManifests();
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        this.installer.preloadCache(this.mgr.getModules());
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.restore"});
        this.ev.log("perfStart", new Object[]{"ModuleSystem.waitOnStart"});
        this.installer.waitOnStart();
        this.ev.log("perfEnd", new Object[]{"ModuleSystem.waitOnStart"});
    }

    public boolean shutDown(Runnable runnable) {
        try {
            return this.shutDownAsync(runnable).get();
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            Exceptions.printStackTrace((Throwable)executionException);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> shutDownAsync(final Runnable runnable) {
        Future future;
        this.mgr.mutexPrivileged().enterWriteAccess();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                runnable.run();
                Stamps.getModulesJARs().shutdown();
            }
        };
        try {
            future = this.mgr.shutDownAsync(runnable2);
        }
        finally {
            this.mgr.mutexPrivileged().exitWriteAccess();
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void deployTestModule(File var1_1) throws IOException {
        block18: {
            if (!var1_1.isAbsolute()) {
                throw new IOException("Absolute paths only please");
            }
            if (JaveleonModule.isJaveleonPresent && JaveleonModuleReloader.getDefault().reloadJaveleonModule(var1_1, this.mgr, this.installer, this.ev)) {
                return;
            }
            this.mgr.mutexPrivileged().enterWriteAccess();
            this.ev.log("startDeployTestModule", new Object[]{var1_1});
            System.err.println("Deploying test module " + var1_1 + "...");
            try {
                var2_2 = null;
                var3_3 = new HashSet<Module>();
                for (Module var5_7 : this.mgr.getModules()) {
                    if (var5_7.getJarFile() == null || !var1_1.equals(var5_7.getJarFile())) continue;
                    if (var5_7.isAutoload() || var5_7.isEager()) {
                        System.err.println("Reloading autoload and eager modules is not supported, sorry! (Try Javeleon.)");
                        break block18;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl31
            }
            catch (Throwable var7_9) {
                this.ev.log("finishDeployTestModule", new Object[]{var1_1});
                this.mgr.mutexPrivileged().exitWriteAccess();
                throw var7_9;
            }
        }
        this.ev.log("finishDeployTestModule", new Object[]{var1_1});
        this.mgr.mutexPrivileged().exitWriteAccess();
        return;
lbl-1000:
        // 1 sources

        {
            if (!var5_7.isReloadable()) {
                var5_7.setReloadable(true);
            }
            this.turnOffModule(var5_7, var3_3);
            this.mgr.reload(var5_7);
            var2_2 = var5_7;
lbl31:
            // 2 sources

            if (var2_2 == null) {
                try {
                    var2_2 = this.mgr.create(var1_1, (Object)new ModuleHistory(var1_1.getAbsolutePath()), true, false, false);
                }
                catch (DuplicateException var4_5) {
                    var5_7 = var4_5.getOldModule();
                    System.err.println("Replacing old module in " + var5_7);
                    this.turnOffModule(var5_7, var3_3);
                    this.mgr.delete(var5_7);
                    try {
                        var2_2 = this.mgr.create(var1_1, (Object)new ModuleHistory(var1_1.getAbsolutePath()), true, false, false);
                    }
                    catch (DuplicateException var6_8) {
                        throw (IOException)new IOException(var6_8.toString()).initCause(var6_8);
                    }
                }
            }
            System.err.println("Enabling " + var2_2 + "...");
            if (!this.mgr.simulateEnable(Collections.singleton(var2_2)).contains(var2_2)) {
                throw new IOException("Cannot enable " + var2_2 + "; problems: " + var2_2.getProblems());
            }
            this.mgr.enable(var2_2);
            if (!var3_3.isEmpty()) {
                System.err.println("Also re-enabling:");
                for (Module var5_7 : var3_3) {
                    System.err.println("\t" + var5_7.getDisplayName());
                    if (!var5_7.isReloadable()) continue;
                    var5_7.reload();
                }
                try {
                    this.mgr.enable(var3_3);
                }
                catch (IllegalArgumentException var4_6) {
                    throw new IOException(var4_6.toString());
                }
            }
            System.err.println("Done.");
        }
        this.ev.log("finishDeployTestModule", new Object[]{var1_1});
        this.mgr.mutexPrivileged().exitWriteAccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnOffModule(Module module, Set<Module> set) {
        if (!module.isEnabled()) {
            return;
        }
        for (Module module2 : this.mgr.simulateDisable(Collections.singleton(module))) {
            if (module2.isAutoload() || module2.isEager()) continue;
            set.add(module2);
        }
        try {
            System.err.println("Disabling " + module + "...");
            this.mgr.disable(set);
        }
        finally {
            set.remove(module);
        }
    }

    public String getEffectiveClasspath(Module module) {
        return this.installer.getEffectiveClasspath(module);
    }

    public boolean isShowInAutoUpdateClient(ModuleInfo moduleInfo) {
        return this.installer.isShowInAutoUpdateClient(moduleInfo);
    }

    public static void markForRestart() throws UnsupportedOperationException {
        ModuleLifecycleManager.markReadyForRestart();
    }

    private static final class QuietEvents
    extends Events {
        QuietEvents() {
        }

        protected void logged(String string, Object[] objectArray) {
        }
    }
}

