/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.source.Content;
import com.oracle.truffle.api.source.SourceAccessor;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.spi.FileTypeDetector;
import java.util.Collection;
import java.util.ServiceLoader;

final class FileSourceImpl
extends Content
implements Content.CreateURI {
    private final File file;
    private final String name;
    private final String path;

    FileSourceImpl(String content, File file, String name, String path) {
        this.code = content;
        this.file = file.getAbsoluteFile();
        this.name = name;
        this.path = path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.file.getName();
    }

    @Override
    Object getHashKey() {
        return this.path;
    }

    @Override
    String getCode() {
        return this.code;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    URI getURI() {
        return this.createURIOnce(this);
    }

    @Override
    public URI createURI() {
        return this.file.toURI();
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.code);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    String findMimeType() throws IOException {
        return FileSourceImpl.findMimeType(this.file.toPath());
    }

    static String findMimeType(Path filePath) throws IOException {
        String found;
        if (!TruffleOptions.AOT) {
            Collection<ClassLoader> loaders = SourceAccessor.allLoaders();
            for (ClassLoader l : loaders) {
                for (FileTypeDetector detector : ServiceLoader.load(FileTypeDetector.class, l)) {
                    String mimeType = detector.probeContentType(filePath);
                    if (mimeType == null) continue;
                    return mimeType;
                }
            }
        }
        return (found = Files.probeContentType(filePath)) == null ? "content/unknown" : found;
    }
}

