/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.transcode;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.Ptr;
import org.jcodings.specific.UTF32BEEncoding;
import org.jcodings.transcode.Buffer;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.Transcoder;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.transcode.Transcoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;

public class TranscodingManager {
    public static final Map<String, Map<String, Transcoder>> allTranscoders = new HashMap<String, Map<String, Transcoder>>();
    private static final MethodHandle convertInternalMethodHandle;

    public static EConv create(Encoding sourceEncoding, Encoding destinationEncoding, int options) {
        EConv ec = TranscodingManager.open(sourceEncoding.getName(), destinationEncoding.getName(), TranscodingManager.rubiniusToJRubyFlags(options));
        if (ec == null) {
            return null;
        }
        ec.sourceEncoding = sourceEncoding;
        ec.destinationEncoding = destinationEncoding;
        return ec;
    }

    private static EConv create(byte[] sourceEncodingName, byte[] destinationEncodingName, int options) {
        EConv ec = TranscodingManager.open(sourceEncodingName, destinationEncodingName, TranscodingManager.rubiniusToJRubyFlags(options));
        if (ec == null) {
            return null;
        }
        return ec;
    }

    private static int rubiniusToJRubyFlags(int flags) {
        if ((flags & 0x4000) != 0) {
            flags |= 0x30;
        }
        if ((flags & 0x8000) != 0) {
            flags |= 0x30;
        }
        return flags;
    }

    @CompilerDirectives.TruffleBoundary
    private static EConv open(byte[] sourceEncodingName, byte[] destinationEncodingName, int ecflags) {
        byte[][] decorators = new byte[32][];
        int numDecorators = TranscoderDB.decoratorNames(ecflags, decorators);
        if (numDecorators == -1) {
            return null;
        }
        EConv ec = TranscodingManager.open0(sourceEncodingName, destinationEncodingName, ecflags & 0xFF);
        if (ec == null) {
            return null;
        }
        for (int i = 0; i < numDecorators; ++i) {
            if (TranscodingManager.decorateAtLast(ec, decorators[i])) continue;
            ec.close();
            return null;
        }
        ec.flags |= ecflags & 0xFFFFFF00;
        return ec;
    }

    @CompilerDirectives.TruffleBoundary
    private static EConv open0(byte[] sourceEncodingName, byte[] destinationEncodingName, int ecflags) {
        List<Transcoder> transcoders = TranscodingManager.searchPath(sourceEncodingName, destinationEncodingName);
        if (transcoders.isEmpty()) {
            return null;
        }
        EConv ec = TranscoderDB.alloc(transcoders.size());
        for (Transcoder transcoder : transcoders) {
            ec.addTranscoderAt(transcoder, ec.numTranscoders);
        }
        ec.flags = ecflags;
        ec.source = sourceEncodingName;
        ec.destination = destinationEncodingName;
        return ec;
    }

    @CompilerDirectives.TruffleBoundary
    private static List<Transcoder> searchPath(byte[] source, byte[] destination) {
        ArrayList<Transcoder> ret = new ArrayList<Transcoder>();
        String sourceEncodingName = new String(source).toUpperCase();
        String destinationEncodingName = new String(destination).toUpperCase();
        if (!allTranscoders.containsKey(sourceEncodingName)) {
            return null;
        }
        Transcoder directMapping = allTranscoders.get(sourceEncodingName).get(destinationEncodingName);
        if (directMapping != null) {
            return Collections.singletonList(directMapping);
        }
        LinkedList<String> path = TranscodingManager.bfs(sourceEncodingName, destinationEncodingName);
        if (!path.isEmpty()) {
            String sourceName = path.remove();
            for (String destinationName : path) {
                ret.add(allTranscoders.get(sourceName).get(destinationName));
                sourceName = destinationName;
            }
        }
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    private static LinkedList<String> bfs(String sourceEncodingName, String destinationEncodingName) {
        HashSet<String> alreadyVisited = new HashSet<String>();
        ArrayDeque<LinkedList> queue = new ArrayDeque<LinkedList>();
        LinkedList path = new LinkedList();
        path.add(sourceEncodingName);
        queue.add(path);
        alreadyVisited.add(sourceEncodingName);
        while (!queue.isEmpty()) {
            path = (LinkedList)queue.pop();
            String sourceName = (String)path.getLast();
            if (allTranscoders.get(sourceName).containsKey(destinationEncodingName)) {
                path.add(destinationEncodingName);
                return path;
            }
            for (String destinationName : allTranscoders.get(sourceName).keySet()) {
                if (alreadyVisited.contains(destinationName)) continue;
                LinkedList newPath = (LinkedList)path.clone();
                newPath.add(destinationName);
                queue.add(newPath);
                alreadyVisited.add(destinationName);
            }
        }
        return null;
    }

    private static boolean decorateAtLast(EConv ec, byte[] decorator) {
        if (ec.numTranscoders == 0) {
            return TranscodingManager.decorateAt(ec, decorator, 0);
        }
        Transcoder transcoder = ec.elements[ec.numTranscoders - 1].transcoding.transcoder;
        if (!EConv.decorator(transcoder.source, transcoder.destination) && transcoder.compatibility.isEncoder()) {
            return TranscodingManager.decorateAt(ec, decorator, ec.numTranscoders - 1);
        }
        return TranscodingManager.decorateAt(ec, decorator, ec.numTranscoders);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean decorateAt(EConv ec, byte[] decorator, int n) {
        if (ec.started) {
            return false;
        }
        if (!allTranscoders.containsKey("")) {
            return false;
        }
        Transcoder transcoder = allTranscoders.get("").get(new String(decorator).toUpperCase());
        if (transcoder == null) {
            return false;
        }
        ec.addTranscoderAt(transcoder, n);
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static EConvResult convert(EConv ec, byte[] in, Ptr inPtr, int inStop, byte[] out, Ptr outPtr, int outStop, int flags) {
        EConvResult ret;
        ec.started = true;
        if (in == null || inPtr == null) {
            in = EConv.NULL_STRING;
            inPtr = Ptr.NULL;
            inStop = 0;
        }
        if (out == null || outPtr == null) {
            out = EConv.NULL_STRING;
            outPtr = Ptr.NULL;
            outStop = 0;
        }
        block9: while (true) {
            ret = null;
            try {
                ret = convertInternalMethodHandle.invoke(ec, in, inPtr, inStop, out, outPtr, outStop, flags);
            }
            catch (Throwable t) {
                throw new UnsupportedOperationException(t);
            }
            if (ret.isInvalidByteSequence() || ret.isIncompleteInput()) {
                switch (ec.flags & 0xF) {
                    case 2: {
                        if (TranscodingManager.outputReplacementCharacter(ec) != 0) break;
                        continue block9;
                    }
                }
            }
            if (!ret.isUndefinedConversion()) break;
            switch (ec.flags & 0xF0) {
                case 32: {
                    if (TranscodingManager.outputReplacementCharacter(ec) != 0) break block9;
                    continue block9;
                }
                case 48: {
                    if (TranscodingManager.outputHexCharref(ec) != 0) break block9;
                    continue block9;
                }
            }
            break;
        }
        return ret;
    }

    @CompilerDirectives.TruffleBoundary
    private static int outputReplacementCharacter(EConv ec) {
        if (ec.makeReplacement() == -1) {
            return -1;
        }
        if (TranscodingManager.insertOutput(ec, ec.replacementString, 0, ec.replacementLength, ec.replacementEncoding) == -1) {
            return -1;
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    private static int outputHexCharref(EConv ec) {
        int utfLen;
        int utfP;
        byte[] utfBytes;
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(ec.lastError.source, "UTF-32BE".getBytes())) {
            utfBytes = ec.lastError.errorBytes;
            utfP = ec.lastError.errorBytesP;
            utfLen = ec.lastError.errorBytesLength;
        } else {
            Ptr utfLenA = new Ptr();
            byte[] utfBuf = new byte[ec.lastError.errorBytesLength * UTF32BEEncoding.INSTANCE.maxLength()];
            utfBytes = TranscodingManager.allocateConvertedString(ec.lastError.source, "UTF-32BE".getBytes(), ec.lastError.errorBytes, ec.lastError.errorBytesP, ec.lastError.errorBytesLength, utfBuf, utfLenA);
            if (utfBytes == null) {
                return -1;
            }
            utfP = 0;
            utfLen = utfLenA.p;
        }
        if (utfLen % 4 != 0) {
            return -1;
        }
        int p = utfP;
        while (4 <= utfLen) {
            int u = 0;
            u += (utfBytes[p] & 0xFF) << 24;
            u += (utfBytes[p + 1] & 0xFF) << 16;
            u += (utfBytes[p + 2] & 0xFF) << 8;
            byte[] charrefbuf = String.format("&#x%X;", u += utfBytes[p + 3] & 0xFF).getBytes();
            if (TranscodingManager.insertOutput(ec, charrefbuf, 0, charrefbuf.length, "US-ASCII".getBytes()) == -1) {
                return -1;
            }
            p += 4;
            utfLen -= 4;
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] allocateConvertedString(byte[] source, byte[] destination, byte[] str, int strP, int strLen, byte[] callerDstBuf, Ptr dstLenPtr) {
        int dstBufSize = callerDstBuf != null ? callerDstBuf.length : (strLen == 0 ? 1 : strLen);
        EConv ec = TranscodingManager.create(source, destination, 0);
        if (ec == null) {
            return null;
        }
        byte[] dstStr = callerDstBuf != null ? callerDstBuf : new byte[dstBufSize];
        int dstLen = 0;
        Ptr sp = new Ptr(strP);
        Ptr dp = new Ptr(dstLen);
        EConvResult res = TranscodingManager.convert(ec, str, sp, strP + strLen, dstStr, dp, dstBufSize, 0);
        dstLen = dp.p;
        while (res.isDestinationBufferFull()) {
            byte[] tmp = new byte[dstBufSize *= 2];
            System.arraycopy(dstStr, 0, tmp, 0, dstBufSize / 2);
            dstStr = tmp;
            dp.p = dstLen;
            res = TranscodingManager.convert(ec, str, sp, strP + strLen, dstStr, dp, dstBufSize, 0);
            dstLen = dp.p;
        }
        if (!res.isFinished()) {
            return null;
        }
        ec.close();
        dstLenPtr.p = dstLen;
        return dstStr;
    }

    @CompilerDirectives.TruffleBoundary
    private static int insertOutput(EConv ec, byte[] str, int strP, int strLen, byte[] strEncoding) {
        Buffer buf;
        Transcoding transcoding;
        int insertLen;
        int insertP;
        byte[] insertStr;
        byte[] insertEncoding = ec.encodingToInsertOutput();
        byte[] insertBuf = null;
        ec.started = true;
        if (strLen == 0) {
            return 0;
        }
        if (CaseInsensitiveBytesHash.caseInsensitiveEquals(insertEncoding, strEncoding)) {
            insertStr = str;
            insertP = 0;
            insertLen = strLen;
        } else {
            Ptr insertLenP = new Ptr();
            insertBuf = new byte[4096];
            insertStr = TranscodingManager.allocateConvertedString(strEncoding, insertEncoding, str, strP, strLen, insertBuf, insertLenP);
            insertLen = insertLenP.p;
            int n = insertP = insertStr == str ? strP : 0;
            if (insertStr == null) {
                return -1;
            }
        }
        int need = insertLen;
        int lastTranscodingIndex = ec.numTranscoders - 1;
        if (ec.numTranscoders == 0) {
            transcoding = null;
            buf = ec.inBuf;
        } else if (ec.elements[lastTranscodingIndex].transcoding.transcoder.compatibility.isEncoder()) {
            transcoding = ec.elements[lastTranscodingIndex].transcoding;
            if ((need += transcoding.readAgainLength) < insertLen) {
                return -1;
            }
            buf = lastTranscodingIndex == 0 ? ec.inBuf : ec.elements[lastTranscodingIndex - 1];
        } else {
            transcoding = ec.elements[lastTranscodingIndex].transcoding;
            buf = ec.elements[lastTranscodingIndex];
        }
        if (buf == null) {
            buf = new Buffer();
            buf.allocate(need);
        } else if (buf.bytes == null) {
            buf.allocate(need);
        } else if (buf.bufEnd - buf.dataEnd < need) {
            System.arraycopy(buf.bytes, buf.dataStart, buf.bytes, buf.bufStart, buf.dataEnd - buf.dataStart);
            buf.dataEnd = buf.bufStart + (buf.dataEnd - buf.dataStart);
            buf.dataStart = buf.bufStart;
            if (buf.bufEnd - buf.dataEnd < need) {
                int s = buf.dataEnd - buf.bufStart + need;
                if (s < need) {
                    return -1;
                }
                Buffer buf2 = buf = new Buffer();
                buf2.allocate(s);
                System.arraycopy(buf.bytes, buf.bufStart, buf2.bytes, 0, s);
                buf2.dataStart = 0;
                buf2.dataEnd = buf.dataEnd - buf.bufStart;
            }
        }
        System.arraycopy(insertStr, insertP, buf.bytes, buf.dataEnd, insertLen);
        buf.dataEnd += insertLen;
        if (transcoding != null && transcoding.transcoder.compatibility.isEncoder()) {
            System.arraycopy(transcoding.readBuf, transcoding.recognizedLength, buf.bytes, buf.dataEnd, transcoding.readAgainLength);
            buf.dataEnd += transcoding.readAgainLength;
            transcoding.readAgainLength = 0;
        }
        return 0;
    }

    static {
        for (CaseInsensitiveBytesHash caseInsensitiveBytesHash : TranscoderDB.transcoders) {
            for (Hash.HashEntry destinationEntry : caseInsensitiveBytesHash.entryIterator()) {
                TranscoderDB.Entry e = (TranscoderDB.Entry)destinationEntry.value;
                String sourceName = new String(e.getSource()).toUpperCase();
                String destinationName = new String(e.getDestination()).toUpperCase();
                Transcoder transcoder = e.getTranscoder();
                allTranscoders.putIfAbsent(sourceName, new HashMap());
                Map<String, Transcoder> fromSource = allTranscoders.get(sourceName);
                fromSource.put(destinationName, transcoder);
            }
        }
        try {
            Method m = EConv.class.getDeclaredMethod("convertInternal", byte[].class, Ptr.class, Integer.TYPE, byte[].class, Ptr.class, Integer.TYPE, Integer.TYPE);
            m.setAccessible(true);
            convertInternalMethodHandle = MethodHandles.lookup().unreflect(m);
            m.setAccessible(false);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t);
        }
    }
}

