/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.exceptions.OutsideOfStringException;

public class ReverseSourcePositionNode
extends FormatNode {
    private boolean star;
    private final ConditionProfile rangeProfile = ConditionProfile.createBinaryProfile();

    public ReverseSourcePositionNode(boolean star) {
        this.star = star;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int position = this.getSourcePosition(frame);
        if (this.star) {
            int remaining = this.getSourceLength(frame) - position;
            int target = position - remaining;
            if (this.rangeProfile.profile(target < 0)) {
                throw new OutsideOfStringException();
            }
            this.setSourcePosition(frame, target);
        } else {
            if (this.rangeProfile.profile(position == 0)) {
                throw new OutsideOfStringException();
            }
            this.setSourcePosition(frame, position - 1);
        }
        return null;
    }
}

