

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Simplify routes (simplify){/block}
  {block name=body}{literal}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Simplify routes (simplify)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_stack.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_swap.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_simplify"></a>Simplify routes (simplify)</h2></div></div></div><p> 
The Simplify filter is used to simplify routes and tracks for use with 
formats that limit the number of points they can contain or just to 
reduce the complexity of a route.
</p><p>
The filter attempts to remove points from each route until the number 
of points or the error is within the given bounds, while also attempting 
to preserve the shape of the original route as much as possible.  
</p><p> 
The quality of the results will vary depending on the density of points 
in the original route and the length of the original route.
</p><p> 
For example, suppose you have a route from Street Atlas 2003 that you 
wish to use with a Magellan GPS receiver that only supports up to 50 points 
in a route:
</p><p><strong class="userinput"><code>gpsbabel -r -i saroute -f RoadTrip.anr -x simplify,count=50 -o magellan  -F grocery.rte</code></strong></p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_simplify_o_count"></a>count option</h3></div></div></div><p>
      Maximum number of points in route.
    </p><p>
This option specifies the maximum number of points which may appear in the
simplified route.  For example, if you specify "count=50", all resulting
routes will contain 50 points or fewer.  
</p><p>
You must specify either this option or the <code class="option">error</code> option.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_simplify_o_error"></a>error option</h3></div></div></div><p>
      Maximum error.
    </p><p>
This option specifies the maximum allowable error that may be introduced
by removing a single point. Used with the <code class="option">length</code>
and <code class="option">crosstrack</code> methods, the value of this option is a distance,
specified in miles by default.  You may also specify the distance in 
kilometers by adding a 'k' to the end of the number.
For the <code class="option">relative</code> method it is a dimensionless quantity.
</p><p> 
How the error is determined depends on whether the <code class="option">length</code>,
<code class="option">crosstrack</code>, or <code class="option">relative</code> method is used.
If you are using the length method, the error is the change in the length of
the route introduced by removing a point.  If you are using the crosstrack
method, the error is the distance from the point to the line that results if
that point is removed. If you are using the relative method, the error is the
ratio between the crosstrack error and the horizontal accuracy (derived from
HDOP data).
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_simplify_o_crosstrack"></a>crosstrack option</h3></div></div></div><p>
      Use cross-track error (default).
    </p><p>
This option instructs GPSBabel to remove points that have the smallest 
overall effect on the overall shape of the route.  Using this method, the
first point to be removed will be the one that is closest to a line drawn 
between the two points adjacent to it.
</p><p>
If neither this option nor the <code class="option">length</code> option is specified,
this is the default.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_simplify_o_length"></a>length option</h3></div></div></div><p>
      Use arclength error.
    </p><p>
This option instructs GPSBabel to simplify by removing points that cause the
smallest change in the overall length of the route first.  
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_simplify_o_relative"></a>relative option</h3></div></div></div><p>
      Use relative error.
    </p><p>
Similar to the <code class="option">crosstrack</code> method, but the error introduced by
removing a point is set into relation to its associated horizontal accuracy,
determined as 6m * HDOP. If there is timestamp information, the distance to the interpolated point between
the two neighboring points is used instead of the distance to their connecting line.
</p><p>
The effect of the relative method is similar to a combination of
the crosstrack method with the discard filter: points are removed preserving the
overall shape of the route (track), but preferably those that are unreliable.
</p></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_stack.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_swap.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Save and restore waypoint lists (stack) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Swap latitude and longitude of all loaded points (swap)</td></tr></table></div>
  
      {/literal}{/block}
  