/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCatchSection;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaToken;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiResourceList;
import org.jetbrains.kotlin.com.intellij.psi.PsiTryStatement;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public class PsiTryStatementImpl
extends CompositePsiElement
implements PsiTryStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiTryStatementImpl");
    private volatile PsiParameter[] myCachedCatchParameters;

    public PsiTryStatementImpl() {
        super(TRY_STATEMENT);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedCatchParameters = null;
    }

    @Override
    public PsiCodeBlock getTryBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(48);
    }

    @Override
    @NotNull
    public PsiCodeBlock[] getCatchBlocks() {
        ASTNode tryBlock = SourceTreeToPsiMap.psiElementToTree(this.getTryBlock());
        if (tryBlock != null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                if (PsiCodeBlock.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchBlocks"));
                }
                return PsiCodeBlock.EMPTY_ARRAY;
            }
            boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
            PsiCodeBlock[] blocks = new PsiCodeBlock[lastIncomplete ? catchSections.length - 1 : catchSections.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = catchSections[i].getCatchBlock();
            }
            if (blocks == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchBlocks"));
            }
            return blocks;
        }
        if (PsiCodeBlock.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchBlocks"));
        }
        return PsiCodeBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiParameter[] getCatchBlockParameters() {
        PsiParameter[] catchParameters = this.myCachedCatchParameters;
        if (catchParameters == null) {
            PsiCatchSection[] catchSections = this.getCatchSections();
            if (catchSections.length == 0) {
                if (PsiParameter.EMPTY_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchBlockParameters"));
                }
                return PsiParameter.EMPTY_ARRAY;
            }
            boolean lastIncomplete = catchSections[catchSections.length - 1].getCatchBlock() == null;
            int limit = lastIncomplete ? catchSections.length - 1 : catchSections.length;
            ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>();
            for (int i = 0; i < limit; ++i) {
                PsiParameter parameter = catchSections[i].getParameter();
                if (parameter == null) continue;
                parameters2.add(parameter);
            }
            catchParameters = parameters2.toArray(new PsiParameter[parameters2.size()]);
            this.myCachedCatchParameters = catchParameters;
        }
        if (catchParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchBlockParameters"));
        }
        return catchParameters;
    }

    @Override
    @NotNull
    public PsiCatchSection[] getCatchSections() {
        PsiCatchSection[] psiCatchSectionArray = (PsiCatchSection[])this.getChildrenAsPsiElements(CATCH_SECTION_BIT_SET, PsiCatchSection.ARRAY_FACTORY);
        if (psiCatchSectionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "getCatchSections"));
        }
        return psiCatchSectionArray;
    }

    @Override
    public PsiCodeBlock getFinallyBlock() {
        return (PsiCodeBlock)this.findChildByRoleAsPsiElement(52);
    }

    @Override
    public PsiResourceList getResourceList() {
        return PsiTreeUtil.getChildOfType(this, PsiResourceList.class);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 45: {
                return this.findChildByType(TRY_KEYWORD);
            }
            case 48: {
                return this.findChildByType(CODE_BLOCK);
            }
            case 47: {
                return this.findChildByType(FINALLY_KEYWORD);
            }
            case 52: 
        }
        ASTNode finallyKeyword = this.findChildByRole(47);
        if (finallyKeyword == null) {
            return null;
        }
        for (ASTNode child = finallyKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() != CODE_BLOCK) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == TRY_KEYWORD) {
            return 45;
        }
        if (i == FINALLY_KEYWORD) {
            return 47;
        }
        if (i == CATCH_SECTION) {
            return 251;
        }
        if (child.getElementType() == CODE_BLOCK) {
            int role = this.getChildRole(child, 48);
            if (role != 0) {
                return role;
            }
            return this.getChildRole(child, 52);
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTryStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state2, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "processDeclarations"));
        }
        if (state2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "processDeclarations"));
        }
        PsiResourceList resourceList = this.getResourceList();
        if (resourceList != null && lastParent instanceof PsiCodeBlock && lastParent == this.getTryBlock()) {
            return PsiImplUtil.processDeclarationsInResourceList(resourceList, processor, state2, lastParent);
        }
        return true;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        PsiCodeBlock tryBlock;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiTryStatementImpl", "deleteChildInternal"));
        }
        if (child.getPsi() instanceof PsiResourceList && this.getCatchBlocks().length == 0 && this.getFinallyBlock() == null && (tryBlock = this.getTryBlock()) != null) {
            PsiCodeBlock block = (PsiCodeBlock)this.replace(tryBlock);
            PsiJavaToken lBrace = block.getLBrace();
            PsiJavaToken rBrace = block.getRBrace();
            if (lBrace != null) {
                lBrace.delete();
            }
            if (rBrace != null) {
                rBrace.delete();
            }
            return;
        }
        super.deleteChildInternal(child);
    }

    @Override
    public String toString() {
        return "PsiTryStatement";
    }
}

