/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.io.File;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.CachingTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsListener;
import org.gradle.api.internal.changedetection.rules.DiscoveredInputsTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.InputPropertiesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.NoHistoryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.OutputFilesTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.SummaryTaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskStateChanges;
import org.gradle.api.internal.changedetection.rules.TaskTypeTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.classloader.ClassLoaderHierarchyHasher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskUpToDateState {
    private static final int MAX_OUT_OF_DATE_MESSAGES = 3;
    private TaskStateChanges inputFileChanges;
    private DiscoveredInputsListener discoveredInputsListener;
    private SummaryTaskStateChanges allTaskChanges;
    private SummaryTaskStateChanges rebuildChanges;

    public TaskUpToDateState(TaskInternal task, TaskHistoryRepository.History history, OutputFilesSnapshotter outputFilesSnapshotter, FileCollectionSnapshotterRegistry fileCollectionSnapshotterRegistry, FileCollectionFactory fileCollectionFactory, ClassLoaderHierarchyHasher classLoaderHierarchyHasher) {
        TaskExecution thisExecution = history.getCurrentExecution();
        TaskExecution lastExecution = history.getPreviousExecution();
        NoHistoryTaskStateChanges noHistoryState = new NoHistoryTaskStateChanges(lastExecution);
        TaskTypeTaskStateChanges taskTypeState = new TaskTypeTaskStateChanges(lastExecution, thisExecution, task.getPath(), task.getClass(), task.getActionClassLoaders(), classLoaderHierarchyHasher);
        InputPropertiesTaskStateChanges inputPropertiesState = new InputPropertiesTaskStateChanges(lastExecution, thisExecution, task);
        TaskStateChanges outputFileChanges = this.caching(new OutputFilesTaskStateChanges(lastExecution, thisExecution, task, fileCollectionSnapshotterRegistry, outputFilesSnapshotter));
        InputFilesTaskStateChanges directInputFileChanges = new InputFilesTaskStateChanges(lastExecution, thisExecution, task, fileCollectionSnapshotterRegistry);
        this.inputFileChanges = this.caching(directInputFileChanges);
        DiscoveredInputsTaskStateChanges discoveredChanges = new DiscoveredInputsTaskStateChanges(lastExecution, thisExecution, fileCollectionSnapshotterRegistry, fileCollectionFactory, task);
        this.discoveredInputsListener = discoveredChanges;
        TaskStateChanges discoveredInputFilesChanges = this.caching(discoveredChanges);
        this.allTaskChanges = new SummaryTaskStateChanges(3, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges, this.inputFileChanges, discoveredInputFilesChanges);
        this.rebuildChanges = new SummaryTaskStateChanges(1, noHistoryState, taskTypeState, inputPropertiesState, outputFileChanges);
    }

    private TaskStateChanges caching(TaskStateChanges wrapped) {
        return new CachingTaskStateChanges(3, wrapped);
    }

    public TaskStateChanges getInputFilesChanges() {
        return this.inputFileChanges;
    }

    public TaskStateChanges getAllTaskChanges() {
        return this.allTaskChanges;
    }

    public TaskStateChanges getRebuildChanges() {
        return this.rebuildChanges;
    }

    public void newInputs(Set<File> discoveredInputs) {
        this.discoveredInputsListener.newInputs(discoveredInputs);
    }
}

