/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.P3i;

class HallTranslation {
    char translationCode = '\u0000';
    int rotationOrder;
    int rotationShift12ths;
    P3i vectorShift12ths;
    static final String[] latticeTranslationData = new String[]{"\u0000", "unknown", "", "P", "primitive", "", "I", "body-centered", " 1n", "R", "rhombohedral", " 1r 1r", "F", "face-centered", " 1ab 1bc 1ac", "A", "A-centered", " 1bc", "B", "B-centered", " 1ac", "C", "C-centered", " 1ab", "S", "rhombohedral(S)", " 1s 1s", "T", "rhombohedral(T)", " 1t 1t"};
    static final int nLatticeTypes = latticeTranslationData.length / 3 - 1;
    private static HallTranslation[] hallTranslationTerms;

    HallTranslation(char translationCode, P3i params) {
        this.translationCode = translationCode;
        if (params != null) {
            if (params.z >= 0) {
                this.vectorShift12ths = params;
                return;
            }
            this.rotationOrder = params.x;
            this.rotationShift12ths = params.y;
        }
        this.vectorShift12ths = new P3i();
    }

    static final String getHallLatticeEquivalent(int latticeParameter) {
        char latticeCode = HallTranslation.getLatticeCode(latticeParameter);
        boolean isCentrosymmetric = latticeParameter > 0;
        return (isCentrosymmetric ? "-" : "") + latticeCode + " 1";
    }

    static final int getLatticeIndex(char latt) {
        int i = 1;
        int ipt = 3;
        while (i <= nLatticeTypes) {
            if (latticeTranslationData[ipt].charAt(0) == latt) {
                return i;
            }
            ++i;
            ipt += 3;
        }
        return 0;
    }

    static final char getLatticeCode(int latt) {
        if (latt < 0) {
            latt = -latt;
        }
        return latt == 0 ? (char)'\u0000' : (latt > nLatticeTypes ? HallTranslation.getLatticeCode(HallTranslation.getLatticeIndex((char)latt)) : latticeTranslationData[latt * 3].charAt(0));
    }

    static final String getLatticeDesignation(int latt) {
        String str;
        boolean isCentrosymmetric = latt > 0;
        String string = str = isCentrosymmetric ? "-" : "";
        if (latt < 0) {
            latt = -latt;
        }
        if (latt == 0 || latt > nLatticeTypes) {
            return "";
        }
        return str + HallTranslation.getLatticeCode(latt) + ": " + (isCentrosymmetric ? "centrosymmetric " : "") + latticeTranslationData[latt * 3 + 1];
    }

    static final String getLatticeDesignation2(char latticeCode, boolean isCentrosymmetric) {
        int latt = HallTranslation.getLatticeIndex(latticeCode);
        if (!isCentrosymmetric) {
            latt = -latt;
        }
        return HallTranslation.getLatticeDesignation(latt);
    }

    static final String getLatticeExtension(char latt, boolean isCentrosymmetric) {
        int i = 1;
        int ipt = 3;
        while (i <= nLatticeTypes) {
            if (latticeTranslationData[ipt].charAt(0) == latt) {
                return latticeTranslationData[ipt + 2] + (isCentrosymmetric ? " -1" : "");
            }
            ++i;
            ipt += 3;
        }
        return "";
    }

    private static synchronized HallTranslation[] getHallTerms() {
        HallTranslation[] hallTranslationArray;
        if (hallTranslationTerms == null) {
            hallTranslationTerms = new HallTranslation[]{new HallTranslation('a', P3i.new3(6, 0, 0)), new HallTranslation('b', P3i.new3(0, 6, 0)), new HallTranslation('c', P3i.new3(0, 0, 6)), new HallTranslation('n', P3i.new3(6, 6, 6)), new HallTranslation('u', P3i.new3(3, 0, 0)), new HallTranslation('v', P3i.new3(0, 3, 0)), new HallTranslation('w', P3i.new3(0, 0, 3)), new HallTranslation('d', P3i.new3(3, 3, 3)), new HallTranslation('1', P3i.new3(2, 6, -1)), new HallTranslation('1', P3i.new3(3, 4, -1)), new HallTranslation('2', P3i.new3(3, 8, -1)), new HallTranslation('1', P3i.new3(4, 3, -1)), new HallTranslation('3', P3i.new3(4, 9, -1)), new HallTranslation('1', P3i.new3(6, 2, -1)), new HallTranslation('2', P3i.new3(6, 4, -1)), new HallTranslation('4', P3i.new3(6, 8, -1)), new HallTranslation('5', P3i.new3(6, 10, -1)), new HallTranslation('r', P3i.new3(4, 8, 8)), new HallTranslation('s', P3i.new3(8, 8, 4)), new HallTranslation('t', P3i.new3(8, 4, 8))};
            hallTranslationArray = hallTranslationTerms;
        } else {
            hallTranslationArray = hallTranslationTerms;
        }
        return hallTranslationArray;
    }

    static HallTranslation getHallTranslation(char translationCode, int order) {
        HallTranslation ht = null;
        int i = HallTranslation.getHallTerms().length;
        while (--i >= 0) {
            HallTranslation h = hallTranslationTerms[i];
            if (h.translationCode != translationCode || h.rotationOrder != 0 && h.rotationOrder != order) continue;
            ht = new HallTranslation(translationCode, null);
            ht.translationCode = translationCode;
            ht.rotationShift12ths = h.rotationShift12ths;
            ht.vectorShift12ths = h.vectorShift12ths;
            return ht;
        }
        return ht;
    }
}

