/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFile;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.JosmRuntimeException;

public class NTV2GridShiftFileWrapper {
    public static final NTV2GridShiftFileWrapper BETA2007 = new NTV2GridShiftFileWrapper("resource://data/projection/BETA2007.gsb");
    public static final NTV2GridShiftFileWrapper ntf_rgf93 = new NTV2GridShiftFileWrapper("resource://data/projection/ntf_r93_b.gsb");
    private NTV2GridShiftFile instance;
    private final String gridFileName;

    public NTV2GridShiftFileWrapper(String string) {
        this.gridFileName = string;
    }

    public NTV2GridShiftFile getShiftFile() {
        if (this.instance == null) {
            try (CachedFile cachedFile = new CachedFile(this.gridFileName);
                 InputStream inputStream = cachedFile.getInputStream();){
                this.instance = new NTV2GridShiftFile();
                this.instance.loadGridShiftFile(inputStream, false);
            }
            catch (IOException iOException) {
                throw new JosmRuntimeException(iOException);
            }
        }
        return this.instance;
    }
}

