/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.AbstractList;
import java.util.List;

final class ValueInteropList
extends AbstractList<DebugValue> {
    private final Debugger debugger;
    private final RootNode rootNode;
    private final List<Object> list;

    ValueInteropList(Debugger debugger, RootNode rootNode, List<Object> list) {
        this.debugger = debugger;
        this.rootNode = rootNode;
        this.list = list;
    }

    @Override
    public DebugValue get(int index) {
        Object obj = this.list.get(index);
        DebugValue.HeapValue dv = new DebugValue.HeapValue(this.debugger, this.rootNode, obj);
        return dv;
    }

    @Override
    public DebugValue set(int index, DebugValue value) {
        DebugValue old = this.get(index);
        this.list.set(index, value.get());
        return old;
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

