/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.reflect.Field;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.platform.Platform;
import sun.misc.Unsafe;

@CoreClass(value="Truffle::System")
public abstract class TruffleSystemNodes {

    @CoreMethod(names={"full_memory_barrier"}, isModuleFunction=true)
    public static abstract class FullMemoryBarrierPrimitiveNode
    extends CoreMethodNode {
        private static final Unsafe U = FullMemoryBarrierPrimitiveNode.loadUnsafe();

        @Specialization
        public Object fullMemoryBarrier() {
            if (TruffleOptions.AOT) {
                throw new UnsupportedOperationException();
            }
            U.fullFence();
            return this.nil();
        }

        private static Unsafe loadUnsafe() {
            if (TruffleOptions.AOT) {
                return null;
            }
            try {
                Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                Field f = unsafeClass.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            catch (Throwable e) {
                throw new UnsupportedOperationException(e);
            }
        }
    }

    @CoreMethod(names={"synchronized"}, isModuleFunction=true, required=1, needsBlock=true)
    public static abstract class SynchronizedPrimitiveNode
    extends YieldingCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object synchronize(VirtualFrame frame, DynamicObject self, DynamicObject block) {
            DynamicObject dynamicObject = self;
            synchronized (dynamicObject) {
                return this.yield(frame, block, new Object[0]);
            }
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject hostOS() {
            return this.createString(StringOperations.encodeRope(Platform.getOSName(), UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"host_cpu"}, onSingleton=true)
    public static abstract class HostCPUNode
    extends CoreMethodNode {
        @Specialization
        public DynamicObject hostCPU() {
            return this.createString(StringOperations.encodeRope(Platform.getArchitecture(), UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"initial_environment_variables"}, onSingleton=true)
    public static abstract class InitEnvVarsNode
    extends CoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject envVars() {
            Set<String> variables = System.getenv().keySet();
            int size = variables.size();
            Encoding localeEncoding = this.getContext().getEncodingManager().getLocaleEncoding();
            Object[] store = new Object[size];
            int i = 0;
            for (String variable : variables) {
                store[i++] = this.createString(StringOperations.encodeRope(variable, localeEncoding));
            }
            return this.createArray(store, size);
        }
    }
}

