/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.language.backtrace.Activation;

@CoreClass(value="Thread::Backtrace::Location")
public class ThreadBacktraceLocationNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            if (activation.getCallNode() == null) {
                return this.coreStrings().BACKTRACE_OMITTED_LIMIT.createInstance();
            }
            Node callNode = activation.getCallNode();
            RootNode rootNode = callNode.getRootNode();
            SourceSection sourceSection = callNode.getEncapsulatingSourceSection();
            return this.createString(RopeOperations.format(this.getContext(), sourceSection.getSource().getName(), ":", sourceSection.getStartLine(), ":in `", rootNode.getName(), "'"));
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LinenoNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int lineno(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            return sourceSection.getStartLine();
        }
    }

    @CoreMethod(names={"label"})
    public static abstract class LabelNode
    extends UnaryCoreMethodNode {
        @Specialization
        public DynamicObject label(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            String methodName = activation.getMethod().getSharedMethodInfo().getName();
            return StringOperations.createString(this.getContext(), StringOperations.encodeRope(methodName, UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject path(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            if (activation.getCallNode() == null) {
                return this.coreStrings().BACKTRACE_OMITTED_LIMIT.createInstance();
            }
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            Source source = sourceSection.getSource();
            String path = source.getName();
            if (path == null) {
                return this.coreStrings().UNKNOWN.createInstance();
            }
            return this.createString(this.getContext().getRopeTable().getRope(path));
        }
    }

    @CoreMethod(names={"absolute_path"})
    public static abstract class AbsolutePathNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject absolutePath(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            if (activation.getCallNode() == null) {
                return this.coreStrings().BACKTRACE_OMITTED_LIMIT.createInstance();
            }
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            Source source = sourceSection.getSource();
            String path = source.getPath();
            if (path == null) {
                return this.coreStrings().UNKNOWN.createInstance();
            }
            return this.createString(this.getContext().getRopeTable().getRope(path));
        }
    }
}

