/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects.shared;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.language.objects.ShapeCachingGuards;
import org.jruby.truffle.language.objects.shared.ShareObjectNode;
import org.jruby.truffle.language.objects.shared.ShareObjectNodeGen;
import org.jruby.truffle.language.objects.shared.SharedObjects;
import org.jruby.truffle.language.objects.shared.WriteBarrierNodeGen;

@ImportStatic(value={ShapeCachingGuards.class})
public abstract class WriteBarrierNode
extends Node {
    protected static final int CACHE_LIMIT = 8;
    protected static final int MAX_DEPTH = 3;
    protected final int depth;

    public static WriteBarrierNode create() {
        return WriteBarrierNodeGen.create(0);
    }

    public WriteBarrierNode(int depth) {
        this.depth = depth;
    }

    public abstract void executeWriteBarrier(Object var1);

    @Specialization(guards={"value.getShape() == cachedShape", "depth < MAX_DEPTH"}, assumptions={"cachedShape.getValidAssumption()"}, limit="CACHE_LIMIT")
    protected void writeBarrierCached(DynamicObject value, @Cached(value="value.getShape()") Shape cachedShape, @Cached(value="isShared(cachedShape)") boolean alreadyShared, @Cached(value="createShareObjectNode(alreadyShared)") ShareObjectNode shareObjectNode) {
        if (!alreadyShared) {
            shareObjectNode.executeShare(value);
        }
    }

    @Specialization(guards={"updateShape(value)"})
    public void updateShapeAndWriteBarrier(DynamicObject value) {
        this.executeWriteBarrier(value);
    }

    @Specialization(contains={"writeBarrierCached", "updateShapeAndWriteBarrier"})
    protected void writeBarrierUncached(DynamicObject value) {
        SharedObjects.writeBarrier(value);
    }

    @Specialization(guards={"!isDynamicObject(value)"})
    protected void noWriteBarrier(Object value) {
        assert (value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Double) : value.getClass().getName();
    }

    protected static boolean isDynamicObject(Object value) {
        return value instanceof DynamicObject;
    }

    protected static boolean isShared(Shape shape) {
        return SharedObjects.isShared(shape);
    }

    protected ShareObjectNode createShareObjectNode(boolean alreadyShared) {
        if (!alreadyShared) {
            return ShareObjectNodeGen.create(this.depth + 1);
        }
        return null;
    }
}

