/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.ast;

import java.util.List;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.language.SourceIndexLength;
import org.jruby.truffle.parser.ParserByteList;
import org.jruby.truffle.parser.ParserByteListBuilder;
import org.jruby.truffle.parser.ast.NodeType;
import org.jruby.truffle.parser.ast.ParseNode;
import org.jruby.truffle.parser.ast.SideEffectFree;
import org.jruby.truffle.parser.ast.types.ILiteralNode;
import org.jruby.truffle.parser.ast.visitor.NodeVisitor;

public class StrParseNode
extends ParseNode
implements ILiteralNode,
SideEffectFree {
    private ParserByteList value;
    private final CodeRange codeRange;
    private boolean frozen;

    public StrParseNode(SourceIndexLength position, ParserByteList value) {
        this(position, value, value.codeRangeScan());
    }

    public StrParseNode(SourceIndexLength position, ParserByteList value, CodeRange codeRange) {
        super(position, false);
        this.value = value;
        this.codeRange = codeRange;
    }

    public StrParseNode(SourceIndexLength position, StrParseNode head, StrParseNode tail) {
        super(position, false);
        ParserByteList headBL = head.getValue();
        ParserByteList tailBL = tail.getValue();
        ParserByteListBuilder myValue = new ParserByteListBuilder();
        myValue.setEncoding(headBL.getEncoding());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.frozen = head.isFrozen() && tail.isFrozen();
        this.value = myValue.toParserByteList();
        this.codeRange = this.value.codeRangeScan();
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public ParserByteList getValue() {
        return this.value;
    }

    public CodeRange getCodeRange() {
        return this.codeRange;
    }

    @Override
    public List<ParseNode> childNodes() {
        return EMPTY_LIST;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public void setValue(ParserByteList value) {
        this.value = value;
    }
}

