/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io.win32;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.win32.FileInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaWin32 {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.io.win32.IdeaWin32");
    private static final boolean TRACE_ENABLED = LOG.isTraceEnabled();
    private static final IdeaWin32 ourInstance;

    private static boolean loadBundledLibrary() throws IOException {
        String name2 = SystemInfo.is64Bit ? "IdeaWin64" : "IdeaWin32";
        URL bundled = IdeaWin32.class.getResource(name2 + ".dll");
        if (bundled == null) {
            return false;
        }
        byte[] content = FileUtil.loadBytes(bundled.openStream());
        CRC32 crc32 = new CRC32();
        crc32.update(content);
        long hash = Math.abs(crc32.getValue());
        File file2 = new File(FileUtil.getTempDirectory(), name2 + '.' + hash + ".dll");
        if (!file2.exists()) {
            FileUtil.writeToFile(file2, content);
        }
        System.load(file2.getPath());
        return true;
    }

    public static boolean isAvailable() {
        return ourInstance != null;
    }

    @NotNull
    public static IdeaWin32 getInstance() {
        if (!IdeaWin32.isAvailable()) {
            throw new IllegalStateException("Native filesystem for Windows is not loaded");
        }
        IdeaWin32 ideaWin32 = ourInstance;
        if (ideaWin32 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/win32/IdeaWin32", "getInstance"));
        }
        return ideaWin32;
    }

    private IdeaWin32() {
        IdeaWin32.initIDs();
    }

    private static native void initIDs();

    @Nullable
    public FileInfo getInfo(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/util/io/win32/IdeaWin32", "getInfo"));
        }
        path = path.replace('/', '\\');
        if (TRACE_ENABLED) {
            LOG.trace("getInfo(" + path + ")");
            long t = System.nanoTime();
            FileInfo result2 = this.getInfo0(path);
            t = (System.nanoTime() - t) / 1000L;
            LOG.trace("  " + t + " mks");
            return result2;
        }
        return this.getInfo0(path);
    }

    private native FileInfo getInfo0(String var1);

    static {
        IdeaWin32 instance = null;
        if (SystemInfo.isWin2kOrNewer && SystemProperties.getBooleanProperty("idea.use.native.fs.for.win", true)) {
            try {
                if (!IdeaWin32.loadBundledLibrary()) {
                    UrlClassLoader.loadPlatformLibrary("IdeaWin32");
                }
                instance = new IdeaWin32();
                LOG.info("Native filesystem for Windows is operational");
            }
            catch (Throwable t) {
                LOG.warn("Failed to initialize native filesystem for Windows", t);
            }
        }
        ourInstance = instance;
    }
}

