/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader {
    private static final boolean HAS_PARALLEL_LOADERS;
    private static final boolean ourClassPathIndexEnabled;
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final WeakStringInterner myClassNameInterner;
    private final boolean myAllowBootstrapResources;

    public static boolean isRegisteredAsParallelCapable(@NotNull ClassLoader loader) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loader", "com/intellij/util/lang/UrlClassLoader", "isRegisteredAsParallelCapable"));
        }
        if (!HAS_PARALLEL_LOADERS) {
            return false;
        }
        try {
            Field parallelLockMap = ClassLoader.class.getDeclaredField("parallelLockMap");
            parallelLockMap.setAccessible(true);
            return parallelLockMap.get(loader) != null;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Internal error: ClassLoader implementation has been altered");
        }
    }

    @NotNull
    protected ClassPath getClassPath() {
        ClassPath classPath = this.myClassPath;
        if (classPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/UrlClassLoader", "getClassPath"));
        }
        return classPath;
    }

    public static Builder build() {
        return new Builder();
    }

    protected UrlClassLoader(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/lang/UrlClassLoader", "<init>"));
        }
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
        this.myClassNameInterner = UrlClassLoader.isRegisteredAsParallelCapable(this) ? new WeakStringInterner() : null;
    }

    @NotNull
    protected final ClassPath createClassPath(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/lang/UrlClassLoader", "createClassPath"));
        }
        ClassPath classPath = new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition);
        if (classPath == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/lang/UrlClassLoader", "createClassPath"));
        }
        return classPath;
    }

    public static URL internProtocol(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/lang/UrlClassLoader", "internProtocol"));
        }
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    protected Class findClass(String name2) throws ClassNotFoundException {
        Resource res2 = this.getClassPath().getResource(name2.replace('.', '/').concat(".class"), false);
        if (res2 == null) {
            throw new ClassNotFoundException(name2);
        }
        try {
            return this.defineClass(name2, res2);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
    }

    @Nullable
    protected Class _findClass(@NotNull String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/lang/UrlClassLoader", "_findClass"));
        }
        Resource res2 = this.getClassPath().getResource(name2.replace('.', '/').concat(".class"), false);
        if (res2 == null) {
            return null;
        }
        try {
            return this.defineClass(name2, res2);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name2, Resource res2) throws IOException {
        String pkgName;
        Package pkg;
        int i = name2.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name2.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, res2.getValue(Resource.Attribute.SPEC_TITLE), res2.getValue(Resource.Attribute.SPEC_VERSION), res2.getValue(Resource.Attribute.SPEC_VENDOR), res2.getValue(Resource.Attribute.IMPL_TITLE), res2.getValue(Resource.Attribute.IMPL_VERSION), res2.getValue(Resource.Attribute.IMPL_VENDOR), null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        byte[] b = res2.getBytes();
        return this._defineClass(name2, b);
    }

    protected Class _defineClass(String name2, byte[] b) {
        return this.defineClass(name2, b, 0, b.length);
    }

    @Override
    @Nullable
    public URL findResource(String name2) {
        return this.findResourceImpl(name2);
    }

    protected URL findResourceImpl(String name2) {
        Resource res2 = this._getResource(name2);
        return res2 != null ? res2.getURL() : null;
    }

    @Nullable
    private Resource _getResource(String name2) {
        String n = name2;
        n = StringUtil.trimStart(n, "/");
        return this.getClassPath().getResource(n, true);
    }

    @Override
    @Nullable
    public InputStream getResourceAsStream(String name2) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name2);
        }
        try {
            Resource res2 = this._getResource(name2);
            if (res2 == null) {
                return null;
            }
            return res2.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name2) throws IOException {
        return this.getClassPath().getResources(name2, true);
    }

    public static void loadPlatformLibrary(@NotNull String libName) {
        if (libName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libName", "com/intellij/util/lang/UrlClassLoader", "loadPlatformLibrary"));
        }
        String libFileName = UrlClassLoader.mapLibraryName(libName);
        String libPath = PathManager.getBinPath() + "/" + libFileName;
        if (!new File(libPath).exists()) {
            String platform = UrlClassLoader.getPlatformName();
            libPath = PathManager.getHomePath() + "/community/bin/" + platform + libFileName;
            if (!(new File(libPath).exists() || new File(libPath = PathManager.getHomePath() + "/bin/" + platform + libFileName).exists() || new File(libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName).exists())) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    private static String mapLibraryName(String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win/";
        }
        if (SystemInfo.isMac) {
            return "mac/";
        }
        if (SystemInfo.isLinux) {
            return "linux/";
        }
        return "";
    }

    static {
        boolean bl = HAS_PARALLEL_LOADERS = SystemInfo.isJavaVersionAtLeast("1.7") && !SystemInfo.isIbmJvm;
        if (HAS_PARALLEL_LOADERS) {
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                registerAsParallelCapable.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ourClassPathIndexEnabled = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(@NotNull URL var1);
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent = null;
        private boolean myLockJars = false;
        private boolean myUseCache = false;
        private boolean myUsePersistentClasspathIndex = false;
        private boolean myAcceptUnescaped = false;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources = false;
        @Nullable
        private CachePoolImpl myCachePool = null;
        @Nullable
        private CachingCondition myCachingCondition = null;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }
    }
}

