/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.resolve.lazy.ResolveSessionUtils;

public class KtPropertyElementType
extends KtStubElementType<KotlinPropertyStub, KtProperty> {
    public KtPropertyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "<init>"));
        }
        super(debugName, KtProperty.class, KotlinPropertyStub.class);
    }

    @Override
    public KotlinPropertyStub createStub(@NotNull KtProperty psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "createStub"));
        }
        assert (!psi.isLocal()) : String.format("Should not store local property: %s, parent %s", psi.getText(), psi.getParent() != null ? psi.getParent().getText() : "<no parent>");
        return new KotlinPropertyStubImpl(parentStub, StringRef.fromString(psi.getName()), psi.isVar(), psi.isTopLevel(), psi.hasDelegate(), psi.hasDelegateExpression(), psi.hasInitializer(), psi.getReceiverTypeReference() != null, psi.getTypeReference() != null, ResolveSessionUtils.safeFqNameForLazyResolve(psi));
    }

    @Override
    public void serialize(@NotNull KotlinPropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isVar());
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.hasDelegate());
        dataStream.writeBoolean(stub.hasDelegateExpression());
        dataStream.writeBoolean(stub.hasInitializer());
        dataStream.writeBoolean(stub.isExtension());
        dataStream.writeBoolean(stub.hasReturnTypeRef());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.asString() : null);
    }

    @Override
    @NotNull
    public KotlinPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "deserialize"));
        }
        StringRef name2 = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        boolean hasDelegate = dataStream.readBoolean();
        boolean hasDelegateExpression = dataStream.readBoolean();
        boolean hasInitializer = dataStream.readBoolean();
        boolean hasReceiverTypeRef = dataStream.readBoolean();
        boolean hasReturnTypeRef = dataStream.readBoolean();
        StringRef fqNameAsString = dataStream.readName();
        FqName fqName2 = fqNameAsString != null ? new FqName(fqNameAsString.toString()) : null;
        KotlinPropertyStubImpl kotlinPropertyStubImpl = new KotlinPropertyStubImpl(parentStub, name2, isVar, isTopLevel, hasDelegate, hasDelegateExpression, hasInitializer, hasReceiverTypeRef, hasReturnTypeRef, fqName2);
        if (kotlinPropertyStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "deserialize"));
        }
        return kotlinPropertyStubImpl;
    }

    @Override
    public void indexStub(@NotNull KotlinPropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/kotlin/psi/stubs/elements/KtPropertyElementType", "indexStub"));
        }
        StubIndexService.getInstance().indexProperty(stub, sink);
    }
}

