/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.SimpleDeclarationChecker;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/KClassWithIncorrectTypeArgumentChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/SimpleDeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isKClassWithBadArgument", "", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "kotlin-compiler"})
public final class KClassWithIncorrectTypeArgumentChecker
implements SimpleDeclarationChecker {
    public static final KClassWithIncorrectTypeArgumentChecker INSTANCE;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext) {
        Object typeParameterWithoutNotNullableUpperBound;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        if (!(descriptor2 instanceof CallableMemberDescriptor) || Intrinsics.areEqual(((CallableMemberDescriptor)descriptor2).getVisibility(), Visibilities.LOCAL)) {
            return;
        }
        if (!(declaration instanceof KtCallableDeclaration) || ((KtCallableDeclaration)declaration).getTypeReference() != null) {
            return;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType = kotlinType;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        TypeUtilsKt.contains(returnType, (Function1<? super UnwrappedType, Boolean>)new Function1<UnwrappedType, Boolean>(descriptor2, (Ref.ObjectRef)typeParameterWithoutNotNullableUpperBound){
            final /* synthetic */ DeclarationDescriptor $descriptor;
            final /* synthetic */ Ref.ObjectRef $typeParameterWithoutNotNullableUpperBound;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull UnwrappedType type2) {
                void var2_2;
                block1: {
                    Object object;
                    Intrinsics.checkParameterIsNotNull(type2, "type");
                    boolean kClassWithBadArgument = KClassWithIncorrectTypeArgumentChecker.access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker.INSTANCE, type2);
                    if (!kClassWithBadArgument || (object = CollectionsKt.singleOrNull(type2.getArguments())) == null || (object = object.getType()) == null || (object = ((KotlinType)object).getConstructor()) == null || (object = object.getDeclarationDescriptor()) == null) break block1;
                    Object object2 = object;
                    ClassifierDescriptor it = (ClassifierDescriptor)object2;
                    if (it instanceof TypeParameterDescriptor && Intrinsics.areEqual(((TypeParameterDescriptor)it).getContainingDeclaration(), this.$descriptor)) {
                        this.$typeParameterWithoutNotNullableUpperBound.element = (TypeParameterDescriptor)it;
                    }
                }
                return (boolean)var2_2;
            }
            {
                this.$descriptor = declarationDescriptor;
                this.$typeParameterWithoutNotNullableUpperBound = objectRef;
                super(1);
            }
        });
        if ((TypeParameterDescriptor)typeParameterWithoutNotNullableUpperBound.element != null) {
            PsiElement psiElement = declaration;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)typeParameterWithoutNotNullableUpperBound.element;
            if (typeParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            diagnosticHolder.report(Errors.KCLASS_WITH_NULLABLE_TYPE_PARAMETER_IN_SIGNATURE.on((KtNamedDeclaration)psiElement, typeParameterDescriptor));
        }
        typeParameterWithoutNotNullableUpperBound = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isKClassWithBadArgument(@NotNull UnwrappedType $receiver) {
        TypeProjection typeProjection = CollectionsKt.singleOrNull($receiver.getArguments());
        Object object = typeProjection;
        if (typeProjection == null) return false;
        Object object2 = object;
        TypeProjection it = object2;
        UnwrappedType unwrappedType = it.isStarProjection() ? null : it.getType().unwrap();
        object = unwrappedType;
        if (unwrappedType == null) return false;
        Object argumentType = object;
        ClassifierDescriptor classifierDescriptor = $receiver.getConstructor().getDeclarationDescriptor();
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) return false;
        ClassDescriptor klass2 = classDescriptor;
        if (!KotlinBuiltIns.isKClass(klass2)) return false;
        KotlinType kotlinType = (KotlinType)argumentType;
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns((KotlinType)argumentType).getAnyType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType2, "argumentType.builtIns.anyType");
        if (TypeUtilsKt.isSubtypeOf(kotlinType, simpleType2)) return false;
        return true;
    }

    private KClassWithIncorrectTypeArgumentChecker() {
        INSTANCE = this;
    }

    static {
        new KClassWithIncorrectTypeArgumentChecker();
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        SimpleDeclarationChecker.DefaultImpls.check(this, declaration, descriptor2, diagnosticHolder, bindingContext, languageVersionSettings);
    }

    public static final /* synthetic */ boolean access$isKClassWithBadArgument(KClassWithIncorrectTypeArgumentChecker $this, @NotNull UnwrappedType $receiver) {
        return $this.isKClassWithBadArgument($receiver);
    }
}

