/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.PackageIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiElementFinderImpl;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.reference.SoftReference;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.load.java.JavaClassFinderImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.jvm.GlobalSearchScopeWithModuleSources;
import org.jetbrains.kotlin.resolve.jvm.KotlinCliJavaFileManager;
import org.jetbrains.kotlin.resolve.jvm.KotlinFinderMarker;
import org.jetbrains.kotlin.resolve.jvm.KotlinSafeClassFinder;

public class KotlinJavaPsiFacade {
    private volatile KotlinPsiElementFinderWrapper[] elementFinders;
    private volatile SoftReference<PackageCache> packageCache;
    private final Project project;
    private final LightModifierList emptyModifierList;

    public static KotlinJavaPsiFacade getInstance(Project project) {
        return ServiceManager.getService(project, KotlinJavaPsiFacade.class);
    }

    public KotlinJavaPsiFacade(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "<init>"));
        }
        this.project = project;
        this.emptyModifierList = new LightModifierList(PsiManager.getInstance(project), KotlinLanguage.INSTANCE, new String[0]);
        final PsiModificationTracker modificationTracker2 = PsiManager.getInstance(project).getModificationTracker();
        MessageBus bus = project.getMessageBus();
        bus.connect().subscribe(PsiModificationTracker.TOPIC, new PsiModificationTracker.Listener(){
            private long lastTimeSeen = -1L;

            @Override
            public void modificationCountChanged() {
                long now = modificationTracker2.getJavaStructureModificationCount();
                if (this.lastTimeSeen != now) {
                    this.lastTimeSeen = now;
                    KotlinJavaPsiFacade.this.packageCache = null;
                }
            }
        });
    }

    public LightModifierList getEmptyModifierList() {
        return this.emptyModifierList;
    }

    public PsiClass findClass(@NotNull ClassId classId, @NotNull GlobalSearchScope scope) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClass"));
        }
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        String qualifiedName = classId.asSingleFqName().asString();
        if (this.shouldUseSlowResolve()) {
            PsiClass[] classes2 = this.findClassesInDumbMode(qualifiedName, scope);
            if (classes2.length != 0) {
                return classes2[0];
            }
            return null;
        }
        for (KotlinPsiElementFinderWrapper finder : this.finders()) {
            GlobalSearchScope baseScope;
            boolean isSourcesScope;
            PsiClass aClass2;
            if (finder instanceof KotlinPsiElementFinderImpl) {
                aClass2 = ((KotlinPsiElementFinderImpl)finder).findClass(classId, scope);
                if (aClass2 == null) continue;
                return aClass2;
            }
            aClass2 = finder.findClass(qualifiedName, scope);
            if (aClass2 == null) continue;
            if (scope instanceof JavaClassFinderImpl.FilterOutKotlinSourceFilesScope && !(isSourcesScope = (baseScope = ((JavaClassFinderImpl.FilterOutKotlinSourceFilesScope)scope).getBase()) instanceof GlobalSearchScopeWithModuleSources)) {
                KotlinPsiElementFinderWrapper originalFinder = finder instanceof KotlinPsiElementFinderWrapperImpl ? ((KotlinPsiElementFinderWrapperImpl)finder).getOriginal() : finder;
                boolean isAndroidDataBindingClassWriter = originalFinder.getClass().getName().equals("com.android.tools.idea.databinding.DataBindingClassFinder");
                boolean isAndroidDataBindingComponentClassWriter = originalFinder.getClass().getName().equals("com.android.tools.idea.databinding.DataBindingComponentClassFinder");
                if (isAndroidDataBindingClassWriter || isAndroidDataBindingComponentClassWriter) continue;
            }
            return aClass2;
        }
        return null;
    }

    @Nullable
    public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
        if (packageFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "knownClassNamesInPackage"));
        }
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (finders.length == 1) {
            return ((KotlinPsiElementFinderImpl)finders[0]).knownClassNamesInPackage(packageFqName);
        }
        return null;
    }

    @NotNull
    private PsiClass[] findClassesInDumbMode(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        String packageName = StringUtil.getPackageName(qualifiedName);
        PsiPackage pkg = this.findPackage(packageName, scope);
        String className2 = StringUtil.getShortName(qualifiedName);
        if (pkg == null && packageName.length() < qualifiedName.length()) {
            PsiClass[] containingClasses = this.findClassesInDumbMode(packageName, scope);
            if (containingClasses.length == 1) {
                PsiClass[] psiClassArray = PsiElementFinder.filterByName(className2, containingClasses[0].getInnerClasses());
                if (psiClassArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
                }
                return psiClassArray;
            }
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (pkg == null || !pkg.containsClassNamed(className2)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        PsiClass[] psiClassArray = pkg.findClassByShortName(className2, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findClassesInDumbMode"));
        }
        return psiClassArray;
    }

    private boolean shouldUseSlowResolve() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        return dumbService.isDumb() && dumbService.isAlternativeResolveEnabled();
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] finders() {
        KotlinPsiElementFinderWrapper[] answer = this.elementFinders;
        if (answer == null) {
            answer = this.calcFinders();
            this.elementFinders = answer;
        }
        if (answer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "finders"));
        }
        return answer;
    }

    @NotNull
    protected KotlinPsiElementFinderWrapper[] calcFinders() {
        ArrayList<KotlinPsiElementFinderWrapper> elementFinders = new ArrayList<KotlinPsiElementFinderWrapper>();
        elementFinders.add(new KotlinPsiElementFinderImpl(this.getProject()));
        List<PsiElementFinder> nonKotlinFinders = ArraysKt.filter(this.getProject().getExtensions(PsiElementFinder.EP_NAME), new Function1<PsiElementFinder, Boolean>(){

            @Override
            public Boolean invoke(PsiElementFinder finder) {
                return finder instanceof KotlinSafeClassFinder || !(finder instanceof NonClasspathClassFinder) && !(finder instanceof KotlinFinderMarker) && !(finder instanceof PsiElementFinderImpl);
            }
        });
        elementFinders.addAll(CollectionsKt.map(nonKotlinFinders, new Function1<PsiElementFinder, KotlinPsiElementFinderWrapper>(){

            @Override
            public KotlinPsiElementFinderWrapper invoke(PsiElementFinder finder) {
                return KotlinJavaPsiFacade.wrap(finder);
            }
        }));
        KotlinPsiElementFinderWrapper[] kotlinPsiElementFinderWrapperArray = elementFinders.toArray(new KotlinPsiElementFinderWrapper[elementFinders.size()]);
        if (kotlinPsiElementFinderWrapperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "calcFinders"));
        }
        return kotlinPsiElementFinderWrapperArray;
    }

    public PsiPackage findPackage(@NotNull String qualifiedName, GlobalSearchScope searchScope) {
        Pair<String, GlobalSearchScope> key;
        PsiPackage aPackage;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "findPackage"));
        }
        PackageCache cache2 = SoftReference.dereference(this.packageCache);
        if (cache2 == null) {
            cache2 = new PackageCache();
            this.packageCache = new SoftReference<PackageCache>(cache2);
        }
        if ((aPackage = (PsiPackage)cache2.packageInScopeCache.get(key = new Pair<String, GlobalSearchScope>(qualifiedName, searchScope))) != null) {
            return aPackage;
        }
        KotlinPsiElementFinderWrapper[] finders = this.filteredFinders();
        Boolean packageFoundInAllScope = (Boolean)cache2.hasPackageInAllScopeCache.get(qualifiedName);
        if (packageFoundInAllScope != null) {
            if (!packageFoundInAllScope.booleanValue()) {
                return null;
            }
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, searchScope)) == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
        } else {
            for (KotlinPsiElementFinderWrapper finder : finders) {
                aPackage = finder.findPackage(qualifiedName, searchScope);
                if (aPackage == null) continue;
                return ConcurrencyUtil.cacheOrGet(cache2.packageInScopeCache, key, aPackage);
            }
            boolean found = false;
            for (KotlinPsiElementFinderWrapper finder : finders) {
                if (finder.isSameResultForAnyScope() || (aPackage = finder.findPackage(qualifiedName, GlobalSearchScope.allScope(this.project))) == null) continue;
                found = true;
                break;
            }
            cache2.hasPackageInAllScopeCache.put(qualifiedName, found);
        }
        return null;
    }

    @NotNull
    private KotlinPsiElementFinderWrapper[] filteredFinders() {
        DumbService dumbService = DumbService.getInstance(this.getProject());
        KotlinPsiElementFinderWrapper[] finders = this.finders();
        if (dumbService.isDumb()) {
            List<KotlinPsiElementFinderWrapper> list2 = dumbService.filterByDumbAwareness(Arrays.asList(finders));
            finders = list2.toArray(new KotlinPsiElementFinderWrapper[list2.size()]);
        }
        if (finders == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "filteredFinders"));
        }
        return finders;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade", "getProject"));
        }
        return project;
    }

    public static KotlinPsiElementFinderWrapper wrap(PsiElementFinder finder) {
        return finder instanceof DumbAware ? new KotlinPsiElementFinderWrapperImplDumbAware(finder) : new KotlinPsiElementFinderWrapperImpl(finder);
    }

    static class KotlinPsiElementFinderImpl
    implements DumbAware,
    KotlinPsiElementFinderWrapper {
        private final JavaFileManager javaFileManager;
        private final boolean isCliFileManager;
        private final PsiManager psiManager;
        private final PackageIndex packageIndex;

        public KotlinPsiElementFinderImpl(Project project) {
            this.javaFileManager = KotlinPsiElementFinderImpl.findJavaFileManager(project);
            this.isCliFileManager = this.javaFileManager instanceof KotlinCliJavaFileManager;
            this.packageIndex = PackageIndex.getInstance(project);
            this.psiManager = PsiManager.getInstance(project);
        }

        @NotNull
        private static JavaFileManager findJavaFileManager(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findJavaFileManager"));
            }
            JavaFileManager javaFileManager = ServiceManager.getService(project, JavaFileManager.class);
            if (javaFileManager == null) {
                throw new IllegalStateException("JavaFileManager component is not found in project");
            }
            JavaFileManager javaFileManager2 = javaFileManager;
            if (javaFileManager2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findJavaFileManager"));
            }
            return javaFileManager2;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            return this.javaFileManager.findClass(qualifiedName, scope);
        }

        public PsiClass findClass(@NotNull ClassId classId, @NotNull GlobalSearchScope scope) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findClass"));
            }
            if (this.isCliFileManager) {
                return ((KotlinCliJavaFileManager)this.javaFileManager).findClass(classId, scope);
            }
            return this.findClass(classId.asSingleFqName().asString(), scope);
        }

        @Nullable
        public Set<String> knownClassNamesInPackage(@NotNull FqName packageFqName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "knownClassNamesInPackage"));
            }
            if (this.isCliFileManager) {
                return ((KotlinCliJavaFileManager)this.javaFileManager).knownClassNamesInPackage(packageFqName);
            }
            return null;
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findPackage"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderImpl", "findPackage"));
            }
            if (this.isCliFileManager) {
                return this.javaFileManager.findPackage(qualifiedName);
            }
            Query<VirtualFile> dirs = this.packageIndex.getDirsByPackageName(qualifiedName, true);
            return KotlinPsiElementFinderImpl.hasDirectoriesInScope(dirs, scope) ? new PsiPackageImpl(this.psiManager, qualifiedName) : null;
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return false;
        }

        private static boolean hasDirectoriesInScope(Query<VirtualFile> dirs, final GlobalSearchScope scope) {
            CommonProcessors.FindProcessor<VirtualFile> findProcessor = new CommonProcessors.FindProcessor<VirtualFile>(){

                @Override
                protected boolean accept(VirtualFile file2) {
                    return scope.accept(file2);
                }
            };
            dirs.forEach((Processor<VirtualFile>)findProcessor);
            return findProcessor.isFound();
        }
    }

    private static class KotlinPsiElementFinderWrapperImplDumbAware
    extends KotlinPsiElementFinderWrapperImpl
    implements DumbAware {
        private KotlinPsiElementFinderWrapperImplDumbAware(PsiElementFinder finder) {
            super(finder);
        }
    }

    private static class KotlinPsiElementFinderWrapperImpl
    implements KotlinPsiElementFinderWrapper {
        private final PsiElementFinder finder;

        private KotlinPsiElementFinderWrapperImpl(@NotNull PsiElementFinder finder) {
            if (finder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finder", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "<init>"));
            }
            this.finder = finder;
        }

        public PsiElementFinder getOriginal() {
            return this.finder;
        }

        @Override
        public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findClass"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findClass"));
            }
            return this.finder.findClass(qualifiedName, scope);
        }

        @Override
        public PsiPackage findPackage(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
            if (qualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findPackage"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/jvm/KotlinJavaPsiFacade$KotlinPsiElementFinderWrapperImpl", "findPackage"));
            }
            return this.finder.findPackage(qualifiedName);
        }

        @Override
        public boolean isSameResultForAnyScope() {
            return true;
        }

        public String toString() {
            return this.finder.toString();
        }
    }

    static interface KotlinPsiElementFinderWrapper {
        public PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public PsiPackage findPackage(@NotNull String var1, @NotNull GlobalSearchScope var2);

        public boolean isSameResultForAnyScope();
    }

    private static class PackageCache {
        final ConcurrentMap<Pair<String, GlobalSearchScope>, PsiPackage> packageInScopeCache = ContainerUtil.newConcurrentMap();
        final ConcurrentMap<String, Boolean> hasPackageInAllScopeCache = ContainerUtil.newConcurrentMap();

        private PackageCache() {
        }
    }
}

