/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.utils.Interner;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0007H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl;", "Lorg/jetbrains/kotlin/serialization/StringTable;", "()V", "qualifiedNames", "Lorg/jetbrains/kotlin/utils/Interner;", "Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "strings", "", "buildProto", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$StringTable;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable;", "getFqNameIndex", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptorWithTypeParameters;", "getFqNameIndexOfLocalAnonymousClass", "getPackageFqNameIndex", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getSimpleNameIndex", "name", "Lorg/jetbrains/kotlin/name/Name;", "getStringIndex", "string", "serializeTo", "", "output", "Ljava/io/OutputStream;", "FqNameProto", "kotlin-compiler"})
public class StringTableImpl
implements StringTable {
    private final Interner<String> strings = new Interner();
    private final Interner<FqNameProto> qualifiedNames = new Interner();

    public final int getSimpleNameIndex(@NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull(name2, "name");
        String string = name2.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "name.asString()");
        return this.getStringIndex(string);
    }

    @Override
    public int getStringIndex(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "string");
        return this.strings.intern(string);
    }

    @Override
    public int getFqNameIndex(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        DeclarationDescriptor containingDeclaration;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (ErrorUtils.isError(descriptor2)) {
            throw (Throwable)new IllegalStateException("Cannot get FQ name of error class: " + descriptor2);
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        DeclarationDescriptor declarationDescriptor = containingDeclaration = descriptor2.getContainingDeclaration();
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            FqName packageFqName = ((PackageFragmentDescriptor)containingDeclaration).getFqName();
            if (!packageFqName.isRoot()) {
                builder.setParentQualifiedName(this.getPackageFqNameIndex(packageFqName));
            }
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = containingDeclaration;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor2, "containingDeclaration");
            builder.setParentQualifiedName(this.getFqNameIndex((ClassifierDescriptorWithTypeParameters)declarationDescriptor2));
        } else {
            return this.getFqNameIndexOfLocalAnonymousClass(descriptor2);
        }
        String string = descriptor2.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "descriptor.name.asString()");
        builder.setShortName(this.getStringIndex(string));
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = builder;
        Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
        return this.qualifiedNames.intern(new FqNameProto(builder2));
    }

    public int getFqNameIndexOfLocalAnonymousClass(@NotNull ClassifierDescriptorWithTypeParameters descriptor2) {
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        throw (Throwable)new IllegalStateException("Cannot get FQ name of local class: " + descriptor2);
    }

    public final int getPackageFqNameIndex(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
        int result2 = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            Name name2 = segment;
            Intrinsics.checkExpressionValueIsNotNull(name2, "segment");
            builder.setShortName(this.getSimpleNameIndex(name2));
            if (result2 != -1) {
                builder.setParentQualifiedName(result2);
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder2 = builder;
            Intrinsics.checkExpressionValueIsNotNull(builder2, "builder");
            result2 = this.qualifiedNames.intern(new FqNameProto(builder2));
        }
        return result2;
    }

    @NotNull
    public final Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> buildProto() {
        ProtoBuf.StringTable.Builder strings = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            strings.addString(simpleName);
        }
        ProtoBuf.QualifiedNameTable.Builder qualifiedNames = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            qualifiedNames.addQualifiedName(fqName2.getFqName());
        }
        return new Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable>(strings.build(), qualifiedNames.build());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeTo(@NotNull OutputStream output) {
        void qualifiedNames;
        void strings;
        Intrinsics.checkParameterIsNotNull(output, "output");
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = this.buildProto();
        ProtoBuf.StringTable stringTable = pair.component1();
        ProtoBuf.QualifiedNameTable qualifiedNameTable = pair.component2();
        pair = null;
        strings.writeDelimitedTo(output);
        qualifiedNames.writeDelimitedTo(output);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/serialization/StringTableImpl$FqNameProto;", "", "fqName", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;)V", "getFqName", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$QualifiedNameTable$QualifiedName$Builder;", "equals", "", "other", "hashCode", "", "kotlin-compiler"})
    private static final class FqNameProto {
        @NotNull
        private final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public int hashCode() {
            int result2 = 13;
            result2 = 31 * result2 + this.fqName.getParentQualifiedName();
            result2 = 31 * result2 + this.fqName.getShortName();
            result2 = 31 * result2 + this.fqName.getKind().hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof FqNameProto)) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder otherFqName = ((FqNameProto)other).fqName;
            return this.fqName.getParentQualifiedName() == otherFqName.getParentQualifiedName() && this.fqName.getShortName() == otherFqName.getShortName() && Intrinsics.areEqual(this.fqName.getKind(), otherFqName.getKind());
        }

        @NotNull
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder getFqName() {
            return this.fqName;
        }

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            Intrinsics.checkParameterIsNotNull(fqName2, "fqName");
            this.fqName = fqName2;
        }
    }
}

