/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\rH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/types/expressions/SenselessComparisonChecker;", "", "()V", "checkSenselessComparisonWithNull", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "Lorg/jetbrains/kotlin/psi/KtExpression;", "right", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNullability", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "kotlin-compiler"})
public final class SenselessComparisonChecker {
    public static final SenselessComparisonChecker INSTANCE;

    @JvmStatic
    public static final void checkSenselessComparisonWithNull(@NotNull KtBinaryExpression expression, @NotNull KtExpression left, @NotNull KtExpression right, @NotNull ResolutionContext<?> context, @NotNull Function1<? super KtExpression, ? extends KotlinType> getType2, @NotNull Function1<? super DataFlowValue, ? extends Nullability> getNullability) {
        boolean bl;
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(left, "left");
        Intrinsics.checkParameterIsNotNull(right, "right");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(getType2, "getType");
        Intrinsics.checkParameterIsNotNull(getNullability, "getNullability");
        if (KtPsiUtil.isNullConstant(left)) {
            ktExpression = right;
        } else if (KtPsiUtil.isNullConstant(right)) {
            ktExpression = left;
        } else {
            return;
        }
        KtExpression expr = ktExpression;
        KotlinType type2 = getType2.invoke(expr);
        if (type2 == null || type2.isError()) {
            return;
        }
        KtOperationReferenceExpression operationSign = expression.getOperationReference();
        DataFlowValue value = DataFlowValueFactory.createDataFlowValue(expr, type2, context);
        boolean equality = Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQ) || Intrinsics.areEqual(operationSign.getReferencedNameElementType(), KtTokens.EQEQEQ);
        Nullability nullability = getNullability.invoke(value);
        if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NULL)) {
            bl = equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.NOT_NULL)) {
            bl = !equality;
        } else if (Intrinsics.areEqual((Object)nullability, (Object)Nullability.IMPOSSIBLE)) {
            bl = false;
        } else {
            return;
        }
        boolean expressionIsAlways = bl;
        context.trace.report(Errors.SENSELESS_COMPARISON.on((KtBinaryExpression)((PsiElement)expression), expression, expressionIsAlways));
    }

    private SenselessComparisonChecker() {
        INSTANCE = this;
    }

    static {
        new SenselessComparisonChecker();
    }
}

