(function(Prism) {
	Prism.languages.jade = {

		// Multiline stuff should appear before the rest

		'multiline-comment': {
			pattern: /((?:^|\n)([\t ]*))\/\/.*(\n\2[\t ]+.+)*/,
			lookbehind: true,
			alias: 'comment'
		},

		// All the tag-related part is in lookbehind
		// so that it can be highlighted by the "tag" pattern
		'multiline-script': {
			pattern: /((?:^|\n)([\t ]*)script\b.*\.[\t ]*)(\n(?:\2[\t ]+.+|\s*?(?=\n)))+/,
			lookbehind: true,
			inside: {
				rest: Prism.languages.javascript
			}
		},

		// See at the end of the file for known filters
		'filter': {
			pattern: /((?:^|\n)([\t ]*)):.+(\n(?:\2[\t ]+.+|\s*?(?=\n)))+/,
			lookbehind: true,
			inside: {
				'filter-name': {
					pattern: /^:[\w-]+/,
					alias: 'variable'
				}
			}
		},

		'multiline-plain-text': {
			pattern: /((?:^|\n)([\t ]*)[\w\-#.]+\.[\t ]*)(\n(?:\2[\t ]+.+|\s*?(?=\n)))+/,
			lookbehind: true
		},
		'markup': {
			pattern: /((?:^|\n)[\t ]*)<.+/,
			lookbehind: true,
			inside: {
				rest: Prism.languages.markup
			}
		},
		'comment': {
			pattern: /((?:^|\n)[\t ]*)\/\/.+/,
			lookbehind: true
		},
		'doctype': {
			pattern: /((?:^|\n)[\t ]*)doctype(?: .+)?/,
			lookbehind: true
		},

		// This handle all conditional and loop keywords
		'flow-control': {
			pattern: /((?:^|\n)[\t ]*)(?:if|unless|else|case|when|default|each|while)(?: .+)?/,
			lookbehind: true,
			inside: {
				'each': {
					pattern: /((?:^|\n)[\t ]*)each .+? in\b/,
					lookbehind: true,
					inside: {
						'keyword': /\b(?:each|in)\b/,
						'punctuation': /,/
					}
				},
				'branch': {
					pattern: /((?:^|\n)[\t ]*)(?:if|unless|else|case|when|default|while)/,
					lookbehind: true,
					alias: 'keyword'
				},
				rest: Prism.languages.javascript
			}
		},
		'keyword': {
			pattern: /((?:^|\n)[\t ]*)(?:block|extends|include|append|prepend)\b.+/,
			lookbehind: true
		},
		'mixin': [
			// Declaration
			{
				pattern: /((?:^|\n)[\t ]*)mixin .+/,
				lookbehind: true,
				inside: {
					'keyword': /^mixin/,
					'function': /\w+(?=\s*\(|\s*$)/,
					'punctuation': /[(),.]/
				}
			},
			// Usage
			{
				pattern: /((?:^|\n)[\t ]*)\+.+/,
				lookbehind: true,
				inside: {
					'name': {
						pattern: /^\+\w+/,
						alias: 'function'
					},
					'rest': Prism.languages.javascript
				}
			}
		],
		'script': {
			pattern: /((?:^|\n)[\t ]*script(?:(?:&[^(]+)?\([^)]+\))*) .+/,
			lookbehind: true,
			inside: {
				rest: Prism.languages.javascript
			}
		},

		'plain-text': {
				pattern: /((?:^|\n)[\t ]*(?!-)[\w\-#.]*[\w\-](?:(?:&[^(]+)?\([^)]+\))*\/?[\t ]+).+/,
				lookbehind: true
		},
		'tag': {
			pattern: /((?:^|\n)[\t ]*)(?!-)[\w\-#.]*[\w\-](?:(?:&[^(]+)?\([^)]+\))*\/?:?/,
			lookbehind: true,
			inside: {
				'attributes': [
					{
						pattern: /&[^(]+\([^)]+\)/,
						inside: {
							rest: Prism.languages.javascript
						}
					},
					{
						pattern: /\([^)]+\)/,
						inside: {
							'attr-value': {
								pattern: /(=\s*)(?:\{[^}]*\}|[^,)\n]+)/,
								lookbehind: true,
								inside: {
									rest: Prism.languages.javascript
								}
							},
							'attr-name': /[\w-]+(?=\s*!?=|\s*[,)])/,
							'punctuation': /[!=(),]/
						}
					}
				],
				'punctuation': /[:]/
			}
		},
		'code': [
			{
				pattern: /((?:^|\n)[\t ]*(?:-|!?=)).+/,
				lookbehind: true,
				inside: {
					rest: Prism.languages.javascript
				}
			}
		],
		'punctuation': /[.\-!=|]/
	};

	var filter_pattern = '((?:^|\\n)([\\t ]*)):{{filter_name}}(\\n(?:\\2[\\t ]+.+|\\s*?(?=\\n)))+';

	// Non exhaustive list of available filters and associated languages
	var filters = [
		{filter:'atpl',language:'twig'},
		{filter:'coffee',language:'coffeescript'},
		'ejs',
		'handlebars',
		'hogan',
		'less',
		'livescript',
		'markdown',
		'mustache',
		'plates',
		{filter:'sass',language:'scss'},
		'stylus',
		'swig'

	];
	var all_filters = {};
	for (var i = 0, l = filters.length; i < l; i++) {
		var filter = filters[i];
		filter = typeof filter === 'string' ? {filter: filter, language: filter} : filter;
		if (Prism.languages[filter.language]) {
			all_filters['filter-' + filter.filter] = {
				pattern: RegExp(filter_pattern.replace('{{filter_name}}', filter.filter)),
				lookbehind: true,
				inside: {
					'filter-name': {
						pattern: /^:[\w-]+/,
						alias: 'variable'
					},
					rest: Prism.languages[filter.language]
				}
			}
		}
	}

	Prism.languages.insertBefore('jade', 'filter', all_filters);

}(Prism));