/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocumentRequest;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.create.TransportCreateIndexAction;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.TransportShardBulkAction;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.TransportDeleteAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.IngestActionForwarder;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.AutoCreateIndex;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.update.TransportUpdateAction;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexClosedException;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportBulkAction
extends HandledTransportAction<BulkRequest, BulkResponse> {
    private final AutoCreateIndex autoCreateIndex;
    private final boolean allowIdGeneration;
    private final ClusterService clusterService;
    private final IngestService ingestService;
    private final TransportShardBulkAction shardBulkAction;
    private final TransportCreateIndexAction createIndexAction;
    private final LongSupplier relativeTimeProvider;
    private final IngestActionForwarder ingestForwarder;

    @Inject
    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex) {
        this(settings, threadPool, transportService, clusterService, ingestService, shardBulkAction, createIndexAction, actionFilters, indexNameExpressionResolver, autoCreateIndex, System::nanoTime);
    }

    public TransportBulkAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, TransportShardBulkAction shardBulkAction, TransportCreateIndexAction createIndexAction, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AutoCreateIndex autoCreateIndex, LongSupplier relativeTimeProvider) {
        super(settings, "indices:data/write/bulk", threadPool, transportService, actionFilters, indexNameExpressionResolver, BulkRequest::new);
        Objects.requireNonNull(relativeTimeProvider);
        this.clusterService = clusterService;
        this.ingestService = ingestService;
        this.shardBulkAction = shardBulkAction;
        this.createIndexAction = createIndexAction;
        this.autoCreateIndex = autoCreateIndex;
        this.allowIdGeneration = this.settings.getAsBoolean("action.bulk.action.allow_id_generation", true);
        this.relativeTimeProvider = relativeTimeProvider;
        this.ingestForwarder = new IngestActionForwarder(transportService);
        clusterService.addStateApplier(this.ingestForwarder);
    }

    @Override
    protected final void doExecute(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        throw new UnsupportedOperationException("task parameter is required for this operation");
    }

    @Override
    protected void doExecute(final Task task, final BulkRequest bulkRequest, final ActionListener<BulkResponse> listener) {
        if (bulkRequest.hasIndexRequestsWithPipelines()) {
            if (this.clusterService.localNode().isIngestNode()) {
                this.processBulkIndexIngestRequest(task, bulkRequest, listener);
            } else {
                this.ingestForwarder.forwardIngestRequest(BulkAction.INSTANCE, bulkRequest, listener);
            }
            return;
        }
        final long startTime = this.relativeTime();
        final AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        if (this.needToCheck()) {
            HashSet<String> autoCreateIndices = new HashSet<String>();
            for (ActionRequest request : bulkRequest.requests) {
                if (request instanceof DocumentRequest) {
                    DocumentRequest req = (DocumentRequest)((Object)request);
                    autoCreateIndices.add(req.index());
                    continue;
                }
                throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName(), new Object[0]);
            }
            final AtomicInteger counter = new AtomicInteger(autoCreateIndices.size());
            ClusterState state = this.clusterService.state();
            for (final String index : autoCreateIndices) {
                if (this.shouldAutoCreate(index, state)) {
                    CreateIndexRequest createIndexRequest = new CreateIndexRequest();
                    createIndexRequest.index(index);
                    createIndexRequest.cause("auto(bulk api)");
                    createIndexRequest.masterNodeTimeout(bulkRequest.timeout());
                    this.createIndexAction.execute(createIndexRequest, new ActionListener<CreateIndexResponse>(){

                        @Override
                        public void onResponse(CreateIndexResponse result) {
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, listener, responses);
                                }
                                catch (Exception e) {
                                    listener.onFailure(e);
                                }
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            if (!(ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException)) {
                                for (int i = 0; i < bulkRequest.requests.size(); ++i) {
                                    ActionRequest request = bulkRequest.requests.get(i);
                                    if (request == null || !TransportBulkAction.this.setResponseFailureIfIndexMatches(responses, i, request, index, e)) continue;
                                    bulkRequest.requests.set(i, null);
                                }
                            }
                            if (counter.decrementAndGet() == 0) {
                                try {
                                    TransportBulkAction.this.executeBulk(task, bulkRequest, startTime, listener, responses);
                                }
                                catch (Exception inner) {
                                    inner.addSuppressed(e);
                                    listener.onFailure(inner);
                                }
                            }
                        }
                    });
                    continue;
                }
                if (counter.decrementAndGet() != 0) continue;
                this.executeBulk(task, bulkRequest, startTime, listener, responses);
            }
        } else {
            this.executeBulk(task, bulkRequest, startTime, listener, responses);
        }
    }

    boolean needToCheck() {
        return this.autoCreateIndex.needToCheck();
    }

    boolean shouldAutoCreate(String index, ClusterState state) {
        return this.autoCreateIndex.shouldAutoCreate(index, state);
    }

    private boolean setResponseFailureIfIndexMatches(AtomicArray<BulkItemResponse> responses, int idx, ActionRequest request, String index, Exception e) {
        if (request instanceof IndexRequest) {
            IndexRequest indexRequest = (IndexRequest)request;
            if (index.equals(indexRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "index", new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e)));
                return true;
            }
        } else if (request instanceof DeleteRequest) {
            DeleteRequest deleteRequest = (DeleteRequest)request;
            if (index.equals(deleteRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "delete", new BulkItemResponse.Failure(deleteRequest.index(), deleteRequest.type(), deleteRequest.id(), e)));
                return true;
            }
        } else if (request instanceof UpdateRequest) {
            UpdateRequest updateRequest = (UpdateRequest)request;
            if (index.equals(updateRequest.index())) {
                responses.set(idx, new BulkItemResponse(idx, "update", new BulkItemResponse.Failure(updateRequest.index(), updateRequest.type(), updateRequest.id(), e)));
                return true;
            }
        } else {
            throw new ElasticsearchException("Parsed unknown request in bulk actions: " + request.getClass().getSimpleName(), new Object[0]);
        }
        return false;
    }

    public void executeBulk(BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        long startTimeNanos = this.relativeTime();
        this.executeBulk(null, bulkRequest, startTimeNanos, listener, new AtomicArray<BulkItemResponse>(bulkRequest.requests.size()));
    }

    private long buildTookInMillis(long startTimeNanos) {
        return TimeUnit.NANOSECONDS.toMillis(this.relativeTime() - startTimeNanos);
    }

    void executeBulk(Task task, BulkRequest bulkRequest, final long startTimeNanos, final ActionListener<BulkResponse> listener, final AtomicArray<BulkItemResponse> responses) {
        ShardId shardId;
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.WRITE);
        final ConcreteIndices concreteIndices = new ConcreteIndices(clusterState, this.indexNameExpressionResolver);
        MetaData metaData = clusterState.metaData();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            BulkItemResponse bulkItemResponse;
            BulkItemResponse.Failure failure;
            DocumentRequest documentRequest;
            ActionRequest request = bulkRequest.requests.get(i);
            if (request == null || this.addFailureIfIndexIsUnavailable(documentRequest = (DocumentRequest)((Object)request), bulkRequest, responses, i, concreteIndices, metaData)) continue;
            Index concreteIndex = concreteIndices.resolveIfAbsent(documentRequest);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                MappingMetaData mappingMd = null;
                IndexMetaData indexMetaData = metaData.index(concreteIndex);
                if (indexMetaData != null) {
                    mappingMd = indexMetaData.mappingOrDefault(indexRequest.type());
                }
                try {
                    indexRequest.resolveRouting(metaData);
                    indexRequest.process(mappingMd, this.allowIdGeneration, concreteIndex.getName());
                }
                catch (ElasticsearchParseException | RoutingMissingException e) {
                    BulkItemResponse.Failure failure2 = new BulkItemResponse.Failure(concreteIndex.getName(), indexRequest.type(), indexRequest.id(), e);
                    BulkItemResponse bulkItemResponse2 = new BulkItemResponse(i, "index", failure2);
                    responses.set(i, bulkItemResponse2);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            if (request instanceof DeleteRequest) {
                try {
                    TransportDeleteAction.resolveAndValidateRouting(metaData, concreteIndex.getName(), (DeleteRequest)request);
                }
                catch (RoutingMissingException e) {
                    failure = new BulkItemResponse.Failure(concreteIndex.getName(), documentRequest.type(), documentRequest.id(), e);
                    bulkItemResponse = new BulkItemResponse(i, "delete", failure);
                    responses.set(i, bulkItemResponse);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            if (request instanceof UpdateRequest) {
                try {
                    TransportUpdateAction.resolveAndValidateRouting(metaData, concreteIndex.getName(), (UpdateRequest)request);
                }
                catch (RoutingMissingException e) {
                    failure = new BulkItemResponse.Failure(concreteIndex.getName(), documentRequest.type(), documentRequest.id(), e);
                    bulkItemResponse = new BulkItemResponse(i, "update", failure);
                    responses.set(i, bulkItemResponse);
                    bulkRequest.requests.set(i, null);
                }
                continue;
            }
            throw new AssertionError((Object)("request type not supported: [" + request.getClass().getName() + "]"));
        }
        HashMap requestsByShard = new HashMap();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            List<BulkItemRequest> list;
            String concreteIndex;
            ActionRequest request = bulkRequest.requests.get(i);
            if (request instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(indexRequest.index()).getName();
                shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, indexRequest.id(), indexRequest.routing()).shardId();
                list = (ArrayList<BulkItemRequest>)requestsByShard.get(shardId);
                if (list == null) {
                    list = new ArrayList<BulkItemRequest>();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (request instanceof DeleteRequest) {
                DeleteRequest deleteRequest = (DeleteRequest)request;
                concreteIndex = concreteIndices.getConcreteIndex(deleteRequest.index()).getName();
                shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, deleteRequest.id(), deleteRequest.routing()).shardId();
                list = (List)requestsByShard.get(shardId);
                if (list == null) {
                    list = new ArrayList();
                    requestsByShard.put(shardId, list);
                }
                list.add(new BulkItemRequest(i, request));
                continue;
            }
            if (!(request instanceof UpdateRequest)) continue;
            UpdateRequest updateRequest = (UpdateRequest)request;
            concreteIndex = concreteIndices.getConcreteIndex(updateRequest.index()).getName();
            shardId = this.clusterService.operationRouting().indexShards(clusterState, concreteIndex, updateRequest.id(), updateRequest.routing()).shardId();
            list = (List)requestsByShard.get(shardId);
            if (list == null) {
                list = new ArrayList();
                requestsByShard.put(shardId, list);
            }
            list.add(new BulkItemRequest(i, request));
        }
        if (requestsByShard.isEmpty()) {
            listener.onResponse(new BulkResponse(responses.toArray((BulkItemResponse[])new BulkItemResponse[responses.length()]), this.buildTookInMillis(startTimeNanos)));
            return;
        }
        final AtomicInteger counter = new AtomicInteger(requestsByShard.size());
        String nodeId = this.clusterService.localNode().getId();
        for (Map.Entry entry : requestsByShard.entrySet()) {
            shardId = (ShardId)entry.getKey();
            final List requests = (List)entry.getValue();
            BulkShardRequest bulkShardRequest = new BulkShardRequest(shardId, bulkRequest.getRefreshPolicy(), requests.toArray(new BulkItemRequest[requests.size()]));
            bulkShardRequest.waitForActiveShards(bulkRequest.waitForActiveShards());
            bulkShardRequest.timeout(bulkRequest.timeout());
            if (task != null) {
                bulkShardRequest.setParentTask(nodeId, task.getId());
            }
            this.shardBulkAction.execute(bulkShardRequest, new ActionListener<BulkShardResponse>(){

                @Override
                public void onResponse(BulkShardResponse bulkShardResponse) {
                    for (BulkItemResponse bulkItemResponse : bulkShardResponse.getResponses()) {
                        if (bulkItemResponse.getResponse() != null) {
                            ((ReplicationResponse)bulkItemResponse.getResponse()).setShardInfo(bulkShardResponse.getShardInfo());
                        }
                        responses.set(bulkItemResponse.getItemId(), bulkItemResponse);
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    for (BulkItemRequest request : requests) {
                        String indexName = concreteIndices.getConcreteIndex(request.index()).getName();
                        if (request.request() instanceof IndexRequest) {
                            IndexRequest indexRequest = (IndexRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), indexRequest.opType().toString().toLowerCase(Locale.ENGLISH), new BulkItemResponse.Failure(indexName, indexRequest.type(), indexRequest.id(), e)));
                            continue;
                        }
                        if (request.request() instanceof DeleteRequest) {
                            DeleteRequest deleteRequest = (DeleteRequest)request.request();
                            responses.set(request.id(), new BulkItemResponse(request.id(), "delete", new BulkItemResponse.Failure(indexName, deleteRequest.type(), deleteRequest.id(), e)));
                            continue;
                        }
                        if (!(request.request() instanceof UpdateRequest)) continue;
                        UpdateRequest updateRequest = (UpdateRequest)request.request();
                        responses.set(request.id(), new BulkItemResponse(request.id(), "update", new BulkItemResponse.Failure(indexName, updateRequest.type(), updateRequest.id(), e)));
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.finishHim();
                    }
                }

                private void finishHim() {
                    listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), TransportBulkAction.this.buildTookInMillis(startTimeNanos)));
                }
            });
        }
    }

    private boolean addFailureIfIndexIsUnavailable(DocumentRequest request, BulkRequest bulkRequest, AtomicArray<BulkItemResponse> responses, int idx, ConcreteIndices concreteIndices, MetaData metaData) {
        IndexMetaData indexMetaData;
        Index concreteIndex = concreteIndices.getConcreteIndex(request.index());
        ElasticsearchException unavailableException = null;
        if (concreteIndex == null) {
            try {
                concreteIndex = concreteIndices.resolveIfAbsent(request);
            }
            catch (IndexNotFoundException | IndexClosedException ex) {
                unavailableException = ex;
            }
        }
        if (unavailableException == null && (indexMetaData = metaData.getIndexSafe(concreteIndex)).getState() == IndexMetaData.State.CLOSE) {
            unavailableException = new IndexClosedException(concreteIndex);
        }
        if (unavailableException != null) {
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(request.index(), request.type(), request.id(), unavailableException);
            String operationType = "unknown";
            if (request instanceof IndexRequest) {
                operationType = "index";
            } else if (request instanceof DeleteRequest) {
                operationType = "delete";
            } else if (request instanceof UpdateRequest) {
                operationType = "update";
            }
            BulkItemResponse bulkItemResponse = new BulkItemResponse(idx, operationType, failure);
            responses.set(idx, bulkItemResponse);
            bulkRequest.requests.set(idx, null);
            return true;
        }
        return false;
    }

    private long relativeTime() {
        return this.relativeTimeProvider.getAsLong();
    }

    void processBulkIndexIngestRequest(Task task, BulkRequest original, ActionListener<BulkResponse> listener) {
        long ingestStartTimeInNanos = System.nanoTime();
        BulkRequestModifier bulkRequestModifier = new BulkRequestModifier(original);
        this.ingestService.getPipelineExecutionService().executeBulkRequest(() -> bulkRequestModifier, (indexRequest, exception) -> {
            this.logger.debug(() -> new ParameterizedMessage("failed to execute pipeline [{}] for document [{}/{}/{}]", new Object[]{indexRequest.getPipeline(), indexRequest.index(), indexRequest.type(), indexRequest.id()}), (Throwable)exception);
            bulkRequestModifier.markCurrentItemAsFailed((Exception)exception);
        }, exception -> {
            if (exception != null) {
                this.logger.error("failed to execute pipeline for a bulk request", (Throwable)exception);
                listener.onFailure((Exception)exception);
            } else {
                long ingestTookInMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ingestStartTimeInNanos);
                BulkRequest bulkRequest = bulkRequestModifier.getBulkRequest();
                ActionListener<BulkResponse> actionListener = bulkRequestModifier.wrapActionListenerIfNeeded(ingestTookInMillis, listener);
                if (bulkRequest.requests().isEmpty()) {
                    actionListener.onResponse(new BulkResponse(new BulkItemResponse[0], 0L));
                } else {
                    this.doExecute(task, bulkRequest, actionListener);
                }
            }
        });
    }

    static final class IngestBulkResponseListener
    implements ActionListener<BulkResponse> {
        private final long ingestTookInMillis;
        private final int[] originalSlots;
        private final List<BulkItemResponse> itemResponses;
        private final ActionListener<BulkResponse> actionListener;

        IngestBulkResponseListener(long ingestTookInMillis, int[] originalSlots, List<BulkItemResponse> itemResponses, ActionListener<BulkResponse> actionListener) {
            this.ingestTookInMillis = ingestTookInMillis;
            this.itemResponses = itemResponses;
            this.actionListener = actionListener;
            this.originalSlots = originalSlots;
        }

        @Override
        public void onResponse(BulkResponse response) {
            BulkItemResponse[] items = response.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.itemResponses.add(this.originalSlots[i], response.getItems()[i]);
            }
            this.actionListener.onResponse(new BulkResponse(this.itemResponses.toArray(new BulkItemResponse[this.itemResponses.size()]), response.getTookInMillis(), this.ingestTookInMillis));
        }

        @Override
        public void onFailure(Exception e) {
            this.actionListener.onFailure(e);
        }
    }

    static final class BulkRequestModifier
    implements Iterator<ActionRequest> {
        final BulkRequest bulkRequest;
        final SparseFixedBitSet failedSlots;
        final List<BulkItemResponse> itemResponses;
        int currentSlot = -1;
        int[] originalSlots;

        BulkRequestModifier(BulkRequest bulkRequest) {
            this.bulkRequest = bulkRequest;
            this.failedSlots = new SparseFixedBitSet(bulkRequest.requests().size());
            this.itemResponses = new ArrayList<BulkItemResponse>(bulkRequest.requests().size());
        }

        @Override
        public ActionRequest next() {
            return this.bulkRequest.requests().get(++this.currentSlot);
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < this.bulkRequest.requests().size();
        }

        BulkRequest getBulkRequest() {
            if (this.itemResponses.isEmpty()) {
                return this.bulkRequest;
            }
            BulkRequest modifiedBulkRequest = new BulkRequest();
            modifiedBulkRequest.setRefreshPolicy(this.bulkRequest.getRefreshPolicy());
            modifiedBulkRequest.waitForActiveShards(this.bulkRequest.waitForActiveShards());
            modifiedBulkRequest.timeout(this.bulkRequest.timeout());
            int slot = 0;
            List<ActionRequest> requests = this.bulkRequest.requests();
            this.originalSlots = new int[requests.size()];
            for (int i = 0; i < requests.size(); ++i) {
                ActionRequest request = requests.get(i);
                if (this.failedSlots.get(i)) continue;
                modifiedBulkRequest.add(request);
                this.originalSlots[slot++] = i;
            }
            return modifiedBulkRequest;
        }

        ActionListener<BulkResponse> wrapActionListenerIfNeeded(long ingestTookInMillis, ActionListener<BulkResponse> actionListener) {
            if (this.itemResponses.isEmpty()) {
                return ActionListener.wrap(response -> actionListener.onResponse(new BulkResponse(response.getItems(), response.getTookInMillis(), ingestTookInMillis)), actionListener::onFailure);
            }
            return new IngestBulkResponseListener(ingestTookInMillis, this.originalSlots, this.itemResponses, actionListener);
        }

        void markCurrentItemAsFailed(Exception e) {
            IndexRequest indexRequest = (IndexRequest)this.bulkRequest.requests().get(this.currentSlot);
            this.failedSlots.set(this.currentSlot);
            BulkItemResponse.Failure failure = new BulkItemResponse.Failure(indexRequest.index(), indexRequest.type(), indexRequest.id(), e);
            this.itemResponses.add(new BulkItemResponse(this.currentSlot, indexRequest.opType().lowercase(), failure));
        }
    }

    private static class ConcreteIndices {
        private final ClusterState state;
        private final IndexNameExpressionResolver indexNameExpressionResolver;
        private final Map<String, Index> indices = new HashMap<String, Index>();

        ConcreteIndices(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver) {
            this.state = state;
            this.indexNameExpressionResolver = indexNameExpressionResolver;
        }

        Index getConcreteIndex(String indexOrAlias) {
            return this.indices.get(indexOrAlias);
        }

        Index resolveIfAbsent(DocumentRequest request) {
            Index concreteIndex = this.indices.get(request.index());
            if (concreteIndex == null) {
                concreteIndex = this.indexNameExpressionResolver.concreteSingleIndex(this.state, request);
                this.indices.put(request.index(), concreteIndex);
            }
            return concreteIndex;
        }
    }
}

