/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.io.stream.Writeable;

public interface WriteRequest<R extends WriteRequest<R>>
extends Streamable {
    public R setRefreshPolicy(RefreshPolicy var1);

    default public R setRefreshPolicy(String refreshPolicy) {
        if (refreshPolicy != null) {
            this.setRefreshPolicy(RefreshPolicy.parse(refreshPolicy));
        }
        return (R)this;
    }

    public RefreshPolicy getRefreshPolicy();

    public ActionRequestValidationException validate();

    public static enum RefreshPolicy implements Writeable
    {
        NONE,
        IMMEDIATE,
        WAIT_UNTIL;


        public static RefreshPolicy parse(String string) {
            switch (string) {
                case "false": {
                    return NONE;
                }
                case "": 
                case "true": {
                    return IMMEDIATE;
                }
                case "wait_for": {
                    return WAIT_UNTIL;
                }
            }
            throw new IllegalArgumentException("Unknown value for refresh: [" + string + "].");
        }

        public static RefreshPolicy readFrom(StreamInput in) throws IOException {
            return RefreshPolicy.values()[in.readByte()];
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte((byte)this.ordinal());
        }
    }
}

