/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.AbstractBigArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;

final class BigDoubleArray
extends AbstractBigArray
implements DoubleArray {
    private long[][] pages;

    public BigDoubleArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new long[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newLongPage(i);
        }
    }

    @Override
    public double get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return Double.longBitsToDouble(this.pages[pageIndex][indexInPage]);
    }

    @Override
    public double set(long index, double value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = this.pages[pageIndex];
        double ret = Double.longBitsToDouble(page[indexInPage]);
        page[indexInPage] = Double.doubleToRawLongBits(value);
        return ret;
    }

    @Override
    public double increment(long index, double inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        long[] page = this.pages[pageIndex];
        page[indexInPage] = Double.doubleToRawLongBits(Double.longBitsToDouble(page[indexInPage]) + inc);
        return page[indexInPage];
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (long[][])Arrays.copyOf(this.pages, ArrayUtil.oversize((int)numPages, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newLongPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    @Override
    public void fill(long fromIndex, long toIndex, double value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        long longBits = Double.doubleToRawLongBits(value);
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, longBits);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, longBits);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], longBits);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, longBits);
        }
    }
}

