/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetAliasesAction
extends BaseRestHandler {
    @Inject
    public RestGetAliasesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_alias/{name}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] aliases = request.paramAsStringArrayOrEmptyIfAll("name");
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestBuilderListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response, XContentBuilder builder) throws Exception {
                if (indices.length > 0 && response.getAliases().isEmpty()) {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
                }
                if (response.getAliases().isEmpty()) {
                    String message = String.format(Locale.ROOT, "alias [%s] missing", RestGetAliasesAction.toNamesString(getAliasesRequest.aliases()));
                    builder.startObject().field("error", message).field("status", RestStatus.NOT_FOUND.getStatus()).endObject();
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                builder.startObject();
                for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : response.getAliases()) {
                    builder.startObject((String)objectObjectCursor.key);
                    builder.startObject("aliases");
                    for (AliasMetaData alias : (List)objectObjectCursor.value) {
                        AliasMetaData.Builder.toXContent(alias, builder, ToXContent.EMPTY_PARAMS);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    private static String toNamesString(String ... names) {
        if (names == null || names.length == 0) {
            return "";
        }
        if (names.length == 1) {
            return names[0];
        }
        StringBuilder builder = new StringBuilder(names[0]);
        for (int i = 1; i < names.length; ++i) {
            builder.append(',').append(names[i]);
        }
        return builder.toString();
    }

    static class Fields {
        static final String ALIASES = "aliases";

        Fields() {
        }
    }
}

