/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentArtifactIdentifierSerializer
implements Serializer<ComponentArtifactIdentifier> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();

    public void write(Encoder encoder, ComponentArtifactIdentifier value) throws Exception {
        if (!(value instanceof DefaultModuleComponentArtifactIdentifier)) {
            throw new IllegalArgumentException("Unknown identifier type.");
        }
        DefaultModuleComponentArtifactIdentifier moduleComponentArtifactIdentifier = (DefaultModuleComponentArtifactIdentifier)value;
        this.componentIdentifierSerializer.write(encoder, (ComponentIdentifier)moduleComponentArtifactIdentifier.getComponentIdentifier());
        IvyArtifactName ivyArtifactName = moduleComponentArtifactIdentifier.getName();
        encoder.writeString((CharSequence)ivyArtifactName.getName());
        encoder.writeString((CharSequence)ivyArtifactName.getType());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getExtension());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getClassifier());
    }

    public ComponentArtifactIdentifier read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        String artifactName = decoder.readString();
        String type = decoder.readString();
        String extension = decoder.readNullableString();
        String classifier = decoder.readNullableString();
        return new DefaultModuleComponentArtifactIdentifier(componentIdentifier, artifactName, type, extension, classifier);
    }
}

