/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model;

import com.google.common.base.Preconditions;
import groovy.util.Node;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.util.DeprecationLogger;

public class ProjectDependency
extends AbstractClasspathEntry {
    private String gradlePath;

    public ProjectDependency(Node node) {
        super(node);
        this.assertPathIsValid();
    }

    public ProjectDependency(String path) {
        super(path);
        this.assertPathIsValid();
    }

    @Deprecated
    public ProjectDependency(String path, String gradlePath) {
        this(path);
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"ProjectDependency(String path, String gradlePath)", (String)"Please use ProjectDependency(String path) instead.");
        this.gradlePath = gradlePath;
    }

    @Deprecated
    public String getGradlePath() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"ProjectDependency.getGradlePath()");
        return this.gradlePath;
    }

    @Deprecated
    public void setGradlePath(String gradlePath) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"ProjectDependency.setGradlePath(String)");
        this.gradlePath = gradlePath;
    }

    private void assertPathIsValid() {
        Preconditions.checkArgument((boolean)this.path.startsWith("/"));
    }

    @Override
    public String getKind() {
        return "src";
    }

    @Override
    public String toString() {
        return "ProjectDependency" + super.toString();
    }
}

