/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.resolve.TargetPlatformKt;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;

public abstract class JsConfig {
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager;
    private final List<KtFile> sourceFilesFromLibraries;
    @NotNull
    protected final List<KotlinJavascriptMetadata> metadata;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors;
    private boolean initialized;

    protected JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        this.storageManager = new LockBasedStorageManager();
        this.sourceFilesFromLibraries = new SmartList<KtFile>();
        this.metadata = new SmartList<KotlinJavascriptMetadata>();
        this.moduleDescriptors = null;
        this.initialized = false;
        this.project = project;
        this.configuration = configuration;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getConfiguration"));
        }
        return compilerConfiguration;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string = this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        if (moduleKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleKind"));
        }
        return moduleKind;
    }

    public abstract boolean checkLibFilesAndReportErrors(@NotNull Function1<String, Unit> var1);

    protected abstract void init(@NotNull List<KtFile> var1, @NotNull List<KotlinJavascriptMetadata> var2);

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.moduleDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
            }
            return list2;
        }
        this.moduleDescriptors = new SmartList<JsModuleDescriptor<ModuleDescriptorImpl>>();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(descriptor2);
            kotlinModuleDescriptors.add(descriptor2.getData());
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
        }
        return list3;
    }

    @NotNull
    private List<KtFile> getSourceFilesFromLibraries() {
        this.init();
        List<KtFile> list2 = this.sourceFilesFromLibraries;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceFilesFromLibraries"));
        }
        return list2;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.init(this.sourceFilesFromLibraries, this.metadata);
        this.initialized = true;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        assert (metadata.isAbiVersionCompatible()) : "expected abi version " + KotlinJavascriptMetadataUtils.ABI_VERSION + ", but metadata.abiVersion = " + metadata.getAbiVersion();
        ModuleDescriptorImpl moduleDescriptor = TargetPlatformKt.createModule(JsPlatform.INSTANCE, Name.special("<" + metadata.getModuleName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns());
        JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(metadata.getBody(), this.storageManager, moduleDescriptor, new CompilerDeserializationConfiguration(this.configuration.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, LanguageVersionSettingsImpl.DEFAULT)));
        PackageFragmentProvider provider = rawDescriptor.getData();
        moduleDescriptor.initialize(provider != null ? provider : PackageFragmentProvider.Empty.INSTANCE);
        return rawDescriptor.copy(moduleDescriptor);
    }

    private static void setDependencies(ModuleDescriptorImpl module, List<ModuleDescriptorImpl> modules) {
        module.setDependencies(CollectionsKt.plus(modules, JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    @NotNull
    public static Collection<KtFile> withJsLibAdded(@NotNull Collection<KtFile> files, @NotNull JsConfig config) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        ArrayList<KtFile> allFiles = Lists.newArrayList();
        allFiles.addAll(files);
        allFiles.addAll(config.getSourceFilesFromLibraries());
        ArrayList<KtFile> arrayList = allFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        return arrayList;
    }
}

